/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.addonpack.parser;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.threetag.palladium.addonpack.builder.AddonBuilder;
import net.threetag.palladium.addonpack.builder.ParticleTypeBuilder;
import net.threetag.palladium.addonpack.parser.AddonParser;
import net.threetag.palladium.addonpack.parser.ParticleTypeParserClient;
import net.threetag.palladium.util.json.GsonUtil;
import net.threetag.palladiumcore.util.Platform;

public class ParticleTypeParser
extends AddonParser<ParticleType<?>> {
    public ParticleTypeParser() {
        super(GSON, "particle_types", Registries.f_256890_);
    }

    @Override
    public AddonBuilder<ParticleType<?>> parse(ResourceLocation id, JsonElement jsonElement) {
        JsonObject json = GsonHelper.m_13918_((JsonElement)jsonElement, (String)"$");
        ParticleTypeBuilder builder = new ParticleTypeBuilder(id);
        GsonUtil.ifHasKey(json, "override_limiter", el -> builder.enableOverrideLimiter(GsonHelper.m_13877_((JsonElement)el, (String)"override_limiter")));
        if (Platform.isClient()) {
            GsonUtil.ifHasKey(json, "render_type", el -> {
                String renderTypeS = GsonHelper.m_13805_((JsonElement)el, (String)"render_type");
                ParticleTypeBuilder.RenderType renderType = ParticleTypeBuilder.RenderType.byName(renderTypeS);
                if (renderType == null) {
                    throw new JsonParseException("Unknown particle render type '" + renderTypeS + "'");
                }
                builder.renderType(renderType);
            });
            GsonUtil.ifHasKey(json, "texture_type", el -> {
                String textureTypeS = GsonHelper.m_13805_((JsonElement)el, (String)"texture_type");
                ParticleTypeBuilder.TextureType textureType = ParticleTypeBuilder.TextureType.byName(textureTypeS);
                if (textureType == null) {
                    throw new JsonParseException("Unknown particle texture type '" + textureTypeS + "'");
                }
                builder.textureType(textureType);
            });
            GsonUtil.ifHasKey(json, "lifetime", el -> builder.lifetime(GsonHelper.m_13897_((JsonElement)el, (String)"lifetime")));
            GsonUtil.ifHasKey(json, "has_physics", el -> builder.hasPhysics(GsonHelper.m_13877_((JsonElement)el, (String)"has_physics")));
            GsonUtil.ifHasKey(json, "gravity", el -> builder.gravity(GsonHelper.m_13888_((JsonElement)el, (String)"gravity")));
            GsonUtil.ifHasKey(json, "quad_size", el -> builder.quadSize(GsonHelper.m_13888_((JsonElement)el, (String)"quad_size")));
            GsonUtil.ifHasKey(json, "brightness", el -> builder.brightness(GsonHelper.m_13897_((JsonElement)el, (String)"brightness")));
        }
        return builder;
    }

    @Override
    public void postRegister(AddonBuilder<ParticleType<?>> addonBuilder) {
        if (Platform.isClient()) {
            ParticleTypeParserClient.registerProvider(addonBuilder);
        }
    }
}

