/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.addonpack.parser;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import net.threetag.palladium.addonpack.parser.AddonParser;
import net.threetag.palladium.documentation.HTMLBuilder;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.util.json.GsonUtil;
import net.threetag.palladiumcore.item.SimpleToolTier;

public class ToolTierParser
extends SimpleJsonResourceReloadListener {
    private static final Map<ResourceLocation, Tier> TIERS = new HashMap<ResourceLocation, Tier>();

    public ToolTierParser() {
        super(AddonParser.GSON, "tool_tiers");
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler) {
        ToolTierParser.registerToolTier(new ResourceLocation("wood"), (Tier)Tiers.WOOD);
        ToolTierParser.registerToolTier(new ResourceLocation("stone"), (Tier)Tiers.STONE);
        ToolTierParser.registerToolTier(new ResourceLocation("iron"), (Tier)Tiers.IRON);
        ToolTierParser.registerToolTier(new ResourceLocation("gold"), (Tier)Tiers.GOLD);
        ToolTierParser.registerToolTier(new ResourceLocation("diamond"), (Tier)Tiers.DIAMOND);
        ToolTierParser.registerToolTier(new ResourceLocation("netherite"), (Tier)Tiers.NETHERITE);
        AtomicInteger i = new AtomicInteger();
        object.forEach((id, jsonElement) -> {
            try {
                JsonObject json = GsonHelper.m_13918_((JsonElement)jsonElement, (String)"$");
                SimpleToolTier toolTier = ToolTierParser.parse(id, json);
                ToolTierParser.registerToolTier(id, (Tier)toolTier);
                i.getAndIncrement();
            }
            catch (Exception e) {
                CrashReport crashReport = CrashReport.m_127521_((Throwable)e, (String)("Error while parsing addonpack tool tier  '" + String.valueOf(id) + "'"));
                CrashReportCategory reportCategory = crashReport.m_127516_("Addon Tool Tier", 1);
                reportCategory.m_128159_("Resource name", id);
                throw new ReportedException(crashReport);
            }
        });
        AddonPackLog.info("Registered " + i.get() + " addonpack tool tiers", new Object[0]);
    }

    public static void registerToolTier(ResourceLocation id, Tier tier) {
        TIERS.put(id, tier);
    }

    public static Tier getToolTier(ResourceLocation id) {
        return TIERS.get(id);
    }

    public static Set<ResourceLocation> getIds() {
        return TIERS.keySet();
    }

    public static SimpleToolTier parse(ResourceLocation id, JsonObject json) {
        return new SimpleToolTier(GsonUtil.getAsIntMin(json, "level", 0), GsonUtil.getAsIntMin(json, "uses", 1), GsonUtil.getAsFloatMin(json, "speed", 0.0f), GsonUtil.getAsFloatMin(json, "attack_damage_bonus", 0.0f), GsonUtil.getAsIntMin(json, "enchantment_value", 0), () -> json.has("repair_ingredient") ? Ingredient.m_43917_((JsonElement)json.get("repair_ingredient")) : Ingredient.f_43901_);
    }

    public static HTMLBuilder documentationBuilder() {
        JsonDocumentationBuilder builder = new JsonDocumentationBuilder().setDescription("Each tool type goes into a seperate file into the 'addon/[namespace]/tool_tiers' folder, which can then be used for custom tools (swords, pickaxes, etc.).");
        builder.addProperty("level", Integer.class).description("Determines the mining level and what blocks can be harvested. For reference: iron has 2, diamond has 3. So obsidian can only be mined with tools with the level 3 or above, thats why you need a diamond pickaxe for it").required().exampleJson((JsonElement)new JsonPrimitive((Number)2));
        builder.addProperty("uses", Integer.class).description("Determines the durability for tool. For reference: iron has 250, diamond has 1561").required().exampleJson((JsonElement)new JsonPrimitive((Number)420));
        builder.addProperty("speed", Float.class).description("Determines the mining speed. For reference: iron has 6.0, diamond has 8.0").required().exampleJson((JsonElement)new JsonPrimitive((Number)Float.valueOf(6.9f)));
        builder.addProperty("attack_damage_bonus", Float.class).description("Determines the additional attack damage. For reference: iron has 2.0, diamond has 3.0").required().exampleJson((JsonElement)new JsonPrimitive((Number)Float.valueOf(2.5f)));
        builder.addProperty("enchantment_value", Integer.class).description("Determines the enchantibility of the item. For reference: iron has 9, diamond 10, gold 25.").required().exampleJson((JsonElement)new JsonPrimitive((Number)12));
        builder.addProperty("repair_ingredient", Ingredient.class).description("Ingredient definition for repairing the item in an anvil. Can be defined like in recipes.").fallback(Ingredient.f_43901_, "empty ingredient").exampleJson(Ingredient.m_204132_((TagKey)ItemTags.f_198160_).m_43942_());
        return new HTMLBuilder(new ResourceLocation("palladium", "tool_tiers"), "Tool Tiers").add(HTMLBuilder.heading("Tool Tiers")).addDocumentation(builder);
    }
}

