/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.addonpack.parser;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.threetag.palladium.addonpack.parser.AddonParser;
import net.threetag.palladium.entity.BasicItemListing;
import net.threetag.palladium.util.json.GsonUtil;
import net.threetag.palladiumcore.event.LifecycleEvents;
import net.threetag.palladiumcore.registry.VillagerTradeRegistry;

public class VillagerTradeParser
extends SimpleJsonResourceReloadListener {
    private Map<ResourceLocation, JsonObject> trades = ImmutableMap.of();

    public VillagerTradeParser() {
        super(AddonParser.GSON, "villager_trades");
        LifecycleEvents.SETUP.register(() -> {
            for (JsonObject json : this.trades.values()) {
                ResourceLocation profId = GsonUtil.getAsResourceLocation(json, "villager_profession");
                ArrayList listings = new ArrayList();
                GsonUtil.forEachInListOrPrimitive(json.get("trades"), el -> {
                    JsonObject tradeJson = GsonHelper.m_13918_((JsonElement)el, (String)"trades");
                    listings.add(VillagerTradeParser.parseListing(tradeJson));
                });
                if (profId.toString().equals("minecraft:wandering_trader")) {
                    boolean rare = GsonHelper.m_13855_((JsonObject)json, (String)"rare", (boolean)false);
                    VillagerTradeRegistry.registerForWanderingTrader((boolean)rare, (VillagerTrades.ItemListing[])listings.toArray(new BasicItemListing[0]));
                    continue;
                }
                if (BuiltInRegistries.f_256735_.m_7804_(profId)) {
                    VillagerTradeRegistry.registerForProfession((VillagerProfession)((VillagerProfession)BuiltInRegistries.f_256735_.m_7745_(profId)), (int)GsonUtil.getAsIntMin(json, "level", 1), (VillagerTrades.ItemListing[])listings.toArray(new BasicItemListing[0]));
                    continue;
                }
                throw new JsonParseException("Unknown villager profession " + String.valueOf(profId));
            }
        });
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        object.forEach((id, jsonElement) -> {
            JsonObject json = GsonHelper.m_13918_((JsonElement)jsonElement, (String)"top element");
            builder.put(id, (Object)json);
        });
        this.trades = builder.build();
    }

    public static BasicItemListing parseListing(JsonObject json) {
        ItemStack price = GsonUtil.getAsItemStack(json, "price");
        ItemStack price2 = GsonUtil.getAsItemStack(json, "price_2", ItemStack.f_41583_);
        ItemStack forSale = GsonUtil.getAsItemStack(json, "for_sale");
        int maxTrades = GsonUtil.getAsIntMin(json, "max_trades", 1);
        int xp = GsonUtil.getAsIntMin(json, "max_trades", 0);
        float priceMult = GsonHelper.m_13820_((JsonObject)json, (String)"price_multiplier", (float)1.0f);
        return new BasicItemListing(price, price2, forSale, maxTrades, xp, priceMult);
    }
}

