/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.palladium.client.screen.AbilityBarRenderer;
import net.threetag.palladium.client.screen.AbilityWheelRenderer;
import net.threetag.palladium.network.AbilityKeyPressedMessage;
import net.threetag.palladium.network.NotifyMovementKeyListenerMessage;
import net.threetag.palladium.network.ToggleOpenableEquipmentMessage;
import net.threetag.palladium.power.ability.Abilities;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityConfiguration;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AbilityUtil;
import net.threetag.palladium.util.property.PalladiumProperties;
import net.threetag.palladiumcore.event.ClientTickEvents;
import net.threetag.palladiumcore.event.EventResult;
import net.threetag.palladiumcore.event.InputEvents;
import net.threetag.palladiumcore.registry.client.KeyMappingRegistry;

@OnlyIn(value=Dist.CLIENT)
public class PalladiumKeyMappings
implements InputEvents.KeyPressed,
ClientTickEvents.ClientTick,
InputEvents.MouseScrolling {
    public static final String CATEGORY = "key.palladium.categories.abilities";
    public static final KeyMapping OPEN_EQUIPMENT = new KeyMapping("key.palladium.open_equipment", 47, "key.categories.gameplay");
    public static final KeyMapping SWITCH_ABILITY_LIST = new KeyMapping("key.palladium.switch_ability_list", 88, "key.palladium.categories.abilities");
    public static AbilityKeyMapping[] ABILITY_KEYS = new AbilityKeyMapping[5];
    public static AbilityInstance LEFT_CLICKED_ABILITY = null;
    public static AbilityInstance RIGHT_CLICKED_ABILITY = null;
    public static AbilityInstance SPACE_BAR_ABILITY = null;

    public static void init() {
        KeyMappingRegistry.register((KeyMapping)OPEN_EQUIPMENT);
        KeyMappingRegistry.register((KeyMapping)SWITCH_ABILITY_LIST);
        for (int i = 1; i <= ABILITY_KEYS.length; ++i) {
            AbilityKeyMapping abilityKeyMapping = new AbilityKeyMapping("key.palladium.ability_" + i, i == 1 ? 86 : (i == 2 ? 66 : (i == 3 ? 78 : (i == 4 ? 77 : (i == 5 ? 44 : -1)))), CATEGORY, i);
            PalladiumKeyMappings.ABILITY_KEYS[i - 1] = abilityKeyMapping;
            KeyMappingRegistry.register((KeyMapping)abilityKeyMapping);
        }
        PalladiumKeyMappings instance = new PalladiumKeyMappings();
        InputEvents.KEY_PRESSED.register((Object)instance);
        InputEvents.MOUSE_SCROLLING.register((Object)instance);
        ClientTickEvents.CLIENT_POST.register((Object)instance);
    }

    public void keyPressed(Minecraft client, int keyCode, int scanCode, int action, int modifiers) {
        if (client.f_91074_ != null && client.f_91080_ == null && !client.f_91074_.m_5833_()) {
            AbilityInstance entry;
            if (OPEN_EQUIPMENT.m_90857_()) {
                new ToggleOpenableEquipmentMessage().send();
                return;
            }
            if (SWITCH_ABILITY_LIST.m_90857_()) {
                AbilityBarRenderer.scroll(!client.f_91074_.m_6047_());
                return;
            }
            AbilityBarRenderer.AbilityList list = AbilityBarRenderer.getSelectedList();
            if (list != null && action != 2) {
                for (AbilityKeyMapping key : ABILITY_KEYS) {
                    AbilityInstance entry2 = list.getDisplayedAbilities()[key.index - 1];
                    if (entry2 == null || action == 1 && entry2.getConfiguration().needsEmptyHand() && !client.f_91074_.m_21205_().m_41619_()) continue;
                    if (key.m_90832_(keyCode, scanCode) && entry2.getConfiguration().getKeyType() == AbilityConfiguration.KeyType.KEY_BIND) {
                        new AbilityKeyPressedMessage(entry2.getReference(), action == 1).send();
                        continue;
                    }
                    if (entry2.getConfiguration().getKeyType() != AbilityConfiguration.KeyType.SPACE_BAR || !client.f_91066_.f_92089_.m_90832_(keyCode, scanCode)) continue;
                    new AbilityKeyPressedMessage(entry2.getReference(), action == 1).send();
                    return;
                }
            }
            if (SPACE_BAR_ABILITY == null && client.f_91066_.f_92089_.m_90857_() && (entry = PalladiumKeyMappings.getPrioritisedKeyedAbility(AbilityConfiguration.KeyType.SPACE_BAR)) != null && entry.isUnlocked() && (!entry.getConfiguration().needsEmptyHand() || client.f_91074_.m_21205_().m_41619_())) {
                AbilityConfiguration.KeyPressType pressType = entry.getConfiguration().getKeyPressType();
                if (pressType == AbilityConfiguration.KeyPressType.ACTION) {
                    if (!entry.isOnCooldown()) {
                        new AbilityKeyPressedMessage(entry.getReference(), true).send();
                        SPACE_BAR_ABILITY = entry;
                    }
                } else if (pressType == AbilityConfiguration.KeyPressType.ACTIVATION) {
                    if (!entry.isOnCooldown() && !entry.isEnabled()) {
                        new AbilityKeyPressedMessage(entry.getReference(), true).send();
                        SPACE_BAR_ABILITY = entry;
                    }
                } else {
                    new AbilityKeyPressedMessage(entry.getReference(), true).send();
                    SPACE_BAR_ABILITY = entry;
                }
            }
            if (PalladiumProperties.JUMP_KEY_DOWN.isRegistered((Entity)client.f_91074_) && client.f_91066_.f_92089_.m_90857_() != PalladiumProperties.JUMP_KEY_DOWN.get((Entity)client.f_91074_).booleanValue()) {
                new NotifyMovementKeyListenerMessage(0, client.f_91066_.f_92089_.m_90857_()).send();
            }
            if (PalladiumProperties.LEFT_KEY_DOWN.isRegistered((Entity)client.f_91074_) && client.f_91066_.f_92086_.m_90857_() != PalladiumProperties.LEFT_KEY_DOWN.get((Entity)client.f_91074_).booleanValue()) {
                new NotifyMovementKeyListenerMessage(1, client.f_91066_.f_92086_.m_90857_()).send();
            }
            if (PalladiumProperties.RIGHT_KEY_DOWN.isRegistered((Entity)client.f_91074_) && client.f_91066_.f_92088_.m_90857_() != PalladiumProperties.RIGHT_KEY_DOWN.get((Entity)client.f_91074_).booleanValue()) {
                new NotifyMovementKeyListenerMessage(2, client.f_91066_.f_92088_.m_90857_()).send();
            }
            if (PalladiumProperties.FORWARD_KEY_DOWN.isRegistered((Entity)client.f_91074_) && client.f_91066_.f_92085_.m_90857_() != PalladiumProperties.FORWARD_KEY_DOWN.get((Entity)client.f_91074_).booleanValue()) {
                new NotifyMovementKeyListenerMessage(3, client.f_91066_.f_92085_.m_90857_()).send();
            }
            if (PalladiumProperties.BACKWARDS_KEY_DOWN.isRegistered((Entity)client.f_91074_) && client.f_91066_.f_92087_.m_90857_() != PalladiumProperties.BACKWARDS_KEY_DOWN.get((Entity)client.f_91074_).booleanValue()) {
                new NotifyMovementKeyListenerMessage(4, client.f_91066_.f_92087_.m_90857_()).send();
            }
        }
    }

    public EventResult mouseScrolling(Minecraft client, double scrollDelta, boolean leftDown, boolean middleDown, boolean rightDown, double mouseX, double mouseY) {
        LocalPlayer player = Objects.requireNonNull(client.f_91074_);
        if (AbilityUtil.isTypeEnabled((LivingEntity)player, (Ability)Abilities.DISABLE_HOTBAR_SCROLL.get())) {
            return EventResult.cancel();
        }
        List<AbilityInstance> activeToggles = AbilityUtil.getInstances((LivingEntity)player).stream().filter(e -> e.getConfiguration().getKeyPressType() == AbilityConfiguration.KeyPressType.TOGGLE && e.getConfiguration().getKeyType().toString().toLowerCase(Locale.ROOT).startsWith("scroll") && e.isEnabled()).toList();
        for (AbilityInstance active : activeToggles) {
            if (!(active.getConfiguration().getKeyType() == AbilityConfiguration.KeyType.SCROLL_UP && scrollDelta < 0.0 || active.getConfiguration().getKeyType() == AbilityConfiguration.KeyType.SCROLL_DOWN && scrollDelta > 0.0) && (active.getConfiguration().getKeyType() != AbilityConfiguration.KeyType.SCROLL_EITHER || scrollDelta == 0.0)) continue;
            new AbilityKeyPressedMessage(active.getReference(), true).send();
            return EventResult.cancel();
        }
        if (AbilityWheelRenderer.CURRENT_WHEEL != null && !AbilityWheelRenderer.CURRENT_WHEEL.disablesMouseScrolling()) {
            AbilityWheelRenderer.CURRENT_WHEEL.scroll(scrollDelta < 0.0);
            return EventResult.cancel();
        }
        AbilityInstance entry = null;
        if (scrollDelta > 0.0) {
            entry = PalladiumKeyMappings.getPrioritisedKeyedAbility(AbilityConfiguration.KeyType.SCROLL_UP);
        } else if (scrollDelta < 0.0) {
            entry = PalladiumKeyMappings.getPrioritisedKeyedAbility(AbilityConfiguration.KeyType.SCROLL_DOWN);
        }
        if (entry == null) {
            entry = PalladiumKeyMappings.getPrioritisedKeyedAbility(AbilityConfiguration.KeyType.SCROLL_EITHER);
        }
        if (entry != null && entry.isUnlocked() && (!entry.getConfiguration().needsEmptyHand() || player.m_21205_().m_41619_())) {
            AbilityConfiguration.KeyPressType pressType = entry.getConfiguration().getKeyPressType();
            if (pressType == AbilityConfiguration.KeyPressType.ACTION) {
                if (!entry.isOnCooldown()) {
                    new AbilityKeyPressedMessage(entry.getReference(), true).send();
                    return EventResult.cancel();
                }
            } else if (pressType == AbilityConfiguration.KeyPressType.ACTIVATION) {
                if (!entry.isOnCooldown() && !entry.isEnabled()) {
                    new AbilityKeyPressedMessage(entry.getReference(), true).send();
                    return EventResult.cancel();
                }
            } else if (pressType == AbilityConfiguration.KeyPressType.TOGGLE) {
                new AbilityKeyPressedMessage(entry.getReference(), true).send();
                return EventResult.cancel();
            }
        }
        return EventResult.pass();
    }

    public void clientTick(Minecraft minecraft) {
        if (minecraft.f_91074_ != null && minecraft.f_91080_ == null && !minecraft.f_91074_.m_5833_()) {
            if (LEFT_CLICKED_ABILITY != null && !minecraft.f_91066_.f_92096_.m_90857_()) {
                new AbilityKeyPressedMessage(LEFT_CLICKED_ABILITY.getReference(), false).send();
                LEFT_CLICKED_ABILITY = null;
            }
            if (RIGHT_CLICKED_ABILITY != null && !minecraft.f_91066_.f_92095_.m_90857_()) {
                new AbilityKeyPressedMessage(RIGHT_CLICKED_ABILITY.getReference(), false).send();
                RIGHT_CLICKED_ABILITY = null;
            }
            if (SPACE_BAR_ABILITY != null && !minecraft.f_91066_.f_92089_.m_90857_()) {
                new AbilityKeyPressedMessage(SPACE_BAR_ABILITY.getReference(), false).send();
                SPACE_BAR_ABILITY = null;
            }
        }
    }

    public static AbilityInstance getPrioritisedKeyedAbility(AbilityConfiguration.KeyType keyType) {
        AbilityBarRenderer.AbilityList list = AbilityBarRenderer.getSelectedList();
        if (list != null) {
            for (AbilityInstance ability : list.getDisplayedAbilities()) {
                if (ability == null || !ability.isUnlocked() || ability.getConfiguration().getKeyType() != keyType || ability.getConfiguration().getKeyType().toString().toLowerCase(Locale.ROOT).startsWith("scroll") && ability.getConfiguration().allowScrollWhenCrouching() && Objects.requireNonNull(Minecraft.m_91087_().f_91074_).m_6047_()) continue;
                return ability;
            }
        }
        for (AbilityInstance entry : AbilityUtil.getInstances((LivingEntity)Minecraft.m_91087_().f_91074_)) {
            if (entry == null || !entry.isUnlocked() || entry.getConfiguration().getKeyType() != keyType || entry.getConfiguration().getKeyType().toString().toLowerCase(Locale.ROOT).startsWith("scroll") && entry.getConfiguration().allowScrollWhenCrouching() && Objects.requireNonNull(Minecraft.m_91087_().f_91074_).m_6047_()) continue;
            return entry;
        }
        return null;
    }

    public static class AbilityKeyMapping
    extends KeyMapping {
        public final int index;

        public AbilityKeyMapping(String description, int keyCode, String category, int index) {
            super(description, keyCode, category);
            this.index = index;
        }
    }
}

