/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.dynamictexture;

import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.palladium.client.dynamictexture.DynamicTexture;
import net.threetag.palladium.client.dynamictexture.DynamicTextureManager;
import net.threetag.palladium.util.context.DataContext;
import org.jetbrains.annotations.Nullable;

public class TextureReference {
    private final boolean dynamic;
    private final ResourceLocation path;

    private TextureReference(boolean dynamic, ResourceLocation path) {
        this.dynamic = dynamic;
        this.path = path;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public ResourceLocation getTexture(DataContext context) {
        if (this.dynamic) {
            DynamicTexture dyn = DynamicTextureManager.INSTANCE.get(this.path);
            return dyn != null ? dyn.getTexture(context) : null;
        }
        return this.path;
    }

    public static TextureReference normal(ResourceLocation path) {
        return new TextureReference(false, path);
    }

    public static TextureReference dynamic(ResourceLocation path) {
        return new TextureReference(true, path);
    }

    public static TextureReference parse(String path) {
        if (path.startsWith("#")) {
            return TextureReference.dynamic(new ResourceLocation(path.substring(1)));
        }
        return TextureReference.normal(new ResourceLocation(path));
    }

    public void toBuffer(FriendlyByteBuf buf) {
        buf.writeBoolean(this.dynamic);
        buf.m_130085_(this.path);
    }

    public static TextureReference fromBuffer(FriendlyByteBuf buf) {
        return new TextureReference(buf.readBoolean(), buf.m_130281_());
    }

    public String toString() {
        return (this.dynamic ? "#" : "") + this.path.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextureReference that = (TextureReference)o;
        return this.dynamic == that.dynamic && Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.dynamic, this.path);
    }
}

