/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.dynamictexture.transformer;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.FastColor;
import net.threetag.palladium.client.dynamictexture.transformer.ITextureTransformer;
import net.threetag.palladium.util.context.DataContext;

public record OverlayTextureTransformer(String overlayLocation, boolean ignoreBlank) implements ITextureTransformer
{
    @Override
    public NativeImage transform(DataContext context, NativeImage texture, ResourceManager manager, Function<String, String> stringConverter) throws IOException {
        NativeImage overlay = NativeImage.m_85058_((InputStream)((Resource)manager.m_213713_(new ResourceLocation(stringConverter.apply(this.overlayLocation))).get()).m_215507_());
        for (int y = 0; y < overlay.m_85084_(); ++y) {
            for (int x = 0; x < overlay.m_84982_(); ++x) {
                this.blendPixel(texture, x, y, overlay.m_84985_(x, y));
            }
        }
        return texture;
    }

    public void blendPixel(NativeImage texture, int x, int y, int abgrColor) {
        if (texture.m_85102_() != NativeImage.Format.RGBA) {
            throw new UnsupportedOperationException("Can only call blendPixel with RGBA format");
        }
        int i = texture.m_84985_(x, y);
        float f = (float)FastColor.ABGR32.m_266503_((int)abgrColor) / 255.0f;
        float g = (float)FastColor.ABGR32.m_266247_((int)abgrColor) / 255.0f;
        float h = (float)FastColor.ABGR32.m_266446_((int)abgrColor) / 255.0f;
        float j = (float)FastColor.ABGR32.m_266313_((int)abgrColor) / 255.0f;
        float k = (float)FastColor.ABGR32.m_266503_((int)i) / 255.0f;
        float l = (float)FastColor.ABGR32.m_266247_((int)i) / 255.0f;
        float m = (float)FastColor.ABGR32.m_266446_((int)i) / 255.0f;
        float n = (float)FastColor.ABGR32.m_266313_((int)i) / 255.0f;
        if (k == 0.0f & this.ignoreBlank) {
            return;
        }
        float p = 1.0f - f;
        float q = f * f + k * p;
        float r = g * f + l * p;
        float s = h * f + m * p;
        float t = j * f + n * p;
        if (q > 1.0f) {
            q = 1.0f;
        }
        if (r > 1.0f) {
            r = 1.0f;
        }
        if (s > 1.0f) {
            s = 1.0f;
        }
        if (t > 1.0f) {
            t = 1.0f;
        }
        int u = (int)(q * 255.0f);
        int v = (int)(r * 255.0f);
        int w = (int)(s * 255.0f);
        int z = (int)(t * 255.0f);
        texture.m_84988_(x, y, FastColor.ABGR32.m_266248_((int)u, (int)v, (int)w, (int)z));
    }
}

