/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.dynamictexture.variable;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.threetag.palladium.client.dynamictexture.variable.ITextureVariable;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.util.context.DataContext;

public abstract class AbstractIntegerTextureVariable
implements ITextureVariable {
    private final List<Pair<Operation, Integer>> operations;

    public AbstractIntegerTextureVariable(List<Pair<Operation, Integer>> operations) {
        this.operations = operations;
    }

    @Override
    public Object get(DataContext context) {
        int i = this.getNumber(context);
        for (Pair<Operation, Integer> pair : this.operations) {
            i = ((Operation)((Object)pair.getFirst())).function.apply(i, (Integer)pair.getSecond());
        }
        return i;
    }

    public abstract int getNumber(DataContext var1);

    public static List<Pair<Operation, Integer>> parseOperations(JsonObject json) {
        LinkedList<Pair<Operation, Integer>> operations = new LinkedList<Pair<Operation, Integer>>();
        for (Map.Entry entry : json.entrySet()) {
            Operation operation = Operation.getOperationByName((String)entry.getKey());
            if (operation == null) continue;
            operations.add((Pair<Operation, Integer>)Pair.of((Object)((Object)operation), (Object)((JsonElement)entry.getValue()).getAsInt()));
        }
        return operations;
    }

    public static void addDocumentationFields(JsonDocumentationBuilder builder) {
        builder.addProperty("add", Integer.class).description("This value will be added on top of the returned value.").fallback(null).exampleJson((JsonElement)new JsonPrimitive((Number)5));
        builder.addProperty("subtract", Integer.class).description("This value will be subtracted from the returned value.").fallback(null).exampleJson((JsonElement)new JsonPrimitive((Number)3));
        builder.addProperty("multiply", Integer.class).description("This value will be subtracted with the returned value.").fallback(null).exampleJson((JsonElement)new JsonPrimitive((Number)10));
        builder.addProperty("divide", Integer.class).description("This value will be divided to the returned value.").fallback(null).exampleJson((JsonElement)new JsonPrimitive((Number)10));
        builder.addProperty("min", Integer.class).description("Using this value will set a minimum limit for the returned value.").fallback(null).exampleJson((JsonElement)new JsonPrimitive((Number)1));
        builder.addProperty("max", Integer.class).description("Using this value will set a maximum limit for the returned value.").fallback(null).exampleJson((JsonElement)new JsonPrimitive((Number)100));
        builder.addProperty("modulo", Integer.class).description("Using this value will apply a modulo operation to the returned value.").fallback(null).exampleJson((JsonElement)new JsonPrimitive((Number)5));
    }

    public static enum Operation {
        ADD("add", Integer::sum),
        SUBTRACT("subtract", (input, subtract) -> input - subtract),
        MULTIPLY("multiply", (input, multiply) -> input * multiply),
        DIVIDE("divide", (input, multiply) -> input / multiply),
        MIN("min", Integer::max),
        MAX("max", Integer::min),
        MODULO("modulo", (input, modulo) -> input % modulo);

        private final String name;
        private final BiFunction<Integer, Integer, Integer> function;

        private Operation(String name, BiFunction<Integer, Integer, Integer> function) {
            this.name = name;
            this.function = function;
        }

        public static Operation getOperationByName(String name) {
            for (Operation operation : Operation.values()) {
                if (!operation.name.equalsIgnoreCase(name)) continue;
                return operation;
            }
            return null;
        }
    }
}

