/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.dynamictexture.variable;

import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.client.dynamictexture.variable.AbstractFloatTextureVariable;
import net.threetag.palladium.client.dynamictexture.variable.ITextureVariable;
import net.threetag.palladium.client.dynamictexture.variable.ITextureVariableSerializer;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.util.context.DataContext;

public class EntityHealthTextureVariable
extends AbstractFloatTextureVariable {
    public EntityHealthTextureVariable(List<Pair<AbstractFloatTextureVariable.Operation, JsonPrimitive>> operations) {
        super(operations);
    }

    @Override
    public float getNumber(DataContext context) {
        float f;
        Entity entity = context.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            f = livingEntity.m_21223_();
        } else {
            f = 0.0f;
        }
        return f;
    }

    public static class Serializer
    implements ITextureVariableSerializer {
        @Override
        public ITextureVariable parse(JsonObject json) {
            return new EntityHealthTextureVariable(AbstractFloatTextureVariable.parseOperations(json));
        }

        @Override
        public String getDocumentationDescription() {
            return "Returns the health of the entity. The math operations can be arranged in any order and are fully optional!";
        }

        @Override
        public void addDocumentationFields(JsonDocumentationBuilder builder) {
            builder.setTitle("Entity Health");
            AbstractFloatTextureVariable.addDocumentationFields(builder);
        }

        @Override
        public ResourceLocation getId() {
            return Palladium.id("entity_health");
        }
    }
}

