/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.dynamictexture.variable;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.client.dynamictexture.variable.AbstractFloatTextureVariable;
import net.threetag.palladium.client.dynamictexture.variable.ITextureVariable;
import net.threetag.palladium.client.dynamictexture.variable.ITextureVariableSerializer;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.property.EntityPropertyHandler;
import net.threetag.palladium.util.property.FloatProperty;
import net.threetag.palladium.util.property.PalladiumProperty;

public class FloatPropertyVariable
extends AbstractFloatTextureVariable {
    private final String propertyKey;
    private final float fallbackValue;

    public FloatPropertyVariable(String propertyKey, float fallbackValue, List<Pair<AbstractFloatTextureVariable.Operation, JsonPrimitive>> operations) {
        super(operations);
        this.propertyKey = propertyKey;
        this.fallbackValue = fallbackValue;
    }

    @Override
    public float getNumber(DataContext context) {
        AtomicReference<Float> result = new AtomicReference<Float>(Float.valueOf(this.fallbackValue));
        EntityPropertyHandler.getHandler(context.getEntity()).ifPresent(handler -> {
            PalladiumProperty<?> property = handler.getPropertyByName(this.propertyKey);
            if (property instanceof FloatProperty) {
                FloatProperty floatProperty = (FloatProperty)property;
                result.set(handler.get(floatProperty));
            }
        });
        return result.get().floatValue();
    }

    public static class Serializer
    implements ITextureVariableSerializer {
        @Override
        public ITextureVariable parse(JsonObject json) {
            return new FloatPropertyVariable(GsonHelper.m_13906_((JsonObject)json, (String)"property"), GsonHelper.m_13820_((JsonObject)json, (String)"fallback", (float)0.0f), AbstractFloatTextureVariable.parseOperations(json));
        }

        @Override
        public String getDocumentationDescription() {
            return "Returns the value of a float property within the player. The math operations can be arranged in any order and are fully optional!";
        }

        @Override
        public void addDocumentationFields(JsonDocumentationBuilder builder) {
            builder.setTitle("Float Property");
            builder.addProperty("property", String.class).description("Name of the property you want the value from.").required().exampleJson((JsonElement)new JsonPrimitive("example_property"));
            builder.addProperty("fallback", Float.class).description("If the property is not found, this value will be used instead.").exampleJson((JsonElement)new JsonPrimitive((Number)Float.valueOf(0.0f)));
            AbstractFloatTextureVariable.addDocumentationFields(builder);
        }

        @Override
        public ResourceLocation getId() {
            return Palladium.id("float_property");
        }
    }
}

