/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.dynamictexture.variable;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.client.dynamictexture.variable.AbstractIntegerTextureVariable;
import net.threetag.palladium.client.dynamictexture.variable.ITextureVariable;
import net.threetag.palladium.client.dynamictexture.variable.ITextureVariableSerializer;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.item.Openable;
import net.threetag.palladium.util.context.DataContext;

public class OpenableEquipmentProgressVariable
extends AbstractIntegerTextureVariable {
    public OpenableEquipmentProgressVariable(List<Pair<AbstractIntegerTextureVariable.Operation, Integer>> operations) {
        super(operations);
    }

    @Override
    public int getNumber(DataContext context) {
        Item item;
        ItemStack item2 = context.getItem();
        if (!item2.m_41619_() && (item = item2.m_41720_()) instanceof Openable) {
            Openable openable = (Openable)item;
            return openable.getOpeningProgress(item2);
        }
        return 0;
    }

    public static class Serializer
    implements ITextureVariableSerializer {
        @Override
        public ITextureVariable parse(JsonObject json) {
            return new OpenableEquipmentProgressVariable(AbstractIntegerTextureVariable.parseOperations(json));
        }

        @Override
        public void addDocumentationFields(JsonDocumentationBuilder builder) {
            builder.setTitle("Openable Equipment Timer");
            AbstractIntegerTextureVariable.addDocumentationFields(builder);
        }

        @Override
        public String getDocumentationDescription() {
            return "When used in an item-context where the item can be opened, this returns the current progress/timer of the opening process.";
        }

        @Override
        public ResourceLocation getId() {
            return Palladium.id("openable_equipment_progress");
        }
    }
}

