/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.model;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import net.threetag.palladium.documentation.HTMLBuilder;
import net.threetag.palladium.util.BedrockModelUtil;
import net.threetag.palladium.util.json.GsonUtil;
import org.jetbrains.annotations.NotNull;

public class ModelLayerManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public ModelLayerManager() {
        super(GSON, "palladium/model_layers");
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
        HashMap jsonRoots = new HashMap();
        EntityModelSet entityModels = Minecraft.m_91087_().m_167973_();
        Map codeRoots = entityModels.f_171099_;
        HashMap roots = new HashMap(codeRoots);
        object.forEach((id, jsonElement) -> {
            ModelLayerLocation layerLocation = ModelLayerManager.mapPathToModelLayerLoc(id);
            try {
                LayerDefinition layerDefinition = ModelLayerManager.parseLayerDefinition(jsonElement.getAsJsonObject(), layerLocation != null ? layerLocation.toString() : id.toString());
                if (layerLocation != null) {
                    jsonRoots.put(layerLocation, layerDefinition);
                }
                jsonRoots.put(new ModelLayerLocation(id, "main"), layerDefinition);
            }
            catch (Exception e) {
                AddonPackLog.error("Error parsing entity model json " + String.valueOf(id), e);
            }
        });
        roots.putAll(jsonRoots);
        entityModels.f_171099_ = ImmutableMap.copyOf(roots);
        ModelLayerManager.dumpLayers();
    }

    public static LayerDefinition parseLayerDefinition(JsonObject json, String id) {
        if (GsonHelper.m_13900_((JsonObject)json, (String)"minecraft:geometry")) {
            return BedrockModelUtil.parseAsLayerDefinition(json);
        }
        AddonPackLog.warning("Model layer '" + id + "' still uses Palladium Entity Format! Please switch to Bedrock Entity Format.", new Object[0]);
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition root = meshDefinition.m_171576_();
        JsonObject parts = GsonHelper.m_13930_((JsonObject)json, (String)"mesh");
        for (Map.Entry entry : parts.entrySet()) {
            String key = (String)entry.getKey();
            JsonObject part = ((JsonElement)entry.getValue()).getAsJsonObject();
            ModelLayerManager.parseCubeListBuilder(key, root, part);
        }
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)GsonHelper.m_13927_((JsonObject)json, (String)"texture_width"), (int)GsonHelper.m_13927_((JsonObject)json, (String)"texture_height"));
    }

    public static void parseCubeListBuilder(String name, PartDefinition parent, JsonObject json) {
        JsonArray cubes = GsonHelper.m_13933_((JsonObject)json, (String)"cubes");
        CubeListBuilder builder = CubeListBuilder.m_171558_();
        for (JsonElement j : cubes) {
            JsonObject cubeJson = j.getAsJsonObject();
            float[] origin = GsonUtil.getFloatArray(cubeJson, 3, "origin");
            float[] dimensions = GsonUtil.getFloatArray(cubeJson, 3, "dimensions");
            int[] textureOffset = GsonUtil.getIntArray(cubeJson, 2, "texture_offset", 0, 0);
            float[] textureScale = GsonUtil.getFloatArray(cubeJson, 2, "texture_scale", 1.0f, 1.0f);
            float[] deformation = GsonUtil.getFloatArray(cubeJson, 3, "deformation", 0.0f, 0.0f, 0.0f);
            builder.m_171555_(GsonHelper.m_13855_((JsonObject)cubeJson, (String)"mirror", (boolean)false));
            builder.m_171514_(textureOffset[0], textureOffset[1]);
            builder.m_171496_(origin[0], origin[1], origin[2], dimensions[0], dimensions[1], dimensions[2], new CubeDeformation(deformation[0], deformation[1], deformation[2]), textureScale[0], textureScale[1]);
        }
        PartPose partPose = PartPose.f_171404_;
        if (GsonHelper.m_13900_((JsonObject)json, (String)"part_pose")) {
            JsonObject partPoseJson = GsonHelper.m_13930_((JsonObject)json, (String)"part_pose");
            float[] offset = GsonUtil.getFloatArray(partPoseJson, 3, "offset", 0.0f, 0.0f, 0.0f);
            float[] rotation1 = GsonUtil.getFloatArray(partPoseJson, 3, "rotation", 0.0f, 0.0f, 0.0f);
            double[] rotation = new double[3];
            for (int i = 0; i < 3; ++i) {
                rotation[i] = Math.toRadians(rotation1[i]);
            }
            partPose = PartPose.m_171423_((float)offset[0], (float)offset[1], (float)offset[2], (float)((float)rotation[0]), (float)((float)rotation[1]), (float)((float)rotation[2]));
        }
        PartDefinition partDefinition = parent.m_171599_(name, builder, partPose);
        if (GsonHelper.m_13900_((JsonObject)json, (String)"children")) {
            JsonObject children = GsonHelper.m_13930_((JsonObject)json, (String)"children");
            for (Map.Entry entry : children.entrySet()) {
                String key = (String)entry.getKey();
                JsonObject part = ((JsonElement)entry.getValue()).getAsJsonObject();
                ModelLayerManager.parseCubeListBuilder(key, partDefinition, part);
            }
        }
    }

    private static ModelLayerLocation mapPathToModelLayerLoc(ResourceLocation path) {
        int idx = path.m_135815_().indexOf(47);
        if (idx == -1) {
            return null;
        }
        return new ModelLayerLocation(new ResourceLocation(path.m_135827_(), path.m_135815_().substring(idx + 1)), path.m_135815_().substring(0, idx));
    }

    public static void dumpLayers() {
        File oldPlayerFile = new File(HTMLBuilder.SUBFOLDER, "palladium/models/minecraft/main/player.json");
        File oldFile = new File(HTMLBuilder.SUBFOLDER, "palladium/models/");
        File folder = new File(HTMLBuilder.SUBFOLDER, "palladium/vanilla_models/");
        if (oldPlayerFile.exists()) {
            ModelLayerManager.deleteDirectory(oldFile);
            System.out.println("HALLO DELETE");
        }
        Minecraft.m_91087_().m_167973_().f_171099_.forEach((modelLayerLocation, layerDefinition) -> {
            if (!modelLayerLocation.m_171124_().equalsIgnoreCase("main") || !modelLayerLocation.m_171123_().m_135827_().equalsIgnoreCase("minecraft")) {
                return;
            }
            File outputFile = new File(folder, modelLayerLocation.m_171123_().m_135815_() + ".json");
            try {
                JsonObject json = BedrockModelUtil.toJsonModel(layerDefinition, modelLayerLocation.toString());
                if (!outputFile.exists()) {
                    outputFile.getParentFile().mkdirs();
                }
                Files.writeString(outputFile.toPath(), (CharSequence)GSON.toJson((JsonElement)json), new OpenOption[0]);
            }
            catch (IOException e) {
                Palladium.LOGGER.error("Error while dumping model {}", (Object)outputFile, (Object)e);
            }
        });
    }

    private static void deleteDirectory(File directoryToBeDeleted) {
        File[] allContents = directoryToBeDeleted.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                ModelLayerManager.deleteDirectory(file);
            }
        }
        directoryToBeDeleted.delete();
    }
}

