/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.model;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.threetag.palladium.client.model.ExtraAnimatedModel;
import net.threetag.palladium.client.model.ImprovedHumanoidModel;
import net.threetag.palladium.entity.PalladiumPlayerExtension;
import org.joml.Vector3f;

public class ThrusterHumanoidModel<T extends LivingEntity>
extends ImprovedHumanoidModel<T>
implements ExtraAnimatedModel<T> {
    public final ModelPart rightArmThruster;
    public final ModelPart leftArmThruster;
    public final ModelPart rightLegThruster;
    public final ModelPart leftLegThruster;
    private final List<ModelPart> thrusters = new ArrayList<ModelPart>();

    public ThrusterHumanoidModel(ModelPart root) {
        super(root);
        this.rightArmThruster = this.f_102811_.m_171324_("right_arm_thruster");
        this.leftArmThruster = this.f_102812_.m_171324_("left_arm_thruster");
        this.rightLegThruster = this.f_102813_.m_171324_("right_leg_thruster");
        this.leftLegThruster = this.f_102814_.m_171324_("left_leg_thruster");
        this.thrusters.add(this.rightArmThruster);
        this.thrusters.add(this.leftArmThruster);
        this.thrusters.add(this.rightLegThruster);
        this.thrusters.add(this.leftLegThruster);
    }

    public ThrusterHumanoidModel(ModelPart root, Function<ResourceLocation, RenderType> renderType) {
        super(root, renderType);
        this.rightArmThruster = this.f_102811_.m_171324_("right_arm_thruster");
        this.leftArmThruster = this.f_102812_.m_171324_("left_arm_thruster");
        this.rightLegThruster = this.f_102813_.m_171324_("right_leg_thruster");
        this.leftLegThruster = this.f_102814_.m_171324_("left_leg_thruster");
        this.thrusters.add(this.rightArmThruster);
        this.thrusters.add(this.leftArmThruster);
        this.thrusters.add(this.rightLegThruster);
        this.thrusters.add(this.leftLegThruster);
    }

    @Override
    public void extraAnimations(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float partialTicks) {
        float f = Mth.m_14031_((float)(((float)((LivingEntity)entity).f_19797_ + partialTicks) * 3.0f)) / 10.0f;
        float v = 1.0f;
        if (entity instanceof PalladiumPlayerExtension) {
            PalladiumPlayerExtension extension = (PalladiumPlayerExtension)entity;
            v = Math.max(extension.palladium$getFlightHandler().getFlightAnimation(partialTicks) - 1.0f, 0.0f) / 2.0f;
        }
        for (ModelPart thruster : this.thrusters) {
            thruster.m_233569_();
            thruster.m_253072_(new Vector3f(f, f + v, f));
        }
    }
}

