/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.model.animation;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.palladium.client.model.animation.PalladiumAnimation;
import net.threetag.palladium.entity.FlightHandler;
import net.threetag.palladium.entity.PalladiumPlayerExtension;
import net.threetag.palladium.util.Easing;

@OnlyIn(value=Dist.CLIENT)
public class HoveringAnimation
extends PalladiumAnimation {
    public HoveringAnimation(int priority) {
        super(priority);
    }

    @Override
    public void animate(PalladiumAnimation.Builder builder, AbstractClientPlayer player, HumanoidModel<?> model, PalladiumAnimation.FirstPersonContext firstPersonContext, float partialTicks) {
        boolean active;
        boolean bl = active = !firstPersonContext.firstPerson();
        if (active && player instanceof PalladiumPlayerExtension) {
            PalladiumPlayerExtension extension = (PalladiumPlayerExtension)player;
            FlightHandler flight = extension.palladium$getFlightHandler();
            float anim = flight.getHoveringAnimation(partialTicks);
            if (anim <= 0.0f) {
                return;
            }
            FlightHandler.FlightAnimationType type = FlightHandler.getAnimationType((LivingEntity)player);
            if (type == FlightHandler.FlightAnimationType.HEROIC) {
                this.animateHeroic(builder, player, anim, partialTicks);
            } else {
                this.animateNormal(builder, player, anim, partialTicks);
            }
            this.addAttackAnimation(builder, player, model);
        }
    }

    public void animateNormal(PalladiumAnimation.Builder builder, AbstractClientPlayer player, float animationProgress, float partialTicks) {
        float hover = (float)Math.sin(((float)player.f_19797_ + partialTicks) / 10.0f);
        builder.get(PalladiumAnimation.PlayerModelPart.RIGHT_ARM).resetXRot().resetYRot().resetZRot().setYRotDegrees(7.5f).setZRotDegrees(7.5f - hover * 2.5f).animate(Easing.OUTCIRC, animationProgress);
        builder.get(PalladiumAnimation.PlayerModelPart.LEFT_ARM).resetXRot().resetYRot().resetZRot().setYRotDegrees(-7.5f).setZRotDegrees(-7.5f + hover * 2.5f).animate(Easing.OUTCIRC, animationProgress);
        builder.get(PalladiumAnimation.PlayerModelPart.RIGHT_LEG).setXRotDegrees(2.5f - hover * 5.0f).setYRotDegrees(7.5f).setZRotDegrees(2.5f).animate(Easing.OUTCIRC, animationProgress);
        builder.get(PalladiumAnimation.PlayerModelPart.LEFT_LEG).setXRotDegrees(-2.5f + hover * 5.0f).setYRotDegrees(-7.5f).setZRotDegrees(-2.5f).animate(Easing.OUTCIRC, animationProgress);
    }

    public void animateHeroic(PalladiumAnimation.Builder builder, AbstractClientPlayer player, float animationProgress, float partialTicks) {
        float hover = (float)Math.sin(((float)player.f_19797_ + partialTicks) / 10.0f);
        builder.get(PalladiumAnimation.PlayerModelPart.RIGHT_ARM).resetXRot().resetYRot().resetZRot().setXRotDegrees(-2.5f).setYRotDegrees(10.0f).setZRotDegrees(7.5f - hover * 2.5f).animate(Easing.OUTCIRC, animationProgress);
        builder.get(PalladiumAnimation.PlayerModelPart.LEFT_ARM).resetXRot().resetYRot().resetZRot().setXRotDegrees(5.0f).setYRotDegrees(-10.0f).setZRotDegrees(-7.5f + hover * 2.5f).animate(Easing.OUTCIRC, animationProgress);
        builder.get(PalladiumAnimation.PlayerModelPart.RIGHT_LEG).setX(-2.9f).setY(11.0f).setZ(-2.0f).setXRotDegrees(20.0f - hover * 5.0f).setYRotDegrees(15.0f).setZRotDegrees(-5.0f).animate(Easing.OUTCIRC, animationProgress);
        builder.get(PalladiumAnimation.PlayerModelPart.LEFT_LEG).setXRotDegrees(2.5f + hover * 5.0f).setYRotDegrees(0.0f).setZRotDegrees(-2.0f).animate(Easing.OUTCIRC, animationProgress);
    }

    protected void addAttackAnimation(PalladiumAnimation.Builder builder, AbstractClientPlayer player, HumanoidModel<?> model) {
        if (!(model.f_102608_ <= 0.0f)) {
            HumanoidArm humanoidArm = this.getAttackArm(player);
            PalladiumAnimation.PartAnimationData modelPart = humanoidArm == HumanoidArm.RIGHT ? builder.get(PalladiumAnimation.PlayerModelPart.RIGHT_ARM) : builder.get(PalladiumAnimation.PlayerModelPart.LEFT_ARM);
            float bodyYRot = model.f_102810_.f_104204_;
            builder.get(PalladiumAnimation.PlayerModelPart.RIGHT_ARM).setX(-Mth.m_14089_((float)bodyYRot) * 5.0f).setZ(Mth.m_14031_((float)bodyYRot) * 5.0f).setYRot(bodyYRot);
            builder.get(PalladiumAnimation.PlayerModelPart.LEFT_ARM).setX(Mth.m_14089_((float)bodyYRot) * 5.0f).setZ(-Mth.m_14031_((float)bodyYRot) * 5.0f).setXRot(bodyYRot).setYRot(bodyYRot);
            float f = 1.0f - model.f_102608_;
            f *= f;
            f *= f;
            f = 1.0f - f;
            float g = Mth.m_14031_((float)(f * (float)Math.PI));
            float h = Mth.m_14031_((float)(model.f_102608_ * (float)Math.PI)) * -(model.f_102808_.f_104203_ - 0.7f) * 0.75f;
            modelPart.rotateX(-(g * 1.2f + h)).rotateY(bodyYRot * 2.0f).rotateZ(Mth.m_14031_((float)(model.f_102608_ * (float)Math.PI)) * -0.4f);
        }
    }

    private HumanoidArm getAttackArm(AbstractClientPlayer player) {
        HumanoidArm humanoidArm = player.m_5737_();
        return player.f_20912_ == InteractionHand.MAIN_HAND ? humanoidArm : humanoidArm.m_20828_();
    }
}

