/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.model.animation;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.HumanoidArm;
import net.threetag.palladium.util.Easing;

public class PalladiumAnimation {
    private final int priority;

    public PalladiumAnimation(int priority) {
        this.priority = priority;
    }

    public void animate(Builder builder, AbstractClientPlayer player, HumanoidModel<?> model, FirstPersonContext firstPersonContext, float partialTicks) {
    }

    public int getPriority() {
        return this.priority;
    }

    public static class PoseStackResult {
        private float x = 0.0f;
        private float y = 0.0f;
        private float z = 0.0f;
        private float x2 = 0.0f;
        private float y2 = 0.0f;
        private float z2 = 0.0f;
        private float xRot = 0.0f;
        private float yRot = 0.0f;
        private float zRot = 0.0f;
        private float xScale = 1.0f;
        private float yScale = 1.0f;
        private float zScale = 1.0f;

        public void apply(PoseStack poseStack) {
            poseStack.m_252880_(this.x / 16.0f, this.y / 16.0f, this.z / 16.0f);
            if (this.zRot != 0.0f) {
                poseStack.m_252781_(Axis.f_252403_.m_252961_(this.zRot));
            }
            if (this.yRot != 0.0f) {
                poseStack.m_252781_(Axis.f_252436_.m_252961_(this.yRot));
            }
            if (this.xRot != 0.0f) {
                poseStack.m_252781_(Axis.f_252529_.m_252961_(this.xRot));
            }
            poseStack.m_252880_(this.x2 / 16.0f, this.y2 / 16.0f, this.z2 / 16.0f);
            if (this.xScale != 1.0f || this.yScale != 1.0f || this.zScale != 1.0f) {
                poseStack.m_85841_(this.xScale, this.yScale, this.zScale);
            }
        }
    }

    public static class PartOperation {
        private final PartOperationType type;
        private final float value;

        private PartOperation(PartOperationType type, float value) {
            this.type = type;
            this.value = value;
        }

        public void apply(ModelPart part, PartOperationTarget target, float multiplier) {
            if (this.type == PartOperationType.SET) {
                float current = target.get(part);
                target.set(part, current + (this.value - current) * multiplier);
            } else if (this.type == PartOperationType.ADD) {
                if (target.scale) {
                    target.set(part, target.get(part) * (1.0f + (this.value - 1.0f) * multiplier));
                } else {
                    target.set(part, target.get(part) + this.value * multiplier);
                }
            } else {
                float current = target.get(part);
                target.set(part, current + (target.get(part.m_233566_()) - current) * multiplier);
            }
        }

        public void apply(PoseStackResult result, PartOperationTarget target, float multiplier) {
            if (this.type == PartOperationType.SET) {
                float current = target.get(result);
                target.set(result, current + (this.value - current) * multiplier);
            } else if (this.type == PartOperationType.ADD) {
                if (target.scale) {
                    target.set(result, target.get(result) * (1.0f + (this.value - 1.0f) * multiplier));
                } else {
                    target.set(result, target.get(result) + this.value * multiplier);
                }
            } else {
                float current = target.get(result);
                target.set(result, current + (target.initial - current) * multiplier);
            }
        }
    }

    public static enum PartOperationType {
        ADD,
        ADD_INITIAL,
        SET,
        RESET;

    }

    public static enum PartOperationTarget {
        X_ROT(0.0f, false),
        Y_ROT(0.0f, false),
        Z_ROT(0.0f, false),
        X(0.0f, false),
        Y(0.0f, false),
        Z(0.0f, false),
        X2(0.0f, false),
        Y2(0.0f, false),
        Z2(0.0f, false),
        X_SCALE(1.0f, true),
        Y_SCALE(1.0f, true),
        Z_SCALE(1.0f, true);

        private final float initial;
        private final boolean scale;

        private PartOperationTarget(float initial, boolean scale) {
            this.initial = initial;
            this.scale = scale;
        }

        public float get(ModelPart part) {
            return switch (this) {
                case X_ROT -> part.f_104203_;
                case Y_ROT -> part.f_104204_;
                case Z_ROT -> part.f_104205_;
                case X -> part.f_104200_;
                case Y -> part.f_104201_;
                case Z -> part.f_104202_;
                case X_SCALE -> part.f_233553_;
                case Y_SCALE -> part.f_233554_;
                case Z_SCALE -> part.f_233555_;
                default -> 0.0f;
            };
        }

        public float get(PoseStackResult result) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case X_ROT -> result.xRot;
                case Y_ROT -> result.yRot;
                case Z_ROT -> result.zRot;
                case X -> result.x;
                case Y -> result.y;
                case Z -> result.z;
                case X2 -> result.x2;
                case Y2 -> result.y2;
                case Z2 -> result.z2;
                case X_SCALE -> result.xScale;
                case Y_SCALE -> result.yScale;
                case Z_SCALE -> result.zScale;
            };
        }

        public float get(PartPose pose) {
            return switch (this) {
                case X_ROT -> pose.f_171408_;
                case Y_ROT -> pose.f_171409_;
                case Z_ROT -> pose.f_171410_;
                case X -> pose.f_171405_;
                case Y -> pose.f_171406_;
                case Z -> pose.f_171407_;
                case X2, Y2, Z2 -> 0.0f;
                default -> 1.0f;
            };
        }

        public void set(ModelPart part, float value) {
            switch (this) {
                case X_ROT: {
                    part.f_104203_ = value;
                    break;
                }
                case Y_ROT: {
                    part.f_104204_ = value;
                    break;
                }
                case Z_ROT: {
                    part.f_104205_ = value;
                    break;
                }
                case X: {
                    part.f_104200_ = value;
                    break;
                }
                case Y: {
                    part.f_104201_ = value;
                    break;
                }
                case Z: {
                    part.f_104202_ = value;
                    break;
                }
                case X_SCALE: {
                    part.f_233553_ = value;
                    break;
                }
                case Y_SCALE: {
                    part.f_233554_ = value;
                    break;
                }
                case Z_SCALE: {
                    part.f_233555_ = value;
                }
            }
        }

        public void set(PoseStackResult result, float value) {
            switch (this) {
                case X_ROT: {
                    result.xRot = value;
                    break;
                }
                case Y_ROT: {
                    result.yRot = value;
                    break;
                }
                case Z_ROT: {
                    result.zRot = value;
                    break;
                }
                case X: {
                    result.x = value;
                    break;
                }
                case Y: {
                    result.y = value;
                    break;
                }
                case Z: {
                    result.z = value;
                    break;
                }
                case X2: {
                    result.x2 = value;
                    break;
                }
                case Y2: {
                    result.y2 = value;
                    break;
                }
                case Z2: {
                    result.z2 = value;
                    break;
                }
                case X_SCALE: {
                    result.xScale = value;
                    break;
                }
                case Y_SCALE: {
                    result.yScale = value;
                    break;
                }
                case Z_SCALE: {
                    result.zScale = value;
                }
            }
        }
    }

    public static class PartAnimationData {
        private final Map<PartOperationTarget, List<PartOperation>> operations = new LinkedHashMap<PartOperationTarget, List<PartOperation>>();
        private float multiplier = 1.0f;

        public PartAnimationData setXRot(float rot) {
            this.operations.computeIfAbsent(PartOperationTarget.X_ROT, t -> new LinkedList()).add(new PartOperation(PartOperationType.SET, rot));
            return this;
        }

        public PartAnimationData setXRotDegrees(float degrees) {
            return this.setXRot((float)Math.toRadians(degrees));
        }

        public PartAnimationData setYRot(float rot) {
            this.operations.computeIfAbsent(PartOperationTarget.Y_ROT, t -> new LinkedList()).add(new PartOperation(PartOperationType.SET, rot));
            return this;
        }

        public PartAnimationData setYRotDegrees(float degrees) {
            return this.setYRot((float)Math.toRadians(degrees));
        }

        public PartAnimationData setZRot(float rot) {
            this.operations.computeIfAbsent(PartOperationTarget.Z_ROT, t -> new LinkedList()).add(new PartOperation(PartOperationType.SET, rot));
            return this;
        }

        public PartAnimationData setZRotDegrees(float degrees) {
            return this.setZRot((float)Math.toRadians(degrees));
        }

        public PartAnimationData rotateX(float rot) {
            this.operations.computeIfAbsent(PartOperationTarget.X_ROT, t -> new LinkedList()).add(new PartOperation(PartOperationType.ADD, rot));
            return this;
        }

        public PartAnimationData rotateXDegrees(float degrees) {
            return this.rotateX((float)Math.toRadians(degrees));
        }

        public PartAnimationData rotateY(float rot) {
            this.operations.computeIfAbsent(PartOperationTarget.Y_ROT, t -> new LinkedList()).add(new PartOperation(PartOperationType.ADD, rot));
            return this;
        }

        public PartAnimationData rotateYDegrees(float degrees) {
            return this.rotateY((float)Math.toRadians(degrees));
        }

        public PartAnimationData rotateZ(float rot) {
            this.operations.computeIfAbsent(PartOperationTarget.Z_ROT, t -> new LinkedList()).add(new PartOperation(PartOperationType.ADD, rot));
            return this;
        }

        public PartAnimationData rotateZDegrees(float degrees) {
            return this.rotateZ((float)Math.toRadians(degrees));
        }

        public PartAnimationData resetXRot() {
            this.operations.computeIfAbsent(PartOperationTarget.X_ROT, t -> new LinkedList()).add(new PartOperation(PartOperationType.RESET, 0.0f));
            return this;
        }

        public PartAnimationData resetYRot() {
            this.operations.computeIfAbsent(PartOperationTarget.Y_ROT, t -> new LinkedList()).add(new PartOperation(PartOperationType.RESET, 0.0f));
            return this;
        }

        public PartAnimationData resetZRot() {
            this.operations.computeIfAbsent(PartOperationTarget.Z_ROT, t -> new LinkedList()).add(new PartOperation(PartOperationType.RESET, 0.0f));
            return this;
        }

        public PartAnimationData moveX(float amount) {
            this.operations.computeIfAbsent(PartOperationTarget.X, t -> new LinkedList()).add(new PartOperation(PartOperationType.ADD, amount));
            return this;
        }

        @Deprecated
        public PartAnimationData translateX(float amount) {
            return this.setX(amount);
        }

        public PartAnimationData setX(float amount) {
            this.operations.computeIfAbsent(PartOperationTarget.X, t -> new LinkedList()).add(new PartOperation(PartOperationType.SET, amount));
            return this;
        }

        public PartAnimationData resetX() {
            this.operations.computeIfAbsent(PartOperationTarget.X, t -> new LinkedList()).add(new PartOperation(PartOperationType.RESET, 0.0f));
            return this;
        }

        public PartAnimationData moveY(float amount) {
            this.operations.computeIfAbsent(PartOperationTarget.Y, t -> new LinkedList()).add(new PartOperation(PartOperationType.ADD, amount));
            return this;
        }

        @Deprecated
        public PartAnimationData translateY(float amount) {
            return this.setY(amount);
        }

        public PartAnimationData setY(float amount) {
            this.operations.computeIfAbsent(PartOperationTarget.Y, t -> new LinkedList()).add(new PartOperation(PartOperationType.SET, amount));
            return this;
        }

        public PartAnimationData setY2(float amount) {
            this.operations.computeIfAbsent(PartOperationTarget.Y2, t -> new LinkedList()).add(new PartOperation(PartOperationType.SET, amount));
            return this;
        }

        public PartAnimationData resetY() {
            this.operations.computeIfAbsent(PartOperationTarget.Y, t -> new LinkedList()).add(new PartOperation(PartOperationType.RESET, 0.0f));
            return this;
        }

        public PartAnimationData moveZ(float amount) {
            this.operations.computeIfAbsent(PartOperationTarget.Z, t -> new LinkedList()).add(new PartOperation(PartOperationType.ADD, amount));
            return this;
        }

        @Deprecated
        public PartAnimationData translateZ(float amount) {
            return this.setZ(amount);
        }

        public PartAnimationData setZ(float amount) {
            this.operations.computeIfAbsent(PartOperationTarget.Z, t -> new LinkedList()).add(new PartOperation(PartOperationType.SET, amount));
            return this;
        }

        public PartAnimationData resetZ() {
            this.operations.computeIfAbsent(PartOperationTarget.Z, t -> new LinkedList()).add(new PartOperation(PartOperationType.RESET, 0.0f));
            return this;
        }

        public PartAnimationData scaleX(float amount) {
            this.operations.computeIfAbsent(PartOperationTarget.X_SCALE, t -> new LinkedList()).add(new PartOperation(PartOperationType.ADD, amount));
            return this;
        }

        public PartAnimationData scaleY(float amount) {
            this.operations.computeIfAbsent(PartOperationTarget.Y_SCALE, t -> new LinkedList()).add(new PartOperation(PartOperationType.ADD, amount));
            return this;
        }

        public PartAnimationData scaleZ(float amount) {
            this.operations.computeIfAbsent(PartOperationTarget.Z_SCALE, t -> new LinkedList()).add(new PartOperation(PartOperationType.ADD, amount));
            return this;
        }

        public PartAnimationData multiplier(float multiplier) {
            this.multiplier = multiplier;
            return this;
        }

        public PartAnimationData animate(Easing ease, float animationProgress) {
            return this.multiplier(ease.apply(animationProgress));
        }

        public void apply(ModelPart modelPart) {
            for (Map.Entry<PartOperationTarget, List<PartOperation>> entry : this.operations.entrySet()) {
                for (PartOperation operation : entry.getValue()) {
                    operation.apply(modelPart, entry.getKey(), this.multiplier);
                }
            }
        }

        public void apply(PoseStackResult result) {
            for (Map.Entry<PartOperationTarget, List<PartOperation>> entry : this.operations.entrySet()) {
                for (PartOperation operation : entry.getValue()) {
                    operation.apply(result, entry.getKey(), this.multiplier);
                }
            }
        }
    }

    public static enum PlayerModelPart {
        HEAD("head"),
        CHEST("chest"),
        RIGHT_ARM("right_arm"),
        LEFT_ARM("left_arm"),
        RIGHT_LEG("right_leg"),
        LEFT_LEG("left_leg"),
        BODY("body");

        private final String name;

        private PlayerModelPart(String name) {
            this.name = name;
        }

        public void applyToModelPart(HumanoidModel<?> model, PartAnimationData data) {
            if (this == HEAD) {
                data.apply(model.f_102808_);
                model.f_102809_.m_104315_(model.f_102808_);
            } else if (this == CHEST) {
                data.apply(model.f_102810_);
            } else if (this == RIGHT_ARM) {
                data.apply(model.f_102811_);
            } else if (this == LEFT_ARM) {
                data.apply(model.f_102812_);
            } else if (this == RIGHT_LEG) {
                data.apply(model.f_102813_);
            } else if (this == LEFT_LEG) {
                data.apply(model.f_102814_);
            }
            if (model instanceof PlayerModel) {
                PlayerModel playerModel = (PlayerModel)model;
                playerModel.f_103378_.m_104315_(model.f_102810_);
                playerModel.f_103375_.m_104315_(model.f_102811_);
                playerModel.f_103374_.m_104315_(model.f_102812_);
                playerModel.f_103377_.m_104315_(model.f_102813_);
                playerModel.f_103376_.m_104315_(model.f_102814_);
            }
        }

        public static PlayerModelPart fromName(String name) {
            for (PlayerModelPart part : PlayerModelPart.values()) {
                if (!part.name.equalsIgnoreCase(name)) continue;
                return part;
            }
            return null;
        }
    }

    public static enum FirstPersonContext {
        NONE,
        RIGHT_ARM,
        LEFT_ARM;


        public boolean firstPerson() {
            return this != NONE;
        }

        public boolean rightArm() {
            return this == RIGHT_ARM;
        }

        public boolean leftArm() {
            return this == LEFT_ARM;
        }

        public boolean mainArm() {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            return player != null && player.m_5737_() == HumanoidArm.RIGHT && this == RIGHT_ARM;
        }

        public boolean offArm() {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            return player != null && player.m_5737_() == HumanoidArm.RIGHT && this == LEFT_ARM;
        }
    }

    public static class Builder {
        private final Map<PlayerModelPart, PartAnimationData> animationData = new HashMap<PlayerModelPart, PartAnimationData>();
        private float limbSwing;
        private float limbSwingAmount;
        private float ageInTicks;
        private float netHeadYaw;
        private float headPitch;

        public Builder() {
        }

        public Builder(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.limbSwing = limbSwing;
            this.limbSwingAmount = limbSwingAmount;
            this.ageInTicks = ageInTicks;
            this.netHeadYaw = netHeadYaw;
            this.headPitch = headPitch;
        }

        public PartAnimationData get(PlayerModelPart modelPart) {
            if (modelPart == null) {
                throw new RuntimeException("Player model part cant be null");
            }
            return this.animationData.computeIfAbsent(modelPart, bodyPart -> new PartAnimationData());
        }

        public Map<PlayerModelPart, PartAnimationData> getAnimationData() {
            return this.animationData;
        }

        public float getLimbSwing() {
            return this.limbSwing;
        }

        public float getLimbSwingAmount() {
            return this.limbSwingAmount;
        }

        public float getAgeInTicks() {
            return this.ageInTicks;
        }

        public float getNetHeadYaw() {
            return this.netHeadYaw;
        }

        public float getHeadPitch() {
            return this.headPitch;
        }
    }
}

