/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.renderer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.Color;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.threetag.palladium.client.renderer.DynamicColor;
import net.threetag.palladium.client.renderer.PalladiumRenderTypes;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.util.RenderUtil;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.json.GsonUtil;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public class LaserRenderer {
    private DynamicColor glowColor;
    private DynamicColor coreColor = DynamicColor.staticColor(Color.WHITE);
    private float rainbow = 0.0f;
    private float glowOpacity = 1.0f;
    private float coreOpacity = 1.0f;
    private int bloom = 3;
    private Vector2f size = new Vector2f(0.0625f, 0.0625f);
    private float length = 1.0f;
    private boolean normalTransparency = false;
    private float rotation = 0.0f;
    private float rotationSpeed = 0.0f;
    private float opacityAndSizeModifier = 1.0f;

    public LaserRenderer(DynamicColor color) {
        this.glowColor = color;
    }

    public LaserRenderer(DynamicColor glowColor, DynamicColor coreColor) {
        this.glowColor = glowColor;
        this.coreColor = coreColor;
    }

    public LaserRenderer color(DynamicColor color) {
        this.glowColor = color;
        return this;
    }

    public LaserRenderer color(DynamicColor glowColor, DynamicColor coreColor) {
        this.glowColor = glowColor;
        this.coreColor = coreColor;
        return this;
    }

    public DynamicColor getCoreColor() {
        return this.coreColor;
    }

    public DynamicColor getGlowColor() {
        return this.glowColor;
    }

    public LaserRenderer enableRainbow(float speed) {
        this.rainbow = speed;
        return this;
    }

    public float getRainbowSpeed() {
        return this.rainbow;
    }

    public LaserRenderer opacity(float opacity) {
        this.glowOpacity = this.coreOpacity = opacity;
        return this;
    }

    public LaserRenderer opacity(float glowOpacity, float coreOpacity) {
        this.glowOpacity = glowOpacity;
        this.coreOpacity = coreOpacity;
        return this;
    }

    public float getCoreOpacity() {
        return this.coreOpacity;
    }

    public float getGlowOpacity() {
        return this.glowOpacity;
    }

    public LaserRenderer bloom(int bloom) {
        this.bloom = Mth.m_14045_((int)bloom, (int)0, (int)10);
        return this;
    }

    public int getBloom() {
        return this.bloom;
    }

    public LaserRenderer size(float size) {
        return this.size(size, size);
    }

    public LaserRenderer size(float width, float height) {
        this.size = new Vector2f(width, height);
        return this;
    }

    public LaserRenderer size(Vector2f size) {
        this.size = size;
        return this;
    }

    public Vector2f getSize() {
        return this.size;
    }

    public LaserRenderer length(float length) {
        this.length = length;
        return this;
    }

    public float getLength() {
        return this.length;
    }

    public LaserRenderer normalTransparency() {
        this.normalTransparency = true;
        return this;
    }

    public LaserRenderer normalTransparency(boolean normalTransparency) {
        this.normalTransparency = normalTransparency;
        return this;
    }

    public boolean hasNormalTransparency() {
        return this.normalTransparency;
    }

    public LaserRenderer rotate(float rotation) {
        this.rotation = rotation;
        return this;
    }

    public float getRotation() {
        return this.rotation;
    }

    public LaserRenderer rotationSpeed(float rotationSpeed) {
        this.rotationSpeed = rotationSpeed;
        return this;
    }

    public float getRotationSpeed() {
        return this.rotationSpeed;
    }

    public LaserRenderer opacityAndSizeModifier(float modifier) {
        this.opacityAndSizeModifier = modifier;
        return this;
    }

    public void face(PoseStack poseStack, Vec3 origin, Vec3 target) {
        RenderUtil.faceVec(poseStack, origin, target);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
    }

    public void faceAndRender(DataContext context, PoseStack poseStack, MultiBufferSource bufferSource, Vec3 origin, Vec3 target, int ticks, float partialTick) {
        poseStack.m_85836_();
        this.face(poseStack, origin, target);
        this.render(context, poseStack, bufferSource, ticks, partialTick);
        poseStack.m_85849_();
    }

    public void render(DataContext context, PoseStack poseStack, MultiBufferSource bufferSource, int ticks, float partialTick) {
        float rot = this.rotation;
        if (this.rotationSpeed > 0.0f) {
            rot += ((float)ticks + partialTick) * this.rotationSpeed;
        }
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(rot % 360.0f));
        VertexConsumer consumer = bufferSource.m_6299_(this.normalTransparency ? PalladiumRenderTypes.LASER_NORMAL_TRANSPARENCY : PalladiumRenderTypes.LASER);
        Vector2f size = new Vector2f((Vector2fc)this.size).mul(this.opacityAndSizeModifier);
        AABB box = new AABB((double)(-size.x / 2.0f), 0.0, (double)(-size.y / 2.0f), (double)(size.x / 2.0f), (double)this.length, (double)(size.y / 2.0f));
        if (this.coreOpacity > 0.0f) {
            Color coreColor = this.coreColor.getColor(context);
            RenderUtil.renderFilledBox(poseStack, consumer, box, (float)coreColor.getRed() / 255.0f, (float)coreColor.getGreen() / 255.0f, (float)coreColor.getBlue() / 255.0f, this.coreOpacity * this.opacityAndSizeModifier, 0xF00000);
        }
        Color glowColor = this.getRenderedGlowColor(context, ticks, partialTick);
        float r = (float)glowColor.getRed() / 255.0f;
        float g = (float)glowColor.getGreen() / 255.0f;
        float b = (float)glowColor.getBlue() / 255.0f;
        if (this.glowOpacity > 0.0f) {
            for (int i = 0; i < this.bloom + 1; ++i) {
                RenderUtil.renderFilledBox(poseStack, consumer, box.m_82400_((double)((float)i * 0.5f * 0.0625f)), r, g, b, 1.0f / (float)i / 2.0f * this.glowOpacity * this.opacityAndSizeModifier, 0xF00000);
            }
        }
        poseStack.m_85849_();
    }

    private Color getRenderedGlowColor(DataContext context, int ticks, float partialTick) {
        if (this.rainbow > 0.0f) {
            int rate = Math.max((int)(25.0f * (1.0f - this.rainbow)), 1);
            int j = ticks / rate;
            int k = DyeColor.values().length;
            int l = j % k;
            int m = (j + 1) % k;
            float f = ((float)(ticks % rate) + partialTick) / (float)rate;
            float[] fs = Sheep.m_29829_((DyeColor)DyeColor.m_41053_((int)l));
            float[] gs = Sheep.m_29829_((DyeColor)DyeColor.m_41053_((int)m));
            return new Color(fs[0] * (1.0f - f) + gs[0] * f, fs[1] * (1.0f - f) + gs[1] * f, fs[2] * (1.0f - f) + gs[2] * f);
        }
        return this.glowColor.getColor(context);
    }

    public static LaserRenderer fromJson(JsonObject json) {
        return LaserRenderer.fromJson(json, 2);
    }

    public static LaserRenderer fromJson(JsonObject json, int defaultBloom) {
        LaserRenderer laser = new LaserRenderer(DynamicColor.getFromJson(json, "glow_color", DynamicColor.WHITE), DynamicColor.getFromJson(json, "core_color", DynamicColor.WHITE)).enableRainbow(GsonUtil.getAsBooleanFloat(json, "rainbow", 0.0f)).opacity(GsonUtil.getAsFloatRanged(json, "glow_opacity", 0.0f, 1.0f, 1.0f), GsonUtil.getAsFloatRanged(json, "core_opacity", 0.0f, 1.0f, 1.0f)).bloom(GsonUtil.getAsIntRanged(json, "bloom", 0, 10, defaultBloom)).size(LaserRenderer.parseSize(json, "size", new Vector2f(1.0f, 1.0f)).mul(0.0625f)).length(GsonUtil.getAsFloatMin(json, "length", 0.0f, 1.0f) / 16.0f).normalTransparency(GsonHelper.m_13855_((JsonObject)json, (String)"normal_transparency", (boolean)false)).rotate(GsonUtil.getAsFloatMin(json, "rotation", 0.0f, 0.0f)).rotationSpeed(GsonUtil.getAsFloatMin(json, "rotation_speed", 0.0f, 0.0f));
        if (json.has("thickness")) {
            laser.size(GsonUtil.getAsFloatMin(json, "thickness", 0.0f, 0.05f) * 20.0f / 16.0f);
        }
        return laser;
    }

    private static Vector2f parseSize(JsonObject json, String memberName, Vector2f fallback) {
        if (json.has(memberName)) {
            JsonElement el = json.get(memberName);
            if (el.isJsonPrimitive()) {
                float val = GsonHelper.m_13888_((JsonElement)el, (String)memberName);
                return new Vector2f(val, val);
            }
            if (el.isJsonArray()) {
                JsonArray array = el.getAsJsonArray();
                if (array.size() != 2) {
                    throw new JsonSyntaxException("Size must be an array of 2 numbers");
                }
                return new Vector2f(array.get(0).getAsFloat(), array.get(1).getAsFloat());
            }
            throw new JsonSyntaxException(memberName + " must be a simple number or an array of 2");
        }
        return fallback;
    }

    public static void generateDocumentation(JsonDocumentationBuilder builder, int defaultBloom, boolean withLength) {
        builder.addProperty("glow_color", Color.class).description("Color of the laser glow").fallback(Color.WHITE).exampleJson((JsonElement)new JsonPrimitive("#ffffff"));
        builder.addProperty("core_color", Color.class).description("Color of the inner core").fallback(Color.WHITE).exampleJson((JsonElement)new JsonPrimitive("#ffffff"));
        builder.addProperty("rainbow", Boolean.class).description("If enabled, the glow will have a rainbow effect. Can also be defined as a float to determine the speed").fallback(false).exampleJson((JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
        builder.addProperty("glow_opacity", Float.class).description("Opacity for the laser glow").fallback(Float.valueOf(1.0f)).exampleJson((JsonElement)new JsonPrimitive((Number)Float.valueOf(1.0f)));
        builder.addProperty("core_opacity", Float.class).description("Opacity for the inner core").fallback(Float.valueOf(1.0f)).exampleJson((JsonElement)new JsonPrimitive((Number)Float.valueOf(1.0f)));
        builder.addProperty("bloom", Integer.class).description("Describes how many stages of \"bloom\" is visible as the glow").fallback(defaultBloom).exampleJson((JsonElement)new JsonPrimitive((Number)defaultBloom));
        builder.addProperty("size", Vector2f.class).description("Size of the laser. Can either be defined as a simple float (e.g. 1.0), or 2-dimensional using an array (e.g. [1.0, 2.0])").fallback(new Vector2f(1.0f, 1.0f), "[1.0, 1.0]").exampleJson((JsonElement)new JsonPrimitive((Number)1));
        if (withLength) {
            builder.addProperty("length", Float.class).description("Length of the laser").fallback(Float.valueOf(1.0f)).exampleJson((JsonElement)new JsonPrimitive((Number)1));
        }
        builder.addProperty("normal_transparency", Boolean.class).description("You only ever really need to set it to true if you intend to make the core or glow black").fallback(false).exampleJson((JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
        builder.addProperty("rotation", Float.class).description("Rotation of the laser").fallback(Float.valueOf(0.0f)).exampleJson((JsonElement)new JsonPrimitive((Number)Float.valueOf(0.0f)));
        builder.addProperty("rotation_speed", Float.class).description("Speed at which the laser rotates").fallback(Float.valueOf(0.0f)).exampleJson((JsonElement)new JsonPrimitive((Number)Float.valueOf(0.0f)));
    }
}

