/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.util.Easing;
import net.threetag.palladiumcore.event.ClientTickEvents;
import org.joml.Matrix4f;

public class WatcherRenderer
implements ClientTickEvents.ClientLevelTick {
    public static final WatcherRenderer INSTANCE = new WatcherRenderer();
    private static final ResourceLocation TEXTURE = Palladium.id("textures/environment/watcher.png");
    private static final int OCCURRENCE_INTERVAL = 24000;
    private static final float OCCURRENCE_CHANCE = 0.01f;
    private static final int OCCURRENCE_DURATION = 1200;
    private static final int OCCURRENCE_FADE = 40;
    private int ticksTilOccurrence = 24000;
    private int visibleTicks = 0;
    private int visibility = 0;
    private int prevVisibility = 0;

    public static void init() {
        ClientTickEvents.CLIENT_LEVEL_POST.register((Object)INSTANCE);
    }

    public void render(PoseStack poseStack, float visibility) {
        if (visibility > 0.0f) {
            Easing easing = this.visibleTicks > 0 ? Easing.INSINE : Easing.OUTSINE;
            visibility = easing.apply(visibility);
            poseStack.m_85836_();
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-135.0f));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(60.0f));
            Matrix4f matrix4f2 = poseStack.m_85850_().m_252922_();
            float f = 40.0f;
            float g = 100.0f;
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)visibility);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferBuilder.m_252986_(matrix4f2, -f, g, -f).m_7421_(1.0f, 0.0f).m_5752_();
            bufferBuilder.m_252986_(matrix4f2, f, g, -f).m_7421_(0.0f, 0.0f).m_5752_();
            bufferBuilder.m_252986_(matrix4f2, f, g, f).m_7421_(0.0f, 1.0f).m_5752_();
            bufferBuilder.m_252986_(matrix4f2, -f, g, f).m_7421_(1.0f, 1.0f).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
            poseStack.m_85849_();
        }
    }

    public void clientLevelTick(Minecraft minecraft, ClientLevel clientLevel) {
        this.prevVisibility = this.visibility;
        if (this.ticksTilOccurrence > 0) {
            --this.ticksTilOccurrence;
            if (this.ticksTilOccurrence <= 0) {
                if (Math.random() < (double)0.01f) {
                    this.visibleTicks = 1200;
                }
                this.ticksTilOccurrence = (int)(24000.0 * (1.0 + Math.random()));
            }
        }
        if (this.visibleTicks > 0) {
            --this.visibleTicks;
            if (this.visibility < 40) {
                ++this.visibility;
            }
        } else if (this.visibility > 0) {
            --this.visibility;
        }
    }

    public float getVisibility(float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)this.prevVisibility, (float)this.visibility) / 40.0f;
    }
}

