/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.renderer.entity;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.threetag.palladium.power.ability.SkinChangeAbility;
import net.threetag.palladium.util.property.ChangedPlayerModelTypeProperty;

public class PlayerSkinHandler {
    private static final List<Pair<Integer, ISkinProvider>> PROVIDER = new ArrayList<Pair<Integer, ISkinProvider>>();

    public static ResourceLocation getCurrentSkin(GameProfile gameProfile, ResourceLocation defaultSkin) {
        AbstractClientPlayer player = (AbstractClientPlayer)Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_46003_(gameProfile.getId());
        if (player != null) {
            ResourceLocation start = defaultSkin;
            for (Pair<Integer, ISkinProvider> pair : PROVIDER) {
                start = ((ISkinProvider)pair.getSecond()).getSkin(player, start, defaultSkin);
            }
            return start;
        }
        return defaultSkin;
    }

    public static String getCurrentModelType(GameProfile gameProfile, String modelType) {
        AbstractClientPlayer player = (AbstractClientPlayer)Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_46003_(gameProfile.getId());
        if (player != null && !PROVIDER.isEmpty()) {
            ChangedPlayerModelTypeProperty.ChangedModelType overriddenType = ((ISkinProvider)PROVIDER.get(PROVIDER.size() - 1).getSecond()).getModelType(player);
            if (overriddenType == ChangedPlayerModelTypeProperty.ChangedModelType.KEEP) {
                return modelType;
            }
            if (overriddenType == ChangedPlayerModelTypeProperty.ChangedModelType.NORMAL) {
                return "default";
            }
            return "slim";
        }
        return modelType;
    }

    public static void registerSkinProvider(int priority, ISkinProvider provider) {
        PROVIDER.add((Pair<Integer, ISkinProvider>)Pair.of((Object)priority, (Object)provider));
        PROVIDER.sort((p1, p2) -> (Integer)p2.getFirst() - (Integer)p1.getFirst());
    }

    static {
        PlayerSkinHandler.registerSkinProvider(30, new SkinChangeAbility.SkinProvider());
    }

    public static interface ISkinProvider {
        public ResourceLocation getSkin(AbstractClientPlayer var1, ResourceLocation var2, ResourceLocation var3);

        default public ChangedPlayerModelTypeProperty.ChangedModelType getModelType(AbstractClientPlayer player) {
            return ChangedPlayerModelTypeProperty.ChangedModelType.KEEP;
        }
    }
}

