/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.renderer.renderlayer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.threetag.palladium.client.renderer.entity.HumanoidRendererModifications;
import net.threetag.palladium.client.renderer.renderlayer.RenderLayerStates;
import net.threetag.palladium.condition.Condition;
import net.threetag.palladium.condition.ConditionEnvironment;
import net.threetag.palladium.condition.ConditionSerializer;
import net.threetag.palladium.condition.FalseCondition;
import net.threetag.palladium.condition.TrueCondition;
import net.threetag.palladium.entity.BodyPart;
import net.threetag.palladium.mixin.client.AgeableListModelInvoker;
import net.threetag.palladium.util.context.DataContext;

public interface IPackRenderLayer {
    public void render(DataContext var1, PoseStack var2, MultiBufferSource var3, EntityModel<Entity> var4, int var5, float var6, float var7, float var8, float var9, float var10, float var11);

    default public void renderArm(DataContext context, HumanoidArm arm, PlayerRenderer playerRenderer, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
    }

    public IPackRenderLayer addCondition(Condition var1, PerspectiveConditionContext var2);

    public List<BodyPart> getHiddenBodyParts(LivingEntity var1);

    default public void onLoad() {
    }

    default public void onUnload() {
    }

    default public boolean isOrContains(IPackRenderLayer layer) {
        return this == layer;
    }

    default public RenderLayerStates.State createState() {
        return null;
    }

    default public void createSnapshot(DataContext context, EntityModel<Entity> parentModel, Consumer<Snapshot> consumer) {
    }

    public static <T extends IPackRenderLayer> T parseConditions(T layer, JsonObject json) {
        for (PerspectiveConditionContext context : PerspectiveConditionContext.values()) {
            if (!GsonHelper.m_13900_((JsonObject)json, (String)context.key)) continue;
            JsonElement el = json.get(context.key);
            if (el.isJsonPrimitive()) {
                boolean result = el.getAsBoolean();
                layer.addCondition(result ? new TrueCondition() : new FalseCondition(), context);
                continue;
            }
            ConditionSerializer.listFromJSON(el, ConditionEnvironment.ASSETS).forEach(cond -> layer.addCondition((Condition)cond, context));
        }
        return layer;
    }

    public static boolean conditionsFulfilled(Entity entity, List<Condition> conditions) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            for (Condition condition : conditions) {
                if (condition.active(DataContext.forEntity((Entity)livingEntity))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean conditionsFulfilled(Entity entity, List<Condition> bothConditions, List<Condition> specificConditions) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            for (Condition condition : bothConditions) {
                if (condition.active(DataContext.forEntity((Entity)livingEntity))) continue;
                return false;
            }
            for (Condition condition : specificConditions) {
                if (condition.active(DataContext.forEntity((Entity)livingEntity))) continue;
                return false;
            }
        }
        return true;
    }

    public static void copyModelProperties(Entity entity, HumanoidModel parent, HumanoidModel child) {
        parent.m_102872_(child);
        if (entity instanceof ArmorStand) {
            ArmorStand armorStand = (ArmorStand)entity;
            child.f_102808_.f_104203_ = (float)Math.PI / 180 * armorStand.m_31680_().m_123156_();
            child.f_102808_.f_104204_ = (float)Math.PI / 180 * armorStand.m_31680_().m_123157_();
            child.f_102808_.f_104205_ = (float)Math.PI / 180 * armorStand.m_31680_().m_123158_();
            child.f_102810_.f_104203_ = (float)Math.PI / 180 * armorStand.m_31685_().m_123156_();
            child.f_102810_.f_104204_ = (float)Math.PI / 180 * armorStand.m_31685_().m_123157_();
            child.f_102810_.f_104205_ = (float)Math.PI / 180 * armorStand.m_31685_().m_123158_();
            child.f_102812_.f_104203_ = (float)Math.PI / 180 * armorStand.m_31688_().m_123156_();
            child.f_102812_.f_104204_ = (float)Math.PI / 180 * armorStand.m_31688_().m_123157_();
            child.f_102812_.f_104205_ = (float)Math.PI / 180 * armorStand.m_31688_().m_123158_();
            child.f_102811_.f_104203_ = (float)Math.PI / 180 * armorStand.m_31689_().m_123156_();
            child.f_102811_.f_104204_ = (float)Math.PI / 180 * armorStand.m_31689_().m_123157_();
            child.f_102811_.f_104205_ = (float)Math.PI / 180 * armorStand.m_31689_().m_123158_();
            child.f_102814_.f_104203_ = (float)Math.PI / 180 * armorStand.m_31691_().m_123156_();
            child.f_102814_.f_104204_ = (float)Math.PI / 180 * armorStand.m_31691_().m_123157_();
            child.f_102814_.f_104205_ = (float)Math.PI / 180 * armorStand.m_31691_().m_123158_();
            child.f_102813_.f_104203_ = (float)Math.PI / 180 * armorStand.m_31694_().m_123156_();
            child.f_102813_.f_104204_ = (float)Math.PI / 180 * armorStand.m_31694_().m_123157_();
            child.f_102813_.f_104205_ = (float)Math.PI / 180 * armorStand.m_31694_().m_123158_();
            child.f_102809_.m_104315_(child.f_102808_);
        }
        child.m_8009_(true);
        HumanoidRendererModifications.applyRemovedBodyParts(child);
    }

    public static enum PerspectiveConditionContext {
        BOTH("conditions"),
        FIRST_PERSON("first_person_conditions"),
        THIRD_PERSON("third_person_conditions");

        public final String key;

        private PerspectiveConditionContext(String key) {
            this.key = key;
        }
    }

    public static class Snapshot {
        private final EntityModel<?> model;
        private final ResourceLocation texture;
        private final Map<ModelPart, PartPose> poseMap;

        public Snapshot(EntityModel<?> model, ResourceLocation texture) {
            block4: {
                block3: {
                    this.poseMap = new HashMap<ModelPart, PartPose>();
                    this.model = model;
                    this.texture = texture;
                    if (!(model instanceof AgeableListModelInvoker)) break block3;
                    AgeableListModelInvoker ageable = (AgeableListModelInvoker)model;
                    for (ModelPart part : ageable.invokeHeadParts()) {
                        this.storePose(part);
                    }
                    for (ModelPart part : ageable.invokeBodyParts()) {
                        this.storePose(part);
                    }
                    break block4;
                }
                if (!(model instanceof HierarchicalModel)) break block4;
                HierarchicalModel hierarchical = (HierarchicalModel)model;
                for (ModelPart part : hierarchical.m_142109_().f_104213_.values()) {
                    this.storePose(part);
                }
            }
        }

        private void storePose(ModelPart part) {
            this.poseMap.put(part, part.m_171308_());
            for (ModelPart child : part.f_104213_.values()) {
                this.storePose(child);
            }
        }

        public void applyPoses() {
            for (Map.Entry<ModelPart, PartPose> e : this.poseMap.entrySet()) {
                e.getKey().m_171322_(e.getValue());
            }
        }

        public EntityModel<?> getModel() {
            return this.model;
        }

        public ResourceLocation getTexture() {
            return this.texture;
        }
    }
}

