/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.renderer.renderlayer;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import net.threetag.palladium.client.dynamictexture.DynamicModelLayerLocation;
import net.threetag.palladium.client.dynamictexture.DynamicTexture;
import net.threetag.palladium.client.dynamictexture.DynamicTextureManager;
import net.threetag.palladium.client.model.ExtraAnimatedModel;
import net.threetag.palladium.client.renderer.DynamicColor;
import net.threetag.palladium.client.renderer.renderlayer.AbstractPackRenderLayer;
import net.threetag.palladium.client.renderer.renderlayer.IPackRenderLayer;
import net.threetag.palladium.client.renderer.renderlayer.ModelTypes;
import net.threetag.palladium.client.renderer.renderlayer.PackRenderLayerManager;
import net.threetag.palladium.client.renderer.renderlayer.RenderTypeFunction;
import net.threetag.palladium.condition.Condition;
import net.threetag.palladium.condition.ConditionEnvironment;
import net.threetag.palladium.condition.ConditionSerializer;
import net.threetag.palladium.condition.FalseCondition;
import net.threetag.palladium.util.SkinTypedValue;
import net.threetag.palladium.util.context.DataContext;

public class PackRenderLayer
extends AbstractPackRenderLayer {
    private final SkinTypedValue<ModelTypes.Model> modelLookup;
    private final SkinTypedValue<ModelCache> model;
    private final SkinTypedValue<DynamicTexture> texture;
    private final RenderTypeFunction renderType;
    private final DynamicColor tint;
    private final List<Condition> enchantmentGlint;

    public PackRenderLayer(SkinTypedValue<ModelTypes.Model> model, SkinTypedValue<DynamicModelLayerLocation> modelLayerLocation, SkinTypedValue<DynamicTexture> texture, RenderTypeFunction renderType, DynamicColor tint, List<Condition> enchantmentGlint) {
        this.modelLookup = model;
        this.model = new SkinTypedValue<ModelCache>(new ModelCache(modelLayerLocation.getNormal()), new ModelCache(modelLayerLocation.getSlim()));
        this.texture = texture;
        this.renderType = renderType;
        this.tint = tint;
        this.enchantmentGlint = enchantmentGlint;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void render(DataContext context, PoseStack poseStack, MultiBufferSource bufferSource, EntityModel<Entity> parentModel, int packedLight, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        block4: {
            entity = context.getEntity();
            if (!IPackRenderLayer.conditionsFulfilled(entity, this.conditions, this.thirdPersonConditions) || !this.modelLookup.get(entity).fitsEntity(entity, parentModel)) break block4;
            entityModel = this.model.get(entity).getModel(context, this.modelLookup.get(entity));
            if (!(entityModel instanceof HumanoidModel)) ** GOTO lbl-1000
            entityHumanoidModel = (HumanoidModel)entityModel;
            if (parentModel instanceof HumanoidModel) {
                parentHumanoid = (HumanoidModel)parentModel;
                IPackRenderLayer.copyModelProperties(entity, parentHumanoid, entityHumanoidModel);
            } else lbl-1000:
            // 2 sources

            {
                entityModel.m_6839_(entity, limbSwing, limbSwingAmount, partialTicks);
                entityModel.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            }
            if (entityModel instanceof ExtraAnimatedModel) {
                extra = (ExtraAnimatedModel)entityModel;
                extra.extraAnimations(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, partialTicks);
            }
            vertexConsumer = this.renderType.createVertexConsumer(bufferSource, this.texture.get(entity).getTexture(context), context.getItem().m_41790_() != false || IPackRenderLayer.conditionsFulfilled(entity, this.enchantmentGlint) != false);
            tint = Color.WHITE;
            if (this.tint != null) {
                tint = this.tint.getColor(context);
            }
            entityModel.m_7695_(poseStack, vertexConsumer, this.renderType.getPackedLight(packedLight), OverlayTexture.f_118083_, (float)tint.getRed() / 255.0f, (float)tint.getGreen() / 255.0f, (float)tint.getBlue() / 255.0f, (float)tint.getAlpha() / 255.0f);
        }
    }

    @Override
    public void renderArm(DataContext context, HumanoidArm arm, PlayerRenderer playerRenderer, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        EntityModel<?> entityModel;
        Entity player = context.getEntity();
        if (IPackRenderLayer.conditionsFulfilled(player, this.conditions, this.firstPersonConditions) && this.modelLookup.get(player).fitsEntity(player, playerRenderer.m_7200_()) && (entityModel = this.model.get(player).getModel(context, this.modelLookup.get(player))) instanceof HumanoidModel) {
            HumanoidModel humanoidModel = (HumanoidModel)entityModel;
            ((PlayerModel)playerRenderer.m_7200_()).m_102872_(humanoidModel);
            VertexConsumer vertexConsumer = this.renderType.createVertexConsumer(bufferSource, this.texture.get(player).getTexture(context), context.getItem().m_41790_() || IPackRenderLayer.conditionsFulfilled(player, this.enchantmentGlint));
            humanoidModel.f_102608_ = 0.0f;
            humanoidModel.f_102817_ = false;
            humanoidModel.f_102818_ = 0.0f;
            Color tint = Color.WHITE;
            if (this.tint != null) {
                tint = this.tint.getColor(context);
            }
            if (arm == HumanoidArm.RIGHT) {
                humanoidModel.f_102811_.f_104203_ = 0.0f;
                humanoidModel.f_102811_.m_104306_(poseStack, vertexConsumer, this.renderType.getPackedLight(packedLight), OverlayTexture.f_118083_, (float)tint.getRed() / 255.0f, (float)tint.getGreen() / 255.0f, (float)tint.getBlue() / 255.0f, (float)tint.getAlpha() / 255.0f);
            } else {
                humanoidModel.f_102812_.f_104203_ = 0.0f;
                humanoidModel.f_102812_.m_104306_(poseStack, vertexConsumer, this.renderType.getPackedLight(packedLight), OverlayTexture.f_118083_, (float)tint.getRed() / 255.0f, (float)tint.getGreen() / 255.0f, (float)tint.getBlue() / 255.0f, (float)tint.getAlpha() / 255.0f);
            }
        }
    }

    @Override
    public void createSnapshot(DataContext context, EntityModel<Entity> parentModel, Consumer<IPackRenderLayer.Snapshot> consumer) {
        Entity entity = context.getEntity();
        if (IPackRenderLayer.conditionsFulfilled(entity, this.conditions, this.firstPersonConditions) && this.modelLookup.get(entity).fitsEntity(entity, parentModel)) {
            EntityModel<?> entityModel = this.model.get(entity).getModel(context, this.modelLookup.get(entity));
            ResourceLocation texture = this.texture.get(entity).getTexture(context);
            consumer.accept(new IPackRenderLayer.Snapshot(entityModel, texture));
        }
    }

    public static PackRenderLayer parse(JsonObject json) {
        RenderTypeFunction renderType = PackRenderLayerManager.getRenderType(new ResourceLocation(GsonHelper.m_13851_((JsonObject)json, (String)"render_type", (String)"solid")));
        String modelTypeKey = "model_type";
        if (!json.has(modelTypeKey) && json.has("model")) {
            AddonPackLog.warning("Deprecated use of 'model' in render layer. Please switch to 'model_type'!", new Object[0]);
            modelTypeKey = "model";
        }
        SkinTypedValue<ModelTypes.Model> model = GsonHelper.m_13900_((JsonObject)json, (String)modelTypeKey) ? SkinTypedValue.fromJSON(json.get(modelTypeKey), jsonElement -> {
            ResourceLocation modelId = new ResourceLocation(jsonElement.getAsString());
            ModelTypes.Model m = ModelTypes.get(modelId);
            if (m == null) {
                throw new JsonParseException("Unknown model type '" + String.valueOf(modelId) + "'");
            }
            return m;
        }) : new SkinTypedValue<ModelTypes.Model>(ModelTypes.HUMANOID);
        if (renderType == null) {
            throw new JsonParseException("Unknown render type '" + String.valueOf(new ResourceLocation(GsonHelper.m_13851_((JsonObject)json, (String)"render_type", (String)"solid"))) + "'");
        }
        List<Condition> enchantmentGlint = json.has("enchantment_glint") ? ConditionSerializer.listFromJSON(json.get("enchantment_glint"), ConditionEnvironment.ASSETS) : Collections.singletonList(new FalseCondition());
        return new PackRenderLayer(model, SkinTypedValue.fromJSON(json.get("model_layer"), DynamicModelLayerLocation::fromJson), SkinTypedValue.fromJSON(json.get("texture"), DynamicTextureManager::fromJson), renderType, DynamicColor.getFromJson(json, "tint", null), enchantmentGlint);
    }

    public static class ModelCache {
        private final DynamicModelLayerLocation modelLayerLocation;
        private final Map<ModelLayerLocation, EntityModel<?>> models = new HashMap();

        public ModelCache(DynamicModelLayerLocation modelLayerLocation) {
            this.modelLayerLocation = modelLayerLocation;
        }

        public EntityModel<?> getModel(DataContext context, ModelTypes.Model modelType) {
            ModelLayerLocation modelLayer = this.modelLayerLocation.getModelLayer(context);
            if (this.models.containsKey(modelLayer)) {
                return this.models.get(modelLayer);
            }
            EntityModel<?> model = modelType.getModel(Minecraft.m_91087_().m_167973_().m_171103_(modelLayer));
            this.models.put(modelLayer, model);
            return model;
        }
    }
}

