/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.renderer.renderlayer;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import net.threetag.palladium.addonpack.parser.AddonParser;
import net.threetag.palladium.client.renderer.PalladiumRenderTypes;
import net.threetag.palladium.client.renderer.item.armor.ArmorRendererData;
import net.threetag.palladium.client.renderer.renderlayer.AbstractPackRenderLayer;
import net.threetag.palladium.client.renderer.renderlayer.CompoundPackRenderLayer;
import net.threetag.palladium.client.renderer.renderlayer.IPackRenderLayer;
import net.threetag.palladium.client.renderer.renderlayer.LightningSparksRenderLayer;
import net.threetag.palladium.client.renderer.renderlayer.PackRenderLayer;
import net.threetag.palladium.client.renderer.renderlayer.RenderTypeFunction;
import net.threetag.palladium.client.renderer.renderlayer.SkinOverlayPackRenderLayer;
import net.threetag.palladium.client.renderer.renderlayer.ThrusterPackRenderLayer;
import net.threetag.palladium.entity.BodyPart;
import net.threetag.palladium.item.ArmorWithRenderer;
import net.threetag.palladium.item.IAddonItem;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AbilityUtil;
import net.threetag.palladium.power.ability.RenderLayerProviderAbility;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.json.GsonUtil;

public class PackRenderLayerManager
extends SimpleJsonResourceReloadListener {
    private static PackRenderLayerManager INSTANCE;
    private static final List<Provider> RENDER_LAYERS_PROVIDERS;
    private static final Map<ResourceLocation, Function<JsonObject, IPackRenderLayer>> RENDER_LAYERS_PARSERS;
    private static final Map<ResourceLocation, RenderTypeFunction> RENDER_TYPES;
    private Map<ResourceLocation, IPackRenderLayer> renderLayers = new HashMap<ResourceLocation, IPackRenderLayer>();

    public PackRenderLayerManager() {
        super(AddonParser.GSON, "palladium/render_layers");
        INSTANCE = this;
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler) {
        this.renderLayers.values().forEach(IPackRenderLayer::onUnload);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        object.forEach((resourceLocation, jsonElement) -> {
            try {
                IPackRenderLayer layer = PackRenderLayerManager.parseLayer(GsonHelper.m_13918_((JsonElement)jsonElement, (String)"$"));
                builder.put(resourceLocation, (Object)layer);
            }
            catch (Exception e) {
                AddonPackLog.error("Parsing error loading render layer {}", resourceLocation, e);
            }
        });
        this.renderLayers = builder.build();
        this.renderLayers.values().forEach(IPackRenderLayer::onLoad);
    }

    public IPackRenderLayer getLayer(ResourceLocation id) {
        return this.renderLayers.get(id);
    }

    public static IPackRenderLayer parseLayer(JsonObject json) {
        ResourceLocation parserId = GsonUtil.getAsResourceLocation(json, "type", new ResourceLocation("palladium", "default"));
        if (!RENDER_LAYERS_PARSERS.containsKey(parserId)) {
            throw new JsonParseException("Unknown render layer type '" + String.valueOf(parserId) + "'");
        }
        IPackRenderLayer layer = IPackRenderLayer.parseConditions(RENDER_LAYERS_PARSERS.get(parserId).apply(json), json);
        if (layer instanceof AbstractPackRenderLayer) {
            AbstractPackRenderLayer abstractPackRenderLayer = (AbstractPackRenderLayer)layer;
            GsonUtil.ifHasKey(json, "hidden_body_parts", el -> {
                if (el.isJsonPrimitive()) {
                    String string = el.getAsString();
                    if (string.equalsIgnoreCase("all")) {
                        for (BodyPart bodyPart : BodyPart.values()) {
                            abstractPackRenderLayer.addHiddenBodyPart(bodyPart);
                        }
                    } else {
                        abstractPackRenderLayer.addHiddenBodyPart(BodyPart.fromJson(string));
                    }
                } else if (el.isJsonArray()) {
                    JsonArray jsonArray = el.getAsJsonArray();
                    for (JsonElement jsonElement : jsonArray) {
                        abstractPackRenderLayer.addHiddenBodyPart(BodyPart.fromJson(jsonElement.getAsString()));
                    }
                } else {
                    throw new JsonParseException("hidden_body_parts setting must either be a string or an array");
                }
            });
        }
        return layer;
    }

    public static PackRenderLayerManager getInstance() {
        return INSTANCE;
    }

    public static void registerProvider(Provider provider) {
        RENDER_LAYERS_PROVIDERS.add(provider);
    }

    public static void registerParser(ResourceLocation id, Function<JsonObject, IPackRenderLayer> function) {
        RENDER_LAYERS_PARSERS.put(id, function);
    }

    public static void registerRenderType(ResourceLocation id, RenderTypeFunction function) {
        RENDER_TYPES.put(id, function);
    }

    public static RenderTypeFunction getRenderType(ResourceLocation id) {
        return RENDER_TYPES.get(id);
    }

    public static void forEachLayer(Entity entity, BiConsumer<DataContext, IPackRenderLayer> consumer) {
        for (Provider provider : RENDER_LAYERS_PROVIDERS) {
            provider.addRenderLayers(entity, consumer);
        }
    }

    static {
        RENDER_LAYERS_PROVIDERS = new ArrayList<Provider>();
        RENDER_LAYERS_PARSERS = new HashMap<ResourceLocation, Function<JsonObject, IPackRenderLayer>>();
        RENDER_TYPES = new HashMap<ResourceLocation, RenderTypeFunction>();
        PackRenderLayerManager.registerProvider((entity, layers) -> {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                PackRenderLayerManager manager = PackRenderLayerManager.getInstance();
                for (AbilityInstance entry : AbilityUtil.getEnabledRenderLayerInstances(livingEntity)) {
                    IPackRenderLayer layer = ((RenderLayerProviderAbility)((Object)entry.getConfiguration().getAbility())).getRenderLayer(entry, livingEntity, manager);
                    if (layer == null) continue;
                    layers.accept(DataContext.forAbility(livingEntity, entry), layer);
                }
            }
        });
        PackRenderLayerManager.registerProvider((entity, layers) -> {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    ArmorWithRenderer armorWithRenderer;
                    Object patt4176$temp;
                    Item patt4083$temp;
                    IAddonItem addonItem;
                    ItemStack stack = livingEntity.m_6844_(slot);
                    if (stack.m_41619_()) continue;
                    DataContext context = DataContext.forArmorInSlot(livingEntity, slot);
                    Item patt3449$temp = stack.m_41720_();
                    if (patt3449$temp instanceof IAddonItem && (addonItem = (IAddonItem)patt3449$temp).getRenderLayerContainer() != null) {
                        IAddonItem.RenderLayerContainer container = addonItem.getRenderLayerContainer();
                        for (ResourceLocation id : container.get(slot.m_20751_())) {
                            IPackRenderLayer layer = PackRenderLayerManager.getInstance().getLayer(id);
                            if (layer == null) continue;
                            layers.accept(context, layer);
                        }
                    }
                    if (!slot.m_254934_() || !((patt4083$temp = stack.m_41720_()) instanceof ArmorWithRenderer) || !((patt4176$temp = (armorWithRenderer = (ArmorWithRenderer)patt4083$temp).getCachedArmorRenderer()) instanceof ArmorRendererData)) continue;
                    ArmorRendererData renderer = (ArmorRendererData)patt4176$temp;
                    for (IPackRenderLayer layer : renderer.getRenderLayers()) {
                        layers.accept(context, layer);
                    }
                }
            }
        });
        PackRenderLayerManager.registerParser(new ResourceLocation("palladium", "default"), PackRenderLayer::parse);
        PackRenderLayerManager.registerParser(new ResourceLocation("palladium", "compound"), CompoundPackRenderLayer::parse);
        PackRenderLayerManager.registerParser(new ResourceLocation("palladium", "skin_overlay"), SkinOverlayPackRenderLayer::parse);
        PackRenderLayerManager.registerParser(new ResourceLocation("palladium", "lightning_sparks"), LightningSparksRenderLayer::parse);
        PackRenderLayerManager.registerParser(new ResourceLocation("palladium", "thrusters"), ThrusterPackRenderLayer::parse);
        PackRenderLayerManager.registerRenderType(new ResourceLocation("minecraft", "solid"), (source, texture, glint) -> ItemRenderer.m_115184_((MultiBufferSource)source, (RenderType)RenderType.m_110473_((ResourceLocation)texture), (boolean)false, (boolean)glint));
        PackRenderLayerManager.registerRenderType(new ResourceLocation("minecraft", "cutout"), (source, texture, glint) -> ItemRenderer.m_115184_((MultiBufferSource)source, (RenderType)RenderType.m_110452_((ResourceLocation)texture), (boolean)false, (boolean)glint));
        PackRenderLayerManager.registerRenderType(new ResourceLocation("minecraft", "glow"), new RenderTypeFunction(){

            @Override
            public VertexConsumer createVertexConsumer(MultiBufferSource buffer, ResourceLocation texture, boolean withGlint) {
                return ItemRenderer.m_115184_((MultiBufferSource)buffer, (RenderType)PalladiumRenderTypes.getGlowing(texture), (boolean)false, (boolean)withGlint);
            }

            @Override
            public int getPackedLight(int packedLight) {
                return 0xF00000;
            }
        });
    }

    public static interface Provider {
        public void addRenderLayers(Entity var1, BiConsumer<DataContext, IPackRenderLayer> var2);
    }
}

