/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.renderer.renderlayer;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.threetag.palladium.client.dynamictexture.DynamicTexture;
import net.threetag.palladium.client.dynamictexture.DynamicTextureManager;
import net.threetag.palladium.client.renderer.DynamicColor;
import net.threetag.palladium.client.renderer.renderlayer.AbstractPackRenderLayer;
import net.threetag.palladium.client.renderer.renderlayer.IPackRenderLayer;
import net.threetag.palladium.client.renderer.renderlayer.PackRenderLayerManager;
import net.threetag.palladium.client.renderer.renderlayer.RenderTypeFunction;
import net.threetag.palladium.util.SkinTypedValue;
import net.threetag.palladium.util.context.DataContext;

public class SkinOverlayPackRenderLayer
extends AbstractPackRenderLayer {
    private final SkinTypedValue<DynamicTexture> texture;
    private final RenderTypeFunction renderType;
    private final DynamicColor tint;

    public SkinOverlayPackRenderLayer(SkinTypedValue<DynamicTexture> texture, RenderTypeFunction renderType, DynamicColor tint) {
        this.texture = texture;
        this.renderType = renderType;
        this.tint = tint;
    }

    @Override
    public void render(DataContext context, PoseStack poseStack, MultiBufferSource bufferSource, EntityModel<Entity> parentModel, int packedLight, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        Entity entity = context.getEntity();
        if (IPackRenderLayer.conditionsFulfilled(entity, this.conditions, this.thirdPersonConditions)) {
            Color tint = Color.WHITE;
            if (this.tint != null) {
                tint = this.tint.getColor(context);
            }
            VertexConsumer vertexConsumer = this.renderType.createVertexConsumer(bufferSource, this.texture.get(entity).getTexture(context), context.getItem().m_41790_());
            parentModel.m_7695_(poseStack, vertexConsumer, this.renderType.getPackedLight(packedLight), OverlayTexture.f_118083_, (float)tint.getRed() / 255.0f, (float)tint.getGreen() / 255.0f, (float)tint.getBlue() / 255.0f, (float)tint.getAlpha() / 255.0f);
        }
    }

    @Override
    public void renderArm(DataContext context, HumanoidArm arm, PlayerRenderer playerRenderer, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        Entity player = context.getEntity();
        if (IPackRenderLayer.conditionsFulfilled(player, this.conditions, this.firstPersonConditions)) {
            PlayerModel entityModel = (PlayerModel)playerRenderer.m_7200_();
            VertexConsumer vertexConsumer = this.renderType.createVertexConsumer(bufferSource, this.texture.get(player).getTexture(context), context.getItem().m_41790_());
            entityModel.f_102608_ = 0.0f;
            entityModel.f_102817_ = false;
            entityModel.f_102818_ = 0.0f;
            Color tint = Color.WHITE;
            if (this.tint != null) {
                tint = this.tint.getColor(context);
            }
            ModelPart armToRender = arm == HumanoidArm.RIGHT ? entityModel.f_102811_ : entityModel.f_102812_;
            armToRender.f_104203_ = 0.0f;
            armToRender.m_104306_(poseStack, vertexConsumer, this.renderType.getPackedLight(packedLight), OverlayTexture.f_118083_, (float)tint.getRed() / 255.0f, (float)tint.getGreen() / 255.0f, (float)tint.getBlue() / 255.0f, (float)tint.getAlpha() / 255.0f);
        }
    }

    public static SkinOverlayPackRenderLayer parse(JsonObject json) {
        RenderTypeFunction renderType = PackRenderLayerManager.getRenderType(new ResourceLocation(GsonHelper.m_13851_((JsonObject)json, (String)"render_type", (String)"solid")));
        if (renderType == null) {
            throw new JsonParseException("Unknown render type '" + String.valueOf(new ResourceLocation(GsonHelper.m_13851_((JsonObject)json, (String)"render_type", (String)"solid"))) + "'");
        }
        return new SkinOverlayPackRenderLayer(SkinTypedValue.fromJSON(json.get("texture"), DynamicTextureManager::fromJson), renderType, DynamicColor.getFromJson(json, "tint", null));
    }
}

