/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.renderer.trail;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.client.renderer.DynamicColor;
import net.threetag.palladium.client.renderer.entity.HumanoidRendererModifications;
import net.threetag.palladium.client.renderer.entity.TrailSegmentEntityRenderer;
import net.threetag.palladium.client.renderer.trail.TrailRenderer;
import net.threetag.palladium.client.renderer.trail.TrailRendererManager;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.entity.TrailSegmentEntity;
import net.threetag.palladium.util.json.GsonUtil;

public class AfterImageTrailRenderer
extends TrailRenderer<TrailRenderer.SegmentCache> {
    public static final ResourceLocation TEXTURE = Palladium.id("textures/entity/trail.png");
    private final DynamicColor color;
    public final boolean mimicPlayer;
    private final float spacing;
    private final int lifetime;
    private final float opacity;

    public AfterImageTrailRenderer(DynamicColor color, boolean mimicPlayer, float spacing, int lifetime, float opacity) {
        this.color = color;
        this.mimicPlayer = mimicPlayer;
        this.spacing = spacing;
        this.lifetime = lifetime;
        this.opacity = opacity;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, TrailSegmentEntityRenderer trailRenderer, Entity livingEntity, TrailSegmentEntity<TrailRenderer.SegmentCache> segment, float partialTick, float entityYaw) {
        HumanoidRendererModifications.ALPHA_MULTIPLIER = (1.0f - (float)segment.f_19797_ / (float)segment.lifetime) * this.opacity;
        trailRenderer.renderModel(segment, entityYaw, segment.partialTick, poseStack, buffer, packedLight);
        HumanoidRendererModifications.ALPHA_MULTIPLIER = 1.0f;
    }

    @Override
    public DynamicColor getColor() {
        return this.color;
    }

    @Override
    public float getSpacing() {
        return this.spacing;
    }

    @Override
    public int getLifetime() {
        return this.lifetime;
    }

    public static class Serializer
    implements TrailRendererManager.TypeSerializer {
        @Override
        public TrailRenderer<?> parse(JsonObject json) {
            DynamicColor color = DynamicColor.getFromJson(json, "color", DynamicColor.WHITE);
            boolean mimicPlayer = GsonHelper.m_13855_((JsonObject)json, (String)"mimic_player", (boolean)false);
            float spacing = GsonUtil.getAsFloatMin(json, "spacing", 0.1f, 1.0f);
            int lifetime = GsonUtil.getAsIntMin(json, "lifetime", 1, 20);
            float opacity = GsonUtil.getAsFloatRanged(json, "opacity", 0.0f, 1.0f, 0.5f);
            return new AfterImageTrailRenderer(color, mimicPlayer, spacing, lifetime, opacity);
        }

        @Override
        public void generateDocumentation(JsonDocumentationBuilder builder) {
            builder.setTitle("After Image Trail");
            builder.setDescription("Spawns copies of you as a trail.");
            builder.addProperty("color", Color.class).description("Determines the tint/color of the after image").fallback(Color.WHITE, "#ffffff").exampleJson((JsonElement)new JsonPrimitive("#ffffff"));
            builder.addProperty("mimic_player", Boolean.class).description("If enabled, the after image will copy the player's skin and armor").fallback(false).exampleJson((JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
            builder.addProperty("spacing", Float.class).description("Determines the space between two trail segments").fallback(Float.valueOf(1.0f)).exampleJson((JsonElement)new JsonPrimitive((Number)Float.valueOf(1.0f)));
            builder.addProperty("lifetime", Integer.class).description("Determines how long one trail segment stays alive (in ticks)").fallback(20).exampleJson((JsonElement)new JsonPrimitive((Number)20));
            builder.addProperty("opacity", Float.class).description("Determines the (initial) opacity of the after image.").fallback(Float.valueOf(0.5f)).exampleJson((JsonElement)new JsonPrimitive((Number)Float.valueOf(0.5f)));
        }

        @Override
        public ResourceLocation getId() {
            return Palladium.id("after_image");
        }
    }
}

