/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.renderer.trail;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.client.renderer.DynamicColor;
import net.threetag.palladium.client.renderer.PalladiumRenderTypes;
import net.threetag.palladium.client.renderer.entity.TrailSegmentEntityRenderer;
import net.threetag.palladium.client.renderer.trail.TrailRenderer;
import net.threetag.palladium.client.renderer.trail.TrailRendererManager;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.entity.PalladiumEntityExtension;
import net.threetag.palladium.entity.TrailSegmentEntity;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.json.GsonUtil;
import org.joml.Matrix4f;

public class GradientTrailRenderer
extends TrailRenderer<TrailRenderer.SegmentCache> {
    private final float spacing;
    private final int lifetime;
    private final DynamicColor color;
    private final float opacity;
    private final boolean normalTransparency;

    public GradientTrailRenderer(float spacing, int lifetime, DynamicColor color, float opacity, boolean normalTransparency) {
        this.spacing = spacing;
        this.lifetime = lifetime;
        this.color = color;
        this.opacity = opacity;
        this.normalTransparency = normalTransparency;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, TrailSegmentEntityRenderer trailRenderer, Entity livingEntity, TrailSegmentEntity<TrailRenderer.SegmentCache> segment, float partialTick, float entityYaw) {
        PalladiumEntityExtension ext;
        List<TrailSegmentEntity<?>> trails;
        int index;
        if (livingEntity instanceof PalladiumEntityExtension && (index = (trails = (ext = (PalladiumEntityExtension)livingEntity).palladium$getTrailHandler().getTrails().get(this)).indexOf(segment)) > 0) {
            TrailSegmentEntity<?> prev;
            VertexConsumer vertexConsumer = buffer.m_6299_(this.normalTransparency ? PalladiumRenderTypes.LASER_NORMAL_TRANSPARENCY : PalladiumRenderTypes.LASER);
            Color color = this.color.getColor(DataContext.forEntity(livingEntity));
            float r = (float)color.getRed() / 255.0f;
            float g = (float)color.getGreen() / 255.0f;
            float b = (float)color.getBlue() / 255.0f;
            float segmentOpacity = 1.0f - Mth.m_14036_((float)(((float)segment.f_19797_ + partialTick) / (float)segment.lifetime), (float)0.0f, (float)1.0f);
            if (index == trails.size() - 1) {
                poseStack.m_85836_();
                Vec3 endPos = livingEntity.m_20318_(partialTick).m_82546_(segment.m_20182_());
                Matrix4f matrix = poseStack.m_85850_().m_252922_();
                vertexConsumer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, this.opacity * segmentOpacity).m_85969_(packedLight).m_5752_();
                vertexConsumer.m_252986_(matrix, 0.0f, segment.m_20206_(), 0.0f).m_85950_(r, g, b, this.opacity * segmentOpacity).m_85969_(packedLight).m_5752_();
                vertexConsumer.m_252986_(matrix, (float)endPos.f_82479_, (float)(endPos.f_82480_ + (double)livingEntity.m_20206_()), (float)endPos.f_82481_).m_85950_(r, g, b, this.opacity * segmentOpacity).m_85969_(packedLight).m_5752_();
                vertexConsumer.m_252986_(matrix, (float)endPos.f_82479_, (float)endPos.f_82480_, (float)endPos.f_82481_).m_85950_(r, g, b, this.opacity * segmentOpacity).m_85969_(packedLight).m_5752_();
                poseStack.m_85849_();
            }
            if (!(prev = trails.get(index - 1)).m_6084_()) {
                return;
            }
            Vec3 endPos = prev.m_20182_().m_82546_(segment.m_20182_());
            float prevOpacity = 1.0f - Mth.m_14036_((float)(((float)prev.f_19797_ + partialTick) / (float)prev.lifetime), (float)0.0f, (float)1.0f);
            poseStack.m_85836_();
            Matrix4f matrix = poseStack.m_85850_().m_252922_();
            vertexConsumer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, this.opacity * segmentOpacity).m_85969_(packedLight).m_5752_();
            vertexConsumer.m_252986_(matrix, 0.0f, segment.m_20206_(), 0.0f).m_85950_(r, g, b, this.opacity * segmentOpacity).m_85969_(packedLight).m_5752_();
            vertexConsumer.m_252986_(matrix, (float)endPos.f_82479_, (float)(endPos.f_82480_ + (double)prev.m_20206_()), (float)endPos.f_82481_).m_85950_(r, g, b, this.opacity * prevOpacity).m_85969_(packedLight).m_5752_();
            vertexConsumer.m_252986_(matrix, (float)endPos.f_82479_, (float)endPos.f_82480_, (float)endPos.f_82481_).m_85950_(r, g, b, this.opacity * prevOpacity).m_85969_(packedLight).m_5752_();
            poseStack.m_85849_();
        }
    }

    @Override
    public float getSpacing() {
        return this.spacing;
    }

    @Override
    public int getLifetime() {
        return this.lifetime;
    }

    @Override
    public DynamicColor getColor() {
        return this.color;
    }

    public static class Serializer
    implements TrailRendererManager.TypeSerializer {
        @Override
        public TrailRenderer<?> parse(JsonObject json) {
            DynamicColor color = DynamicColor.getFromJson(json, "color", DynamicColor.WHITE);
            float spacing = GsonUtil.getAsFloatMin(json, "spacing", 0.1f, 1.0f);
            int lifetime = GsonUtil.getAsIntMin(json, "lifetime", 1, 20);
            float opacity = GsonUtil.getAsFloatRanged(json, "opacity", 0.0f, 1.0f, 0.5f);
            boolean normalTransparency = GsonHelper.m_13855_((JsonObject)json, (String)"normal_transparency", (boolean)false);
            return new GradientTrailRenderer(spacing, lifetime, color, opacity, normalTransparency);
        }

        @Override
        public void generateDocumentation(JsonDocumentationBuilder builder) {
            builder.setTitle("Gradient Trail");
            builder.setDescription("Renders a simple, colored gradient trail.");
            builder.addProperty("color", Color.class).description("Determines the tint/color of the gradient").fallback(Color.WHITE, "#ffffff").exampleJson((JsonElement)new JsonPrimitive("#ffffff"));
            builder.addProperty("spacing", Float.class).description("Determines the space between two trail segments").fallback(Float.valueOf(1.0f)).exampleJson((JsonElement)new JsonPrimitive((Number)Float.valueOf(1.0f)));
            builder.addProperty("lifetime", Integer.class).description("Determines how long one trail segment stays alive (in ticks)").fallback(20).exampleJson((JsonElement)new JsonPrimitive((Number)20));
            builder.addProperty("opacity", Float.class).description("Determines the (initial) opacity of the after image.").fallback(Float.valueOf(0.5f)).exampleJson((JsonElement)new JsonPrimitive((Number)Float.valueOf(0.5f)));
            builder.addProperty("normal_transparency", Boolean.class).description("Can be turned on if you want to make a gradient black.").fallback(false).exampleJson((JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
        }

        @Override
        public ResourceLocation getId() {
            return Palladium.id("gradient");
        }
    }
}

