/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.OptionsSubScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.SkinCustomizationScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTabs;
import net.threetag.palladium.PalladiumConfig;
import net.threetag.palladium.accessory.Accessory;
import net.threetag.palladium.accessory.AccessorySlot;
import net.threetag.palladium.client.screen.components.EditButton;
import net.threetag.palladium.client.screen.components.FlatIconButton;
import net.threetag.palladium.condition.InAccessorySlotMenuCondition;
import net.threetag.palladium.network.ToggleAccessoryMessage;
import net.threetag.palladium.util.SupporterHandler;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladiumcore.event.ScreenEvents;
import net.threetag.palladiumcore.util.Platform;
import org.joml.Quaternionf;

public class AccessoryScreen
extends OptionsSubScreen {
    public AccessorySlot currentSlot;
    public AccessorySlotList slotList;
    public AccessoryList accessoryList;
    public RotationSlider rotationSlider;
    public float rotation = 180.0f;

    public AccessoryScreen(Screen screen) {
        super(screen, null, (Component)Component.m_237115_((String)"gui.palladium.accessories"));
    }

    public static void addButton() {
        ScreenEvents.INIT_POST.register(screen -> {
            if (((Boolean)PalladiumConfig.Client.ACCESSORY_BUTTON.get()).booleanValue()) {
                InventoryScreen inv;
                Button button = null;
                MutableComponent text = Component.m_237115_((String)"gui.palladium.accessories");
                if (screen instanceof SkinCustomizationScreen) {
                    button = Button.m_253074_((Component)text, b -> Minecraft.m_91087_().m_91152_((Screen)new AccessoryScreen(screen))).m_252987_(screen.f_96543_ / 2 - 100, screen.f_96544_ / 6 + 144, 200, 20).m_253136_();
                }
                if (screen instanceof InventoryScreen) {
                    inv = (InventoryScreen)screen;
                    button = new EditButton(inv.f_97735_ + 63, inv.f_97736_ + 66, b -> Minecraft.m_91087_().m_91152_((Screen)new AccessoryScreen(screen))){

                        public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                            this.m_264152_(inv.f_97735_ + 63, inv.f_97736_ + 66);
                            super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
                        }
                    };
                    button.m_257544_(Tooltip.m_257550_((Component)text));
                }
                if (screen instanceof CreativeModeInventoryScreen) {
                    inv = (CreativeModeInventoryScreen)screen;
                    button = new EditButton(inv.f_97735_ + 93, inv.f_97736_ + 37, b -> Minecraft.m_91087_().m_91152_((Screen)new AccessoryScreen(screen))){

                        public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                            this.f_93624_ = CreativeModeInventoryScreen.f_98507_ == BuiltInRegistries.f_279662_.m_6246_(CreativeModeTabs.f_257039_);
                            super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
                        }
                    };
                    button.m_257544_(Tooltip.m_257550_((Component)text));
                }
                if (button != null) {
                    button.f_93623_ = Minecraft.m_91087_().f_91074_ != null && !Accessory.getAvailableAccessories(SupporterHandler.getPlayerData(Minecraft.m_91087_().f_91074_.m_36316_().getId())).isEmpty();
                    screen.m_142416_(button);
                }
            }
        });
    }

    public boolean m_7043_() {
        return false;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.done"), button -> this.m_7379_()).m_252987_(30, this.f_96544_ - 30, 100, 20).m_253136_());
        this.rotationSlider = new RotationSlider(100 + (this.f_96543_ - 150) / 2, this.f_96544_ / 2 + this.f_96544_ / 3 + 10, 100, 20, 0.5);
        this.m_142416_((GuiEventListener)this.rotationSlider);
        this.slotList = new AccessorySlotList(this.f_96541_, this, 42, this.f_96544_, 20, this.f_96544_ - 40, 36);
        this.slotList.m_93507_(6);
        this.m_7787_((GuiEventListener)this.slotList);
        Objects.requireNonNull(this.f_96547_);
        this.accessoryList = new AccessoryList(this.f_96541_, this, 150, this.f_96544_, 20, this.f_96544_ - 40, 9 + 8);
        this.accessoryList.m_93507_(48);
        this.m_7787_((GuiEventListener)this.accessoryList);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        this.renderDirtBackground(0, 160);
        if (this.accessoryList != null) {
            this.accessoryList.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        }
        if (this.slotList != null) {
            this.slotList.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        }
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, 80, 7, 0xFFFFFF);
        InAccessorySlotMenuCondition.CURRENT_SLOT = this.currentSlot;
        Quaternionf quaternionf = new Quaternionf().rotateX((float)Math.toRadians(190.0)).rotateY((float)Math.toRadians(this.rotation));
        LocalPlayer player = Objects.requireNonNull(Objects.requireNonNull(this.f_96541_).f_91074_);
        float h = player.f_20883_;
        float i = player.m_146908_();
        float j = player.m_146909_();
        float k = player.f_20886_;
        float l = player.f_20885_;
        player.f_20883_ = 180.0f;
        player.m_146922_(180.0f);
        player.m_146926_(0.0f);
        player.f_20885_ = player.m_146908_();
        player.f_20886_ = player.m_146908_();
        InventoryScreen.m_280432_((GuiGraphics)guiGraphics, (int)(150 + (this.f_96543_ - 150) / 2), (int)(this.f_96544_ / 2 + this.f_96544_ / 3), (int)(this.f_96544_ / 3), (Quaternionf)quaternionf, null, (LivingEntity)player);
        player.f_20883_ = h;
        player.m_146922_(i);
        player.m_146926_(j);
        player.f_20886_ = k;
        player.f_20885_ = l;
        InAccessorySlotMenuCondition.CURRENT_SLOT = null;
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void renderDirtBackground(int vOffset, int width) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)f_279548_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float f = 32.0f;
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferBuilder.m_5483_(0.0, (double)this.f_96544_, 0.0).m_7421_(0.0f, (float)this.f_96544_ / 32.0f + (float)vOffset).m_6122_(64, 64, 64, 255).m_5752_();
        bufferBuilder.m_5483_((double)width, (double)this.f_96544_, 0.0).m_7421_((float)width / 32.0f, (float)this.f_96544_ / 32.0f + (float)vOffset).m_6122_(64, 64, 64, 255).m_5752_();
        bufferBuilder.m_5483_((double)width, 0.0, 0.0).m_7421_((float)width / 32.0f, (float)vOffset).m_6122_(64, 64, 64, 255).m_5752_();
        bufferBuilder.m_5483_(0.0, 0.0, 0.0).m_7421_(0.0f, (float)vOffset).m_6122_(64, 64, 64, 255).m_5752_();
        tesselator.m_85914_();
    }

    public class RotationSlider
    extends AbstractSliderButton {
        public RotationSlider(int x, int y, int width, int height, double value) {
            super(x, y, width, height, (Component)Component.m_237119_(), value);
        }

        protected void m_5695_() {
            this.m_93666_((Component)Component.m_237119_());
        }

        protected void m_5697_() {
            AccessoryScreen.this.rotation = (float)(this.f_93577_ * 360.0);
        }
    }

    public static class AccessorySlotList
    extends AbstractSelectionList<SlotListEntry> {
        private final int listWidth;

        public AccessorySlotList(Minecraft minecraft, AccessoryScreen parent, int width, int height, int top, int bottom, int slotHeight) {
            super(minecraft, width, height, top, bottom, slotHeight);
            this.listWidth = width;
            DataContext context = DataContext.forEntity((Entity)minecraft.f_91074_);
            for (AccessorySlot slot : AccessorySlot.getSlots().stream().sorted(Comparator.comparingInt(AccessorySlot::getSortIndex)).toList()) {
                if (Accessory.getAvailableAccessories(SupporterHandler.getPlayerData(minecraft.f_91074_.m_20148_()), slot).isEmpty() || !slot.isVisible(context)) continue;
                Accessory.getPlayerData((Player)minecraft.f_91074_).ifPresent(data -> this.m_7085_(new SlotListEntry(slot, parent, data.getSlots().containsKey(slot) && !data.getSlots().get(slot).isEmpty())));
            }
        }

        public int m_5759_() {
            return this.listWidth;
        }

        protected int m_5756_() {
            return this.listWidth;
        }

        public void m_142291_(NarrationElementOutput narrationElementOutput) {
        }
    }

    public static class AccessoryList
    extends AbstractSelectionList<AccessoryListEntry> {
        private final AccessoryScreen parent;
        private final int listWidth;

        public AccessoryList(Minecraft minecraft, AccessoryScreen parent, int width, int height, int top, int bottom, int slotHeight) {
            super(minecraft, width, height, top, bottom, slotHeight);
            this.listWidth = width;
            this.parent = parent;
            this.refreshList();
        }

        public void refreshList() {
            this.m_93516_();
            ArrayList accessories = Lists.newArrayList();
            if (this.parent.currentSlot != null) {
                Accessory.getPlayerData((Player)this.f_93386_.f_91074_).ifPresent(a -> {
                    if (a.getSlots().containsKey(this.parent.currentSlot)) {
                        accessories.addAll(a.getSlots().get(this.parent.currentSlot));
                    }
                });
                for (Accessory accessory : Accessory.REGISTRY.getValues()) {
                    if (!accessory.getPossibleSlots().contains(this.parent.currentSlot) || !accessory.isAvailable((Player)Minecraft.m_91087_().f_91074_)) continue;
                    this.m_7085_(new AccessoryListEntry(accessory, this.parent, accessories.contains(accessory)));
                }
            }
        }

        public void m_142291_(NarrationElementOutput narrationElementOutput) {
        }

        public int m_5759_() {
            return this.listWidth;
        }

        protected int m_5756_() {
            return this.listWidth;
        }
    }

    public static class AccessoryListEntry
    extends AbstractSelectionList.Entry<AccessoryListEntry> {
        private final Accessory accessory;
        private final AccessoryScreen parent;
        private final boolean active;

        public AccessoryListEntry(Accessory accessory, AccessoryScreen parent, boolean active) {
            this.accessory = accessory;
            this.parent = parent;
            this.active = active;
        }

        public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
            Font fontRenderer = this.parent.f_96547_;
            Component name = this.accessory.getDisplayName();
            if (!Platform.isProduction() && !SupporterHandler.getPlayerData(Minecraft.m_91087_().f_91074_.m_20148_()).getAccessories().contains(this.accessory)) {
                name = name.m_6881_().m_130940_(ChatFormatting.STRIKETHROUGH);
            }
            guiGraphics.m_280648_(fontRenderer, (FormattedCharSequence)fontRenderer.m_92923_((FormattedText)name, width - 25).get(0), left, top + 4, isMouseOver ? 0xFFFFA0 : 0xFEFEFE);
            if (this.active) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                guiGraphics.m_280163_(FlatIconButton.WIDGETS_LOCATION, left + width - 25, top + 2, 0.0f, 120.0f, 16, 16, 256, 256);
            }
        }

        public boolean m_6375_(double mouseX, double mouseY, int type) {
            new ToggleAccessoryMessage(this.parent.currentSlot, this.accessory).send();
            this.parent.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            return false;
        }
    }

    public static class SlotListEntry
    extends AbstractSelectionList.Entry<SlotListEntry> {
        private final AccessorySlot slot;
        private final AccessoryScreen parent;
        private final boolean active;

        public SlotListEntry(AccessorySlot slot, AccessoryScreen parent, boolean active) {
            this.slot = slot;
            this.parent = parent;
            this.active = active;
        }

        public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.m_280163_(FlatIconButton.WIDGETS_LOCATION, left, top + 2, 20.0f, (float)(this.parent.currentSlot == this.slot ? 64 : (isMouseOver ? 32 : 0)), 32, 32, 256, 256);
            Font fontRenderer = this.parent.f_96547_;
            if (this.slot.getIcon() != null) {
                guiGraphics.m_280163_(this.slot.getIcon(), left, top + 2, 0.0f, 0.0f, 32, 32, 32, 32);
            } else {
                String s = this.slot.getDisplayName().getString().substring(0, 1);
                guiGraphics.m_280648_(fontRenderer, Component.m_237113_((String)s).m_7532_(), (int)((float)(left + 16) - (float)fontRenderer.m_92895_(s) / 2.0f), top + 14, isMouseOver ? 0xFFFFA0 : 0xFEFEFE);
            }
            if (isMouseOver) {
                guiGraphics.m_280557_(fontRenderer, this.slot.getDisplayName(), mouseX, mouseY);
            }
        }

        public boolean m_6375_(double mouseX, double mouseY, int type) {
            this.parent.currentSlot = this.slot;
            this.parent.accessoryList.refreshList();
            this.parent.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            return false;
        }
    }
}

