/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.screen;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.threetag.palladium.addonpack.log.AddonPackLogEntry;
import net.threetag.palladium.client.screen.AddonPackLogEntryScreen;
import org.jetbrains.annotations.Nullable;

public class AddonPackLogScreen
extends Screen {
    public DevLogList list;
    public EditBox textFieldWidget;
    @Nullable
    public Screen parent;
    public List<AddonPackLogEntry> logs;
    public static boolean INFO_FILTER = false;
    public static boolean WARNINGS_FILTER = true;
    public static boolean ERRORS_FILTER = true;

    public AddonPackLogScreen(List<AddonPackLogEntry> logs, @Nullable Screen parent) {
        super((Component)Component.m_237115_((String)"gui.palladium.addon_pack_log"));
        this.logs = logs;
        this.parent = parent;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.textFieldWidget = new EditBox(this.f_96547_, this.f_96543_ / 2 - 310, this.f_96544_ - 27, 620 - (this.parent != null ? 90 : 0), 17, (Component)Component.m_237115_((String)"gui.palladium.addon_pack_log.search"));
        this.m_7787_((GuiEventListener)this.textFieldWidget);
        this.textFieldWidget.m_93692_(false);
        this.textFieldWidget.m_94190_(true);
        this.textFieldWidget.m_94151_(search -> this.list.refreshList());
        this.list = new DevLogList(this.f_96541_, this.f_96543_, this.f_96544_, 48, this.f_96544_ - 64, 36);
        this.m_7787_((GuiEventListener)this.list);
        if (this.parent != null) {
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130656_, button -> Objects.requireNonNull(this.f_96541_).m_91152_(this.parent)).m_252987_(this.f_96543_ / 2 + 310 - 70, this.f_96544_ - 28, 75, 20).m_253136_());
        }
        this.m_142416_((GuiEventListener)new CheckboxButton(this.f_96543_ / 2 - 310, this.f_96544_ - 52, 70, 20, (Component)Component.m_237113_((String)"INFO").m_130940_(AddonPackLogEntry.Type.INFO.getColor()), INFO_FILTER, b -> {
            INFO_FILTER = b;
        }));
        this.m_142416_((GuiEventListener)new CheckboxButton(this.f_96543_ / 2 - 35, this.f_96544_ - 52, 70, 20, (Component)Component.m_237113_((String)"WARNING").m_130940_(AddonPackLogEntry.Type.WARNING.getColor()), WARNINGS_FILTER, b -> {
            WARNINGS_FILTER = b;
        }));
        this.m_142416_((GuiEventListener)new CheckboxButton(this.f_96543_ / 2 + 310 - 50, this.f_96544_ - 52, 70, 20, (Component)Component.m_237113_((String)"ERROR").m_130940_(AddonPackLogEntry.Type.ERROR.getColor()), ERRORS_FILTER, b -> {
            ERRORS_FILTER = b;
        }));
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        if (this.list != null) {
            this.list.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        }
        if (this.textFieldWidget != null) {
            this.textFieldWidget.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        }
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 20, 0xFFFFFF);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.textFieldWidget != null) {
            this.textFieldWidget.m_94120_();
        }
    }

    public class DevLogList
    extends AbstractSelectionList<DevLogEntry> {
        private final int listWidth;

        public DevLogList(Minecraft mcIn, int widthIn, int heightIn, int topIn, int bottomIn, int slotHeightIn) {
            super(mcIn, widthIn, heightIn, topIn, bottomIn, slotHeightIn);
            this.listWidth = 620;
            this.refreshList();
        }

        public void refreshList() {
            this.m_93516_();
            for (AddonPackLogEntry info : AddonPackLogScreen.this.logs) {
                if (AddonPackLogScreen.this.textFieldWidget.m_94155_() != null && !AddonPackLogScreen.this.textFieldWidget.m_94155_().isEmpty() && !info.getText().toLowerCase(Locale.ROOT).contains(AddonPackLogScreen.this.textFieldWidget.m_94155_()) || info.getType() == AddonPackLogEntry.Type.INFO && !INFO_FILTER || info.getType() == AddonPackLogEntry.Type.WARNING && !WARNINGS_FILTER || info.getType() == AddonPackLogEntry.Type.ERROR && !ERRORS_FILTER) continue;
                this.m_7085_(new DevLogEntry(info));
            }
        }

        public int m_5759_() {
            return this.listWidth;
        }

        protected int m_5756_() {
            return this.f_93388_ / 2 + this.m_5759_() / 2 + 4;
        }

        public void m_142291_(NarrationElementOutput narrationElementOutput) {
        }
    }

    public class CheckboxButton
    extends Checkbox {
        private final Consumer<Boolean> consumer;

        public CheckboxButton(int pX, int pY, int pWidth, int pHeight, Component pMessage, boolean pSelected, Consumer<Boolean> consumer) {
            super(pX, pY, pWidth, pHeight, pMessage, pSelected, true);
            this.consumer = consumer;
        }

        public CheckboxButton(int pX, int pY, int pWidth, int pHeight, Component pMessage, boolean pSelected, boolean pShowLabel, Consumer<Boolean> consumer) {
            super(pX, pY, pWidth, pHeight, pMessage, pSelected, pShowLabel);
            this.consumer = consumer;
        }

        public void m_5691_() {
            super.m_5691_();
            this.consumer.accept(this.m_93840_());
            AddonPackLogScreen.this.list.refreshList();
        }
    }

    public class DevLogEntry
    extends AbstractSelectionList.Entry<DevLogEntry> {
        private final AddonPackLogEntry info;

        public DevLogEntry(AddonPackLogEntry info) {
            this.info = info;
        }

        public void m_6311_(GuiGraphics guiGraphics, int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
            guiGraphics.m_280509_(left, top + 33, left + entryWidth, top + 34, -1601138544);
            guiGraphics.m_280614_(AddonPackLogScreen.this.f_96547_, (Component)Component.m_237113_((String)this.info.getType().toString()).m_130940_(this.info.getType().getColor()), left, top + 12, isMouseOver ? 0xFFFFA0 : 0xFEFEFE, true);
            MutableComponent msg = Component.m_237113_((String)this.info.getText()).m_130940_(this.info.getType().getColor());
            List lines = AddonPackLogScreen.this.f_96547_.m_92923_((FormattedText)msg, 560);
            int maxLines = Math.min(lines.size(), 3);
            for (int i = 0; i < lines.size(); ++i) {
                FormattedCharSequence processor = (FormattedCharSequence)lines.get(i);
                if (i >= 3) continue;
                guiGraphics.m_280649_(AddonPackLogScreen.this.f_96547_, processor, left + 50, (int)((float)(top + 2) + (10.0f - (float)(maxLines - 1) * 10.0f / 2.0f) + (float)(i * 10)), isMouseOver ? 0xFFFFA0 : 0xFEFEFE, true);
            }
            if (lines.size() > 3) {
                guiGraphics.m_280056_(AddonPackLogScreen.this.f_96547_, "[...]", left + 602, top + 2 + (maxLines - 1) * 10, isMouseOver ? 0xFFFFA0 : 0xFEFEFE, true);
            }
        }

        public boolean m_6375_(double mouseX, double mouseY, int type) {
            Objects.requireNonNull(AddonPackLogScreen.this.f_96541_).m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            AddonPackLogScreen.this.f_96541_.m_91152_((Screen)new AddonPackLogEntryScreen(AddonPackLogScreen.this, this.info));
            return true;
        }
    }
}

