/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.screen.power;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.threetag.palladium.client.dynamictexture.TextureReference;
import net.threetag.palladium.client.screen.power.PowerTab;
import net.threetag.palladium.client.screen.power.PowerTabType;
import net.threetag.palladium.client.screen.power.PowersScreen;
import net.threetag.palladium.network.RequestAbilityBuyScreenMessage;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityDescription;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.util.context.DataContext;
import org.jetbrains.annotations.Nullable;

public class ListPowerTab
extends PowerTab {
    private AbilityList list;
    private AbilityInstance hovered;

    protected ListPowerTab(Minecraft minecraft, PowersScreen screen, PowerTabType type, int tabIndex, IPowerHolder powerHolder) {
        super(minecraft, screen, type, tabIndex, powerHolder);
    }

    @Override
    public void populate() {
        int i = (this.screen.f_96543_ - 252) / 2;
        int j = (this.screen.f_96544_ - 196) / 2;
        this.list = new AbilityList(this.minecraft, this, 234, 169, i + 9, j + 18, 30);
        this.list.populate(this.powerHolder);
    }

    @Override
    public void onOpened() {
        this.populate();
        if (this.list != null) {
            this.screen.m_7787_((GuiEventListener)this.list);
        }
    }

    @Override
    public void onClosed() {
        if (this.list != null) {
            this.screen.m_169411_((GuiEventListener)this.list);
        }
    }

    @Override
    public void drawContents(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, float partialTick) {
        TextureReference backgroundTexture = this.powerHolder.getPower().getBackground();
        ResourceLocation texture = backgroundTexture != null ? backgroundTexture.getTexture(DataContext.forPower((LivingEntity)this.minecraft.f_91074_, this.powerHolder)) : new ResourceLocation("textures/block/red_wool.png");
        for (int m = -1; m <= 13; ++m) {
            for (int n = -1; n <= 9; ++n) {
                guiGraphics.m_280163_(texture, x + 10 + 16 * m, y + 10 + 16 * n, 0.0f, 0.0f, 16, 16, 16, 16);
            }
        }
        this.hovered = null;
        if (this.list != null) {
            this.list.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    @Override
    public void drawTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY, int width, int height, float partialTick, boolean overlayActive) {
        AbilityDescription description;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, -200.0f);
        guiGraphics.m_280509_(0, 0, 234, 169, Mth.m_14143_((float)(this.fade * 255.0f)) << 24);
        guiGraphics.m_280168_().m_85849_();
        if (this.hovered != null && !overlayActive && (description = this.hovered.getProperty(Ability.DESCRIPTION)) != null) {
            guiGraphics.m_280245_(this.minecraft.f_91062_, this.minecraft.f_91062_.m_92923_((FormattedText)description.get(this.hovered.isUnlocked()), 150), mouseX, mouseY);
        }
        if (!overlayActive) {
            this.fade = Mth.m_14036_((float)(this.fade - 0.04f), (float)0.0f, (float)1.0f);
        }
    }

    @Nullable
    public static ListPowerTab create(Minecraft minecraft, PowersScreen screen, int tabIndex, IPowerHolder powerHolder) {
        PowerTabType[] tabTypes;
        for (PowerTabType tabType : tabTypes = PowerTabType.values()) {
            if (tabIndex < tabType.getMax()) {
                return new ListPowerTab(minecraft, screen, tabType, tabIndex, powerHolder);
            }
            tabIndex -= tabType.getMax();
        }
        return null;
    }

    public static class AbilityList
    extends AbstractSelectionList<ListEntry> {
        private final ListPowerTab parent;
        private final int listWidth;

        public AbilityList(Minecraft minecraft, ListPowerTab screen, int width, int height, int x, int y, int itemHeight) {
            super(minecraft, width, height, y, y + height, itemHeight);
            this.m_93507_(x);
            this.populate(screen.powerHolder);
            this.m_93488_(false);
            this.m_93496_(false);
            this.m_93471_(false);
            this.parent = screen;
            this.listWidth = width;
        }

        public void populate(IPowerHolder powerHolder) {
            this.m_93516_();
            for (AbilityInstance ability : powerHolder.getAbilities().values()) {
                if (ability.getProperty(Ability.HIDDEN_IN_GUI).booleanValue()) continue;
                this.m_7085_(new ListEntry(ability, this, this.f_93386_));
            }
        }

        public int m_5759_() {
            return this.listWidth;
        }

        protected int m_5756_() {
            return this.f_93393_ + this.listWidth - 9;
        }

        public void m_142291_(NarrationElementOutput narrationElementOutput) {
        }
    }

    public static class ListEntry
    extends AbstractSelectionList.Entry<ListEntry> {
        private final AbilityInstance abilityInstance;
        private final AbilityList list;
        private final Minecraft minecraft;

        public ListEntry(AbilityInstance abilityInstance, AbilityList list, Minecraft minecraft) {
            this.abilityInstance = abilityInstance;
            this.list = list;
            this.minecraft = minecraft;
        }

        public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            guiGraphics.m_280168_().m_85836_();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.m_280218_(PowersScreen.WIDGETS, left, top, 0, 130 + (this.abilityInstance.isUnlocked() ? (hovering ? 2 : 0) : 1) * 26, width, height);
            if (this.abilityInstance.isUnlocked()) {
                this.abilityInstance.getProperty(Ability.ICON).draw(this.minecraft, guiGraphics, DataContext.forAbility((LivingEntity)this.minecraft.f_91074_, this.abilityInstance), left + 5, top + 5);
            } else {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                guiGraphics.m_280218_(PowersScreen.WIDGETS, left + 5, top + 5, 90, 83, 16, 16);
                if (this.abilityInstance.getConfiguration().isBuyable()) {
                    guiGraphics.m_280218_(PowersScreen.WIDGETS, left + 14, top + 16, 106, 83, 7, 7);
                }
            }
            guiGraphics.m_280649_(this.minecraft.f_91062_, Language.m_128107_().m_5536_(this.minecraft.f_91062_.m_92854_((FormattedText)this.abilityInstance.getConfiguration().getDisplayName(), 180)), left + 30, top + 9, this.abilityInstance.isUnlocked() ? (hovering ? 16579710 : 6774089) : 3354149, false);
            guiGraphics.m_280168_().m_85849_();
            if (hovering) {
                this.list.parent.hovered = this.abilityInstance;
            }
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (this.abilityInstance.getConfiguration().isBuyable()) {
                new RequestAbilityBuyScreenMessage(this.abilityInstance.getReference()).send();
            }
            return true;
        }
    }
}

