/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.screen.power;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.threetag.palladium.client.screen.components.IconButton;
import net.threetag.palladium.client.screen.power.ListPowerTab;
import net.threetag.palladium.client.screen.power.PowerTab;
import net.threetag.palladium.client.screen.power.PowerTabType;
import net.threetag.palladium.client.screen.power.TreePowerTab;
import net.threetag.palladium.event.PalladiumClientEvents;
import net.threetag.palladium.power.Power;
import net.threetag.palladium.power.PowerHandler;
import net.threetag.palladium.power.PowerManager;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.util.icon.IIcon;
import net.threetag.palladium.util.icon.ItemIcon;
import net.threetag.palladiumcore.event.ScreenEvents;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

public class PowersScreen
extends Screen {
    public static final ResourceLocation WINDOW = new ResourceLocation("palladium", "textures/gui/powers/window.png");
    public static final ResourceLocation TABS = new ResourceLocation("palladium", "textures/gui/powers/tabs.png");
    public static final ResourceLocation WIDGETS = new ResourceLocation("palladium", "textures/gui/powers/widgets.png");
    public static final int WINDOW_WIDTH = 252;
    public static final int WINDOW_HEIGHT = 196;
    public static final int WINDOW_INSIDE_X = 9;
    public static final int WINDOW_INSIDE_Y = 18;
    public static final int WINDOW_INSIDE_WIDTH = 234;
    public static final int WINDOW_INSIDE_HEIGHT = 169;
    private static final int WINDOW_TITLE_X = 8;
    private static final int WINDOW_TITLE_Y = 6;
    public static final int BACKGROUND_TILE_WIDTH = 16;
    public static final int BACKGROUND_TILE_HEIGHT = 16;
    public static final int BACKGROUND_TILE_COUNT_X = 14;
    public static final int BACKGROUND_TILE_COUNT_Y = 7;
    private static final Component VERY_SAD_LABEL = Component.m_237115_((String)"advancements.sad_label");
    private static final Component NO_ADVANCEMENTS_LABEL = Component.m_237115_((String)"advancements.empty");
    private static final Component TITLE = Component.m_237115_((String)"gui.palladium.powers");
    private final List<PowerTab> tabs = new ArrayList<PowerTab>();
    @Nullable
    public PowerTab selectedTab;
    private boolean isScrolling;
    private static int tabPage;
    private static int maxPages;
    public Screen overlayScreen = null;

    public PowersScreen() {
        super((Component)Component.m_237119_());
    }

    public static void register() {
        ScreenEvents.INIT_POST.register(screen -> {
            Vector2i guiPos = RotatingIconButton.getPos(screen);
            if (guiPos != null) {
                RotatingIconButton button = new RotatingIconButton(guiPos.x, guiPos.y, screen, new ItemIcon(ItemStack.f_41583_), b -> Minecraft.m_91087_().m_91152_((Screen)new PowersScreen()));
                screen.m_142416_((GuiEventListener)button);
                button.m_257544_(Tooltip.m_257550_((Component)TITLE));
            }
        });
    }

    protected void m_7856_() {
        this.tabs.clear();
        if (this.selectedTab != null) {
            this.selectedTab.onClosed();
        }
        this.selectedTab = null;
        AtomicInteger i = new AtomicInteger();
        PowerManager.getPowerHandler((LivingEntity)Objects.requireNonNull(this.f_96541_).f_91074_).ifPresent(handler -> handler.getPowerHolders().values().stream().sorted(Comparator.comparingInt(holder -> PowerManager.getInstance(false).getPowers().stream().toList().indexOf(holder.getPower()))).forEach(holder -> {
            if (!holder.getPower().isHidden() && holder.getAbilities().values().stream().anyMatch(en -> en.getProperty(Ability.HIDDEN_IN_GUI) == false)) {
                Power.GuiDisplayType type = holder.getPower().getGuiDisplayType();
                if (type == Power.GuiDisplayType.AUTO) {
                    Power.GuiDisplayType guiDisplayType = type = TreePowerTab.canBeTree(holder) ? Power.GuiDisplayType.TREE : Power.GuiDisplayType.LIST;
                }
                if (type == Power.GuiDisplayType.TREE) {
                    this.tabs.add(TreePowerTab.create(this.f_96541_, this, i.getAndIncrement(), holder));
                } else {
                    this.tabs.add(ListPowerTab.create(this.f_96541_, this, i.getAndIncrement(), holder));
                }
            }
        }));
        if (this.tabs.size() > PowerTabType.MAX_TABS) {
            int guiLeft = (this.f_96543_ - 252) / 2;
            int guiTop = (this.f_96544_ - 196) / 2;
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"<"), b -> {
                tabPage = Math.max(tabPage - 1, 0);
            }).m_252987_(guiLeft, guiTop - 50, 20, 20).m_253136_());
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)">"), b -> {
                tabPage = Math.min(tabPage + 1, maxPages);
            }).m_252987_(guiLeft + 252 - 20, guiTop - 50, 20, 20).m_253136_());
            maxPages = this.tabs.size() / PowerTabType.MAX_TABS;
        }
        if (!this.tabs.isEmpty()) {
            this.selectedTab = this.tabs.get(0);
            this.selectedTab.onOpened();
        }
        if (this.overlayScreen != null) {
            this.overlayScreen.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
        }
    }

    public void m_169411_(GuiEventListener listener) {
        super.m_169411_(listener);
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int i = (this.f_96543_ - 252) / 2;
            int j = (this.f_96544_ - 196) / 2;
            if (this.isOverOverlayScreen(mouseX, mouseY)) {
                return this.overlayScreen.m_6375_(mouseX, mouseY, button);
            }
            for (PowerTab powerTab : this.tabs) {
                if (!powerTab.isMouseOver(i, j, mouseX, mouseY)) continue;
                if (this.selectedTab != null) {
                    this.selectedTab.onClosed();
                }
                this.selectedTab = powerTab;
                this.selectedTab.onOpened();
                break;
            }
            if (this.selectedTab != null) {
                this.selectedTab.mouseClicked(mouseX, mouseY, button);
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        return this.overlayScreen == null ? super.m_7933_(keyCode, scanCode, modifiers) : this.overlayScreen.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int i = (this.f_96543_ - 252) / 2;
        int j = (this.f_96544_ - 196) / 2;
        this.m_280273_(guiGraphics);
        this.renderInside(guiGraphics, mouseX, mouseY, i, j, partialTick);
        this.renderWindow(guiGraphics, i, j);
        this.renderTooltips(guiGraphics, mouseX, mouseY, i, j, partialTick);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        if (this.selectedTab != null && this.overlayScreen != null) {
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 500.0f);
            this.overlayScreen.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
            this.selectedTab.fade = Mth.m_14036_((float)(this.selectedTab.fade + 0.02f), (float)0.0f, (float)0.5f);
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, -500.0f);
        }
        ResourceLocation powerId = this.selectedTab != null ? this.selectedTab.powerHolder.getPower().getId() : null;
        ((PalladiumClientEvents.RenderPowerScreen)PalladiumClientEvents.RENDER_POWER_SCREEN.invoker()).renderPowerScreen(this, guiGraphics, mouseX, mouseY, partialTick, powerId);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        boolean inWindow;
        int x1 = (this.f_96543_ - 252) / 2 + 9;
        int y1 = (this.f_96544_ - 196) / 2 + 18;
        boolean bl = inWindow = mouseX >= (double)x1 && mouseX <= (double)(x1 + 234) && mouseY >= (double)y1 && mouseY <= (double)(y1 + 169);
        if (button != 0) {
            this.isScrolling = false;
            return false;
        }
        if (this.isScrolling || inWindow) {
            if (!this.isScrolling) {
                this.isScrolling = true;
            } else {
                PowerTab powerTab = this.selectedTab;
                if (powerTab instanceof TreePowerTab) {
                    TreePowerTab tree = (TreePowerTab)powerTab;
                    tree.scroll(dragX, dragY);
                }
            }
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.isScrolling = false;
        return super.m_6348_(mouseX, mouseY, button);
    }

    private void renderInside(GuiGraphics guiGraphics, int mouseX, int mouseY, int offsetX, int offsetY, float partialTick) {
        PowerTab tab = this.selectedTab;
        if (tab == null) {
            guiGraphics.m_280509_(offsetX + 9, offsetY + 18, offsetX + 9 + 234, offsetY + 18 + 169, -16777216);
            int i = offsetX + 9 + 117;
            guiGraphics.m_280653_(this.f_96547_, NO_ADVANCEMENTS_LABEL, i, offsetY + 18 + 56 - 4, -1);
            guiGraphics.m_280653_(this.f_96547_, VERY_SAD_LABEL, i, offsetY + 18 + 169 - 9, -1);
        } else {
            tab.drawContents(guiGraphics, offsetX + 9, offsetY + 18, mouseX, mouseY, partialTick);
        }
    }

    public void renderWindow(GuiGraphics guiGraphics, int offsetX, int offsetY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        guiGraphics.m_280218_(WINDOW, offsetX, offsetY, 0, 0, 252, 196);
        if (this.tabs.size() > 1) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TABS);
            for (PowerTab tab : this.tabs) {
                tab.drawTab(guiGraphics, offsetX, offsetY, tab == this.selectedTab);
            }
            RenderSystem.defaultBlendFunc();
            for (PowerTab tab : this.tabs) {
                tab.drawIcon(guiGraphics, offsetX, offsetY);
            }
            RenderSystem.disableBlend();
        }
        guiGraphics.m_280614_(Objects.requireNonNull(this.f_96541_).f_91062_, TITLE, offsetX + 8, offsetY + 6, 0x404040, false);
    }

    private void renderTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY, int offsetX, int offsetY, float partialTick) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.selectedTab != null) {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_((float)(offsetX + 9), (float)(offsetY + 18), 400.0f);
            this.selectedTab.drawTooltips(guiGraphics, mouseX - offsetX - 9, mouseY - offsetY - 18, offsetX, offsetY, partialTick, this.overlayScreen != null);
            guiGraphics.m_280168_().m_85849_();
        }
        if (this.tabs.size() > 1) {
            for (PowerTab tab : this.tabs) {
                if (!tab.isMouseOver(offsetX, offsetY, mouseX, mouseY)) continue;
                guiGraphics.m_280557_(this.f_96547_, tab.getTitle(), mouseX, mouseY);
            }
        }
    }

    public void closeOverlayScreen() {
        this.overlayScreen = null;
    }

    public void openOverlayScreen(Screen screen) {
        this.closeOverlayScreen();
        this.overlayScreen = screen;
        this.overlayScreen.m_6575_(Objects.requireNonNull(this.f_96541_), this.f_96543_, this.f_96544_);
    }

    public boolean isOverOverlayScreen(double mouseX, double mouseY) {
        return this.overlayScreen != null;
    }

    public static class RotatingIconButton
    extends IconButton {
        private final Screen screen;

        public RotatingIconButton(int x, int y, Screen screen, IIcon icon, Button.OnPress onPress) {
            super(x, y, icon, onPress, f_252438_);
            this.screen = screen;
        }

        @Override
        public IIcon getIcon() {
            ArrayList icons = Lists.newArrayList();
            Minecraft mc = Minecraft.m_91087_();
            PowerManager.getPowerHandler((LivingEntity)mc.f_91074_).ifPresent(handler -> handler.getPowerHolders().values().stream().filter(holder -> !holder.getPower().isHidden() && holder.getAbilities().values().stream().anyMatch(en -> en.getProperty(Ability.HIDDEN_IN_GUI) == false)).forEach(holder -> icons.add(holder.getPower().getIcon())));
            if (icons.isEmpty()) {
                this.f_93624_ = false;
                icons.add(new ItemIcon((ItemLike)Blocks.f_50375_));
            } else {
                this.f_93624_ = !(this.screen instanceof CreativeModeInventoryScreen) || CreativeModeInventoryScreen.f_98507_ == BuiltInRegistries.f_279662_.m_6246_(CreativeModeTabs.f_257039_);
            }
            int i = Objects.requireNonNull(mc.f_91074_).f_19797_ / 20 % icons.size();
            return (IIcon)icons.get(i);
        }

        public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            Vector2i pos = RotatingIconButton.getPos(this.screen);
            if (pos != null) {
                this.m_264152_(pos.x, pos.y);
            }
            this.f_93623_ = this.f_93624_ && !PowerManager.getPowerHandler((LivingEntity)Minecraft.m_91087_().f_91074_).orElse(new PowerHandler(null)).getPowerHolders().isEmpty();
            super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        }

        public static Vector2i getPos(Screen screen) {
            if (screen instanceof InventoryScreen || screen.getClass().toString().equals("class top.theillusivec4.curios.client.gui.CuriosScreen")) {
                return new Vector2i(((AbstractContainerScreen)screen).f_97735_ + 134, screen.f_96544_ / 2 - 23);
            }
            if (screen instanceof CreativeModeInventoryScreen) {
                return new Vector2i(((AbstractContainerScreen)screen).f_97735_ + 148, screen.f_96544_ / 2 - 50);
            }
            return null;
        }
    }

    @FunctionalInterface
    public static interface RenderCallback {
        public void postRender(PowersScreen var1, GuiGraphics var2, int var3, int var4, float var5, ResourceLocation var6);
    }
}

