/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.screen.power;

import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.palladium.client.dynamictexture.TextureReference;
import net.threetag.palladium.client.screen.power.PowerTab;
import net.threetag.palladium.client.screen.power.PowerTabType;
import net.threetag.palladium.client.screen.power.PowersScreen;
import net.threetag.palladium.client.screen.power.TreeAbilityWidget;
import net.threetag.palladium.network.RequestAbilityBuyScreenMessage;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.util.context.DataContext;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class TreePowerTab
extends PowerTab {
    public static final int GRID_SIZE = 50;
    private final List<TreeAbilityWidget> entries = new ArrayList<TreeAbilityWidget>();
    private final List<Connection> connections = new ArrayList<Connection>();
    private double scrollX;
    private double scrollY;
    private int minX = Integer.MAX_VALUE;
    private int minY = Integer.MAX_VALUE;
    private int maxX = Integer.MIN_VALUE;
    private int maxY = Integer.MIN_VALUE;
    private boolean centered;

    public TreePowerTab(Minecraft minecraft, PowersScreen powersScreen, PowerTabType tabType, int tabIndex, IPowerHolder powerHolder) {
        super(minecraft, powersScreen, tabType, tabIndex, powerHolder);
        this.populate();
    }

    @Override
    public void populate() {
        this.entries.clear();
        this.connections.clear();
        LinkedList<TreeAbilityWidget> root = new LinkedList<TreeAbilityWidget>();
        for (AbilityInstance abilityInstance : this.powerHolder.getAbilities().values()) {
            if (abilityInstance.getProperty(Ability.HIDDEN_IN_GUI).booleanValue()) continue;
            TreeAbilityWidget widget = new TreeAbilityWidget(this, this.minecraft, this.powerHolder, abilityInstance).setPosition(0.0, 0.0);
            this.entries.add(widget);
            Vec2 pos = abilityInstance.getProperty(Ability.GUI_POSITION);
            if (pos == null) continue;
            widget.setPositionFixed(pos.f_82470_, pos.f_82471_);
        }
        for (TreeAbilityWidget treeAbilityWidget : this.entries) {
            treeAbilityWidget.updateRelatives(this.entries);
        }
        int y = 0;
        for (TreeAbilityWidget entry : this.entries) {
            if (!entry.parents.isEmpty()) continue;
            if (!entry.fixedPosition) {
                entry.updatePosition(0.0, y, this);
                ++y;
            }
            root.add(entry);
        }
        int n = this.longestRow();
        for (int j = 0; j < root.size(); ++j) {
            for (TreeAbilityWidget entry : root) {
                for (TreeAbilityWidget child : entry.children) {
                    if (child.fixedPosition || entry.gridX != child.gridX) continue;
                    child.setPosition(child.gridX + 1.0, this.getFreeYPos(child.gridX + 1.0, entry.gridY));
                }
            }
        }
        for (int x = 0; x < 100; ++x) {
            List<TreeAbilityWidget> entries = this.getEntriesAtX(x);
            for (int n2 = 0; n2 < entries.size(); ++n2) {
                TreeAbilityWidget entry = entries.get(n2);
                if (entry.fixedPosition) continue;
                entry.setPosition(entry.gridX, (double)n / 2.0 - (double)entries.size() / 2.0 + (double)n2);
            }
        }
        for (TreeAbilityWidget entry : this.entries) {
            this.minX = (int)Math.min((entry.gridX - 1.0) * 50.0, (double)this.minX);
            this.minY = (int)Math.min((entry.gridY - 1.0) * 50.0, (double)this.minY);
            this.maxX = (int)Math.max((entry.gridX + 1.0) * 50.0, (double)this.maxX);
            this.maxY = (int)Math.max((entry.gridY + 1.0) * 50.0, (double)this.maxY);
            for (TreeAbilityWidget child : entry.children) {
                Connection connection = new Connection();
                int startX = this.toCoord(entry.gridX);
                int startY = this.toCoord(entry.gridY, 1.0 / (double)(entry.children.size() + 1) * (double)(entry.children.indexOf(child) + 1));
                int endX = this.toCoord(child.gridX);
                int endY = this.toCoord(child.gridY, 1.0 / (double)(child.parents.size() + 1) * (double)(child.parents.indexOf(entry) + 1));
                connection.addLine(new ConnectionLine(startX, startY, endX, startY));
                connection.addLine(new ConnectionLine(endX, startY, endX, endY));
                connection.color = child.abilityInstance.isUnlocked() ? this.powerHolder.getPower().getPrimaryColor() : this.powerHolder.getPower().getSecondaryColor();
                this.connections.add(connection);
            }
        }
    }

    private int toCoord(double d) {
        return this.toCoord(d, 0.5);
    }

    private int toCoord(double d, double height) {
        return (int)((d - 0.5) * 50.0 + 17.0 + 16.0 * height);
    }

    private int longestRow() {
        int l = 0;
        for (int i = 0; i < 100; ++i) {
            int k = this.getEntriesAtX(i).size();
            l = Math.max(l, k);
        }
        return l;
    }

    public List<TreeAbilityWidget> getEntriesAtX(double x) {
        LinkedList<TreeAbilityWidget> list = new LinkedList<TreeAbilityWidget>();
        for (TreeAbilityWidget entry : this.entries) {
            if (entry.gridX != x) continue;
            list.add(entry);
        }
        return list;
    }

    public TreeAbilityWidget getEntry(double x, double y) {
        for (TreeAbilityWidget entry : this.entries) {
            if (entry.gridX != x || entry.gridY != y) continue;
            return entry;
        }
        return null;
    }

    public double getFreeYPos(double x, double y) {
        for (int i = (int)y; i < 100; ++i) {
            if (this.getEntry(x, i) != null) continue;
            return i;
        }
        return 0.0;
    }

    @Override
    public void drawContents(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY, float partialTick) {
        if (!this.centered) {
            this.scrollX = 117.0 - (double)(this.maxX + this.minX) / 2.0;
            this.scrollY = 56.0 - (double)(this.maxY + this.minY) / 2.0;
            this.centered = true;
        }
        guiGraphics.m_280588_(x, y, x + 234, y + 169);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)x, (float)y, 0.0f);
        TextureReference backgroundTexture = this.powerHolder.getPower().getBackground();
        ResourceLocation texture = backgroundTexture != null ? backgroundTexture.getTexture(DataContext.forPower((LivingEntity)this.minecraft.f_91074_, this.powerHolder)) : new ResourceLocation("textures/block/red_wool.png");
        int i = Mth.m_14107_((double)this.scrollX);
        int j = Mth.m_14107_((double)this.scrollY);
        int k = i % 16;
        int l = j % 16;
        for (int m = -1; m <= 15; ++m) {
            for (int n = -1; n <= 11; ++n) {
                guiGraphics.m_280163_(texture, k + 16 * m, l + 16 * n, 0.0f, 0.0f, 16, 16, 16, 16);
            }
        }
        for (Connection connection : this.connections) {
            connection.drawOutlines(this, guiGraphics, i, j);
        }
        for (Connection connection : this.connections) {
            connection.draw(this, guiGraphics, i, j);
        }
        for (TreeAbilityWidget widget : this.entries) {
            widget.drawIcon(this.minecraft, guiGraphics, i + widget.getX() + 16, j + widget.getY() + 13);
        }
        guiGraphics.m_280168_().m_85849_();
        guiGraphics.m_280618_();
    }

    @Override
    public void drawTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY, int width, int height, float partialTick, boolean overlayActive) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, -200.0f);
        guiGraphics.m_280509_(0, 0, 234, 169, Mth.m_14143_((float)(this.fade * 255.0f)) << 24);
        boolean flag = false;
        if (!overlayActive) {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 500.0f);
            int i = Mth.m_14107_((double)this.scrollX);
            int j = Mth.m_14107_((double)this.scrollY);
            if (mouseX > 0 && mouseX < 234 && mouseY > 0 && mouseY < 169) {
                for (TreeAbilityWidget widget : this.entries) {
                    if (!widget.isMouseOver(i, j, mouseX, mouseY)) continue;
                    flag = true;
                    widget.drawHover(guiGraphics, i, j, this.fade, width, height);
                    break;
                }
            }
            guiGraphics.m_280168_().m_85849_();
        }
        guiGraphics.m_280168_().m_85849_();
        if (!overlayActive) {
            this.fade = flag ? Mth.m_14036_((float)(this.fade + 0.02f), (float)0.0f, (float)0.3f) : Mth.m_14036_((float)(this.fade - 0.04f), (float)0.0f, (float)1.0f);
        }
    }

    public TreeAbilityWidget getAbilityHoveredOver(int mouseX, int mouseY, int x, int y) {
        int i = Mth.m_14107_((double)this.scrollX);
        int j = Mth.m_14107_((double)this.scrollY);
        if (mouseX > 0 && mouseX < 234 && mouseY > 0 && mouseY < 169) {
            for (TreeAbilityWidget entry : this.entries) {
                if (!entry.isMouseOver(i, j, mouseX, mouseY)) continue;
                return entry;
            }
        }
        return null;
    }

    @Nullable
    public static TreePowerTab create(Minecraft minecraft, PowersScreen screen, int tabIndex, IPowerHolder powerHolder) {
        PowerTabType[] tabTypes;
        for (PowerTabType tabType : tabTypes = PowerTabType.values()) {
            if (tabIndex < tabType.getMax()) {
                return new TreePowerTab(minecraft, screen, tabType, tabIndex, powerHolder);
            }
            tabIndex -= tabType.getMax();
        }
        return null;
    }

    public static boolean canBeTree(IPowerHolder holder) {
        return holder.getAbilities().values().stream().filter(entry -> entry.getProperty(Ability.HIDDEN_IN_GUI) == false).anyMatch(entry -> {
            List<AbilityInstance> parents = Ability.findParentsWithinHolder(entry.getConfiguration(), holder);
            List<AbilityInstance> children = Ability.findChildrenWithinHolder(entry.getConfiguration(), holder);
            return !parents.isEmpty() || !children.isEmpty();
        });
    }

    public void scroll(double dragX, double dragY) {
        if (this.maxX - this.minX > 234) {
            this.scrollX = Mth.m_14008_((double)(this.scrollX + dragX), (double)(-(this.maxX - 234)), (double)(-this.minX));
        }
        if (this.maxY - this.minY > 169) {
            this.scrollY = Mth.m_14008_((double)(this.scrollY + dragY), (double)(-(this.maxY - 169)), (double)(-this.minY));
        }
    }

    @Override
    public void mouseClicked(double mouseX, double mouseY, int button) {
        int i = (this.screen.f_96543_ - 252) / 2;
        int j = (this.screen.f_96544_ - 196) / 2;
        TreeAbilityWidget entry = this.getAbilityHoveredOver((int)(mouseX - (double)i - 9.0), (int)(mouseY - (double)j - 18.0), i, j);
        if (entry != null && entry.abilityInstance.getConfiguration().isBuyable()) {
            new RequestAbilityBuyScreenMessage(entry.abilityInstance.getReference()).send();
        }
    }

    public static class Connection {
        public Color color = Color.WHITE;
        public List<ConnectionLine> lines = new LinkedList<ConnectionLine>();

        public Connection(List<ConnectionLine> lines) {
            this.lines = lines;
        }

        public Connection() {
        }

        public Connection addLine(ConnectionLine line) {
            this.lines.add(line);
            return this;
        }

        public void drawOutlines(TreePowerTab gui, GuiGraphics guiGraphics, int x, int y) {
            for (ConnectionLine lines : this.lines) {
                lines.draw(gui, guiGraphics, x, y, true, Color.BLACK);
            }
        }

        public void draw(TreePowerTab gui, GuiGraphics guiGraphics, int x, int y) {
            for (ConnectionLine lines : this.lines) {
                lines.draw(gui, guiGraphics, x, y, false, this.color);
            }
        }
    }

    public static class ConnectionLine {
        public int startX;
        public int startY;
        public int endX;
        public int endY;

        public ConnectionLine(int startX, int startY, int endX, int endY) {
            this.startX = Math.min(startX, endX);
            this.startY = Math.min(startY, endY);
            this.endX = Math.max(startX, endX);
            this.endY = Math.max(startY, endY);
        }

        public void draw(TreePowerTab gui, GuiGraphics guiGraphics, int x, int y, boolean outline, Color color) {
            int colorCode = color.getRGB();
            if (outline) {
                if (this.startY == this.endY) {
                    guiGraphics.m_280656_(x + this.startX - 2, x + this.endX + 1, y + this.startY - 2, colorCode);
                    guiGraphics.m_280656_(x + this.startX - 2, x + this.endX + 1, y + this.startY + 1, colorCode);
                } else if (this.startX == this.endX) {
                    guiGraphics.m_280315_(x + this.startX - 2, y + this.startY - 2, y + this.endY + 1, colorCode);
                    guiGraphics.m_280315_(x + this.startX + 1, y + this.startY - 2, y + this.endY + 1, colorCode);
                }
            } else if (this.startY == this.endY) {
                guiGraphics.m_280656_(x + this.startX - 1, x + this.endX, y + this.startY - 1, colorCode);
                guiGraphics.m_280656_(x + this.startX - 1, x + this.endX, y + this.startY, colorCode);
            } else if (this.startX == this.endX) {
                guiGraphics.m_280315_(x + this.startX - 1, y + this.startY - 1, y + this.endY, colorCode);
                guiGraphics.m_280315_(x + this.startX, y + this.startY - 1, y + this.endY, colorCode);
            }
        }
    }
}

