/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.command;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.threetag.palladium.command.SuperpowerCommand;
import net.threetag.palladium.condition.BuyableCondition;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.Power;
import net.threetag.palladium.power.PowerHandler;
import net.threetag.palladium.power.PowerManager;
import net.threetag.palladium.power.ability.AbilityConfiguration;
import net.threetag.palladium.power.ability.AbilityInstance;

public class AbilityCommand {
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_OWN_POWERS = (context, builder) -> {
        Collection<Object> entities;
        ArrayList powers = Lists.newArrayList();
        try {
            context.getArgument("entities", EntitySelector.class);
            entities = EntityArgument.m_91461_((CommandContext)context, (String)"entities");
        }
        catch (Exception e) {
            entities = Collections.singleton(((CommandSourceStack)context.getSource()).m_81375_());
        }
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            PowerHandler manager = PowerManager.getPowerHandler(living).orElse(new PowerHandler(living));
            block3: for (IPowerHolder holder : manager.getPowerHolders().values()) {
                for (AbilityInstance entry : holder.getAbilities().values()) {
                    if (!entry.getConfiguration().isBuyable()) continue;
                    if (powers.contains(holder.getPower().getId())) continue block3;
                    powers.add(holder.getPower().getId());
                    continue block3;
                }
            }
        }
        return SharedSuggestionProvider.m_82926_((Iterable)powers, (SuggestionsBuilder)builder);
    };
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_ABILITIES = (context, builder) -> {
        ArrayList abilities = Lists.newArrayList();
        Power power = null;
        try {
            context.getArgument("power", ResourceLocation.class);
            power = SuperpowerCommand.getSuperpower((CommandContext<CommandSourceStack>)context, "power");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (power != null) {
            for (AbilityConfiguration ability : power.getAbilities()) {
                if (!ability.isBuyable()) continue;
                abilities.add(ability.getId());
            }
        }
        return SharedSuggestionProvider.m_82970_((Iterable)abilities, (SuggestionsBuilder)builder);
    };

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ability").requires(player -> player.m_6761_(2))).then(Commands.m_82127_((String)"lock").then(Commands.m_82129_((String)"entities", (ArgumentType)EntityArgument.m_91460_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"power", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_OWN_POWERS).then(Commands.m_82129_((String)"ability", (ArgumentType)StringArgumentType.word()).suggests(SUGGEST_ABILITIES).executes(context -> AbilityCommand.lockAbility((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"entities"), SuperpowerCommand.getSuperpower((CommandContext<CommandSourceStack>)context, "power"), StringArgumentType.getString((CommandContext)context, (String)"ability"), true)))).then(Commands.m_82127_((String)"all").executes(context -> AbilityCommand.lockAllAbilities((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"entities"), SuperpowerCommand.getSuperpower((CommandContext<CommandSourceStack>)context, "power"), true))))))).then(Commands.m_82127_((String)"unlock").then(Commands.m_82129_((String)"entities", (ArgumentType)EntityArgument.m_91460_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"power", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_OWN_POWERS).then(Commands.m_82129_((String)"ability", (ArgumentType)StringArgumentType.word()).suggests(SUGGEST_ABILITIES).executes(context -> AbilityCommand.lockAbility((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"entities"), SuperpowerCommand.getSuperpower((CommandContext<CommandSourceStack>)context, "power"), StringArgumentType.getString((CommandContext)context, (String)"ability"), false)))).then(Commands.m_82127_((String)"all").executes(context -> AbilityCommand.lockAllAbilities((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"entities"), SuperpowerCommand.getSuperpower((CommandContext<CommandSourceStack>)context, "power"), false)))))));
    }

    public static int lockAbility(CommandSourceStack source, Collection<? extends Entity> entities, Power power, String abilityKey, boolean locking) {
        AbilityConfiguration configuration = power.getAbilities().stream().filter(c -> c.getId().equals(abilityKey)).findFirst().orElse(null);
        if (configuration == null || !configuration.isBuyable()) {
            source.m_81352_((Component)Component.m_237110_((String)"commands.ability.error.notUnlockable", (Object[])new Object[]{abilityKey, power.getId()}));
            return 0;
        }
        int i = 0;
        for (Entity entity : entities) {
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                IPowerHolder holder = PowerManager.getPowerHandler(living).orElse(new PowerHandler(living)).getPowerHolder(power);
                if (holder != null) {
                    AbilityInstance ability = holder.getAbilities().get(abilityKey);
                    if (ability == null) continue;
                    ability.setUniqueProperty(BuyableCondition.BOUGHT, !locking);
                    ++i;
                    continue;
                }
                source.m_81352_((Component)Component.m_237115_((String)"commands.ability.error.doesntHavePower"));
                continue;
            }
            source.m_81352_((Component)Component.m_237115_((String)"commands.superpower.error.noLivingEntity"));
        }
        int finalI = i;
        source.m_288197_(() -> Component.m_237110_((String)("commands.ability." + (locking ? "locking" : "unlocking") + ".success"), (Object[])new Object[]{abilityKey, power.getId(), finalI}), true);
        return i;
    }

    public static int lockAllAbilities(CommandSourceStack source, Collection<? extends Entity> entities, Power power, boolean locking) {
        int i = 0;
        for (Entity entity : entities) {
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                IPowerHolder holder = PowerManager.getPowerHandler(living).orElse(new PowerHandler(living)).getPowerHolder(power);
                if (holder != null) {
                    for (AbilityInstance abilityInstance : holder.getAbilities().values()) {
                        if (!abilityInstance.getPropertyManager().isRegistered(BuyableCondition.BOUGHT)) continue;
                        abilityInstance.setUniqueProperty(BuyableCondition.BOUGHT, !locking);
                        ++i;
                    }
                    continue;
                }
                source.m_81352_((Component)Component.m_237115_((String)"commands.ability.error.doesntHavePower"));
                continue;
            }
            source.m_81352_((Component)Component.m_237115_((String)"commands.superpower.error.noLivingEntity"));
        }
        int finalI = i;
        source.m_288197_(() -> Component.m_237110_((String)("commands.ability." + (locking ? "locking" : "unlocking") + ".all.success"), (Object[])new Object[]{finalI, power.getId(), entities.size()}), true);
        return i;
    }
}

