/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.command;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.threetag.palladium.command.SuperpowerCommand;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.Power;
import net.threetag.palladium.power.PowerHandler;
import net.threetag.palladium.power.PowerManager;
import net.threetag.palladium.power.energybar.EnergyBar;
import net.threetag.palladium.power.energybar.EnergyBarConfiguration;
import net.threetag.palladium.power.energybar.EnergyBarReference;

public class EnergyBarCommand {
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_OWN_POWERS = (context, builder) -> {
        ServerPlayer entity;
        ArrayList powers = Lists.newArrayList();
        try {
            context.getArgument("entity", EntitySelector.class);
            entity = EntityArgument.m_91452_((CommandContext)context, (String)"entity");
        }
        catch (Exception e) {
            entity = ((CommandSourceStack)context.getSource()).m_81375_();
        }
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            PowerHandler manager = PowerManager.getPowerHandler(living).orElse(new PowerHandler(living));
            for (IPowerHolder holder : manager.getPowerHolders().values()) {
                if (holder.getEnergyBars().isEmpty()) continue;
                powers.add(holder.getPower().getId());
            }
        }
        return SharedSuggestionProvider.m_82926_((Iterable)powers, (SuggestionsBuilder)builder);
    };
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_ENERGY_BAR = (context, builder) -> {
        ArrayList energyBars = Lists.newArrayList();
        Power power = null;
        try {
            context.getArgument("power", ResourceLocation.class);
            power = SuperpowerCommand.getSuperpower((CommandContext<CommandSourceStack>)context, "power");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (power != null) {
            for (EnergyBarConfiguration energyBar : power.getEnergyBars()) {
                energyBars.add(energyBar.getName());
            }
        }
        return SharedSuggestionProvider.m_82970_((Iterable)energyBars, (SuggestionsBuilder)builder);
    };

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"energybar").requires(player -> player.m_6761_(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"value").then(Commands.m_82127_((String)"get").then(Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82129_((String)"power", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_OWN_POWERS).then(Commands.m_82129_((String)"energybar", (ArgumentType)StringArgumentType.word()).suggests(SUGGEST_ENERGY_BAR).executes(context -> EnergyBarCommand.getEnergyBarValue((CommandSourceStack)context.getSource(), EntityArgument.m_91452_((CommandContext)context, (String)"entity"), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"power"), StringArgumentType.getString((CommandContext)context, (String)"energybar")))))))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82129_((String)"power", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_OWN_POWERS).then(Commands.m_82129_((String)"energybar", (ArgumentType)StringArgumentType.word()).suggests(SUGGEST_ENERGY_BAR).then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> EnergyBarCommand.setEnergyBarValue((CommandSourceStack)context.getSource(), EntityArgument.m_91452_((CommandContext)context, (String)"entity"), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"power"), StringArgumentType.getString((CommandContext)context, (String)"energybar"), IntegerArgumentType.getInteger((CommandContext)context, (String)"value"))))))))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82129_((String)"power", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_OWN_POWERS).then(Commands.m_82129_((String)"energybar", (ArgumentType)StringArgumentType.word()).suggests(SUGGEST_ENERGY_BAR).then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(context -> EnergyBarCommand.addEnergyBarValue((CommandSourceStack)context.getSource(), EntityArgument.m_91452_((CommandContext)context, (String)"entity"), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"power"), StringArgumentType.getString((CommandContext)context, (String)"energybar"), IntegerArgumentType.getInteger((CommandContext)context, (String)"value"))))))))).then(Commands.m_82127_((String)"subtract").then(Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82129_((String)"power", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_OWN_POWERS).then(Commands.m_82129_((String)"energybar", (ArgumentType)StringArgumentType.word()).suggests(SUGGEST_ENERGY_BAR).then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(context -> EnergyBarCommand.addEnergyBarValue((CommandSourceStack)context.getSource(), EntityArgument.m_91452_((CommandContext)context, (String)"entity"), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"power"), StringArgumentType.getString((CommandContext)context, (String)"energybar"), -IntegerArgumentType.getInteger((CommandContext)context, (String)"value")))))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"max").then(Commands.m_82127_((String)"get").then(Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82129_((String)"power", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_OWN_POWERS).then(Commands.m_82129_((String)"energybar", (ArgumentType)StringArgumentType.word()).suggests(SUGGEST_ENERGY_BAR).executes(context -> EnergyBarCommand.getEnergyBarMaxValue((CommandSourceStack)context.getSource(), EntityArgument.m_91452_((CommandContext)context, (String)"entity"), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"power"), StringArgumentType.getString((CommandContext)context, (String)"energybar")))))))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82129_((String)"power", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_OWN_POWERS).then(Commands.m_82129_((String)"energybar", (ArgumentType)StringArgumentType.word()).suggests(SUGGEST_ENERGY_BAR).then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> EnergyBarCommand.setEnergyBarMaxValue((CommandSourceStack)context.getSource(), EntityArgument.m_91452_((CommandContext)context, (String)"entity"), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"power"), StringArgumentType.getString((CommandContext)context, (String)"energybar"), IntegerArgumentType.getInteger((CommandContext)context, (String)"value"))))))))).then(Commands.m_82127_((String)"reset").then(Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82129_((String)"power", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_OWN_POWERS).then(Commands.m_82129_((String)"energybar", (ArgumentType)StringArgumentType.word()).suggests(SUGGEST_ENERGY_BAR).executes(context -> EnergyBarCommand.resetEnergyBarMaxValue((CommandSourceStack)context.getSource(), EntityArgument.m_91452_((CommandContext)context, (String)"entity"), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"power"), StringArgumentType.getString((CommandContext)context, (String)"energybar")))))))));
    }

    public static int getEnergyBarValue(CommandSourceStack source, Entity entity, ResourceLocation powerId, String energyBarName) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            EnergyBar bar = new EnergyBarReference(powerId, energyBarName).getEntry(living);
            if (bar != null) {
                source.m_288197_(() -> Component.m_237110_((String)"commands.energybar.value.get.success", (Object[])new Object[]{entity.m_5446_(), powerId.toString(), energyBarName, bar.get()}), true);
                return bar.get();
            }
            source.m_81352_((Component)Component.m_237115_((String)"commands.energybar.error.energyBarNotFound"));
            return 0;
        }
        source.m_81352_((Component)Component.m_237115_((String)"commands.energybar.error.noLivingEntity"));
        return 0;
    }

    public static int setEnergyBarValue(CommandSourceStack source, Entity entity, ResourceLocation powerId, String energyBarName, int value) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            EnergyBar bar = new EnergyBarReference(powerId, energyBarName).getEntry(living);
            if (bar != null) {
                bar.set(value);
                source.m_288197_(() -> Component.m_237110_((String)"commands.energybar.value.set.success", (Object[])new Object[]{entity.m_5446_(), powerId.toString(), energyBarName, bar.get()}), true);
                return 1;
            }
            source.m_81352_((Component)Component.m_237115_((String)"commands.energybar.error.energyBarNotFound"));
            return 0;
        }
        source.m_81352_((Component)Component.m_237115_((String)"commands.energybar.error.noLivingEntity"));
        return 0;
    }

    public static int addEnergyBarValue(CommandSourceStack source, Entity entity, ResourceLocation powerId, String energyBarName, int value) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            EnergyBar bar = new EnergyBarReference(powerId, energyBarName).getEntry(living);
            if (bar != null) {
                bar.add(value);
                source.m_288197_(() -> Component.m_237110_((String)"commands.energybar.value.set.success", (Object[])new Object[]{entity.m_5446_(), powerId.toString(), energyBarName, bar.get()}), true);
                return 1;
            }
            source.m_81352_((Component)Component.m_237115_((String)"commands.energybar.error.energyBarNotFound"));
            return 0;
        }
        source.m_81352_((Component)Component.m_237115_((String)"commands.energybar.error.noLivingEntity"));
        return 0;
    }

    public static int getEnergyBarMaxValue(CommandSourceStack source, Entity entity, ResourceLocation powerId, String energyBarName) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            EnergyBar bar = new EnergyBarReference(powerId, energyBarName).getEntry(living);
            if (bar != null) {
                source.m_288197_(() -> Component.m_237110_((String)"commands.energybar.maxValue.get.success", (Object[])new Object[]{entity.m_5446_(), powerId.toString(), energyBarName, bar.getMax()}), true);
                return bar.getMax();
            }
            source.m_81352_((Component)Component.m_237115_((String)"commands.energybar.error.energyBarNotFound"));
            return 0;
        }
        source.m_81352_((Component)Component.m_237115_((String)"commands.energybar.error.noLivingEntity"));
        return 0;
    }

    public static int setEnergyBarMaxValue(CommandSourceStack source, Entity entity, ResourceLocation powerId, String energyBarName, int value) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            EnergyBar bar = new EnergyBarReference(powerId, energyBarName).getEntry(living);
            if (bar != null) {
                bar.setOverriddenMaxValue(value);
                source.m_288197_(() -> Component.m_237110_((String)"commands.energybar.maxValue.set.success", (Object[])new Object[]{entity.m_5446_(), powerId.toString(), energyBarName, bar.getMax()}), true);
                return 1;
            }
            source.m_81352_((Component)Component.m_237115_((String)"commands.energybar.error.energyBarNotFound"));
            return 0;
        }
        source.m_81352_((Component)Component.m_237115_((String)"commands.energybar.error.noLivingEntity"));
        return 0;
    }

    public static int resetEnergyBarMaxValue(CommandSourceStack source, Entity entity, ResourceLocation powerId, String energyBarName) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            EnergyBar bar = new EnergyBarReference(powerId, energyBarName).getEntry(living);
            if (bar != null) {
                bar.setOverriddenMaxValue(-1);
                source.m_288197_(() -> Component.m_237110_((String)"commands.energybar.maxValue.reset.success", (Object[])new Object[]{entity.m_5446_(), powerId.toString(), energyBarName, bar.getMax()}), true);
                return 1;
            }
            source.m_81352_((Component)Component.m_237115_((String)"commands.energybar.error.energyBarNotFound"));
            return 0;
        }
        source.m_81352_((Component)Component.m_237115_((String)"commands.energybar.error.noLivingEntity"));
        return 0;
    }
}

