/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.compat.curios.forge;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.threetag.palladium.power.IPowerHandler;
import net.threetag.palladium.power.IPowerValidator;
import net.threetag.palladium.power.ItemPowerManager;
import net.threetag.palladium.power.Power;
import net.threetag.palladium.power.PowerCollector;
import net.threetag.palladium.power.provider.PowerProvider;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.ISlotType;

public class CuriosPowerProvider
extends PowerProvider {
    @Override
    public void providePowers(LivingEntity entity, IPowerHandler handler, PowerCollector collector) {
        CuriosApi.getCuriosHelper().getCuriosHandler(entity).ifPresent(curios -> {
            for (ISlotType slotType : CuriosApi.getSlotHelper().getSlotTypes(entity)) {
                curios.getStacksHandler(slotType.getIdentifier()).ifPresent(stacks -> {
                    for (int i = 0; i < stacks.getStacks().getSlots(); ++i) {
                        List<Power> powers;
                        ItemStack stack = stacks.getStacks().getStackInSlot(i);
                        if (stack.m_41619_() || (powers = ItemPowerManager.getInstance().getPowerForItem("curios:" + slotType.getIdentifier(), stack.m_41720_())) == null) continue;
                        for (Power power : powers) {
                            collector.addPower(power, () -> new Validator(stack.m_41720_(), slotType.getIdentifier()));
                        }
                    }
                });
            }
        });
    }

    public record Validator(Item item, String slot) implements IPowerValidator
    {
        @Override
        public boolean stillValid(LivingEntity entity, Power power) {
            AtomicBoolean available = new AtomicBoolean(false);
            CuriosApi.getCuriosHelper().getCuriosHandler(entity).ifPresent(curios -> curios.getStacksHandler(this.slot).ifPresent(stacks -> {
                for (int i = 0; i < stacks.getStacks().getSlots(); ++i) {
                    ItemStack stack = stacks.getStacks().getStackInSlot(i);
                    if (!stack.m_150930_(this.item)) continue;
                    available.set(true);
                }
            }));
            return available.get();
        }
    }
}

