/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.compat.geckolib.renderlayer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.threetag.palladium.client.renderer.renderlayer.IPackRenderLayer;
import net.threetag.palladium.compat.geckolib.renderlayer.GeckoLayerState;
import net.threetag.palladium.compat.geckolib.renderlayer.GeckoRenderLayer;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.texture.AnimatableTexture;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.molang.MolangParser;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.util.RenderUtils;

public class GeckoRenderLayerModel
extends HumanoidModel<AbstractClientPlayer>
implements GeoRenderer<GeckoLayerState> {
    protected final GeoModel<GeckoLayerState> modelProvider;
    protected HumanoidModel<?> baseModel;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;
    protected Entity currentEntity = null;
    protected GeckoLayerState currentState = null;
    protected Matrix4f entityRenderTranslations = new Matrix4f();
    public String headBone = "armorHead";
    public String bodyBone = "armorBody";
    public String rightArmBone = "armorRightArm";
    public String leftArmBone = "armorLeftArm";
    public String rightLegBone = "armorRightLeg";
    public String leftLegBone = "armorLeftLeg";
    protected BakedGeoModel lastModel = null;
    protected GeoBone head = null;
    protected GeoBone body = null;
    protected GeoBone rightArm = null;
    protected GeoBone leftArm = null;
    protected GeoBone rightLeg = null;
    protected GeoBone leftLeg = null;

    public GeckoRenderLayerModel(final GeckoRenderLayer renderLayer) {
        super(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171164_));
        this.modelProvider = new GeoModel<GeckoLayerState>(){

            public ResourceLocation getModelResource(GeckoLayerState animatable) {
                return renderLayer.cachedModel;
            }

            public ResourceLocation getTextureResource(GeckoLayerState animatable) {
                return renderLayer.cachedTexture;
            }

            public ResourceLocation getAnimationResource(GeckoLayerState animatable) {
                return renderLayer.animationLocation;
            }

            public void applyMolangQueries(GeckoLayerState animatable, double animTime) {
                MolangParser parser = MolangParser.INSTANCE;
                Minecraft mc = Minecraft.m_91087_();
                parser.setMemoizedValue("query.life_time", () -> animTime / 20.0);
                parser.setMemoizedValue("query.actor_count", () -> ((ClientLevel)mc.f_91073_).m_104813_());
                parser.setMemoizedValue("query.time_of_day", () -> (float)mc.f_91073_.m_46468_() / 24000.0f);
                parser.setMemoizedValue("query.moon_phase", () -> ((ClientLevel)mc.f_91073_).m_46941_());
                if (animatable.layer.getModel().currentEntity != null) {
                    Entity entity = animatable.layer.getModel().currentEntity;
                    parser.setMemoizedValue("query.distance_from_camera", () -> mc.f_91063_.m_109153_().m_90583_().m_82554_(entity.m_20182_()));
                    parser.setMemoizedValue("query.is_on_ground", () -> RenderUtils.booleanToFloat((boolean)entity.m_20096_()));
                    parser.setMemoizedValue("query.is_in_water", () -> RenderUtils.booleanToFloat((boolean)entity.m_20069_()));
                    parser.setMemoizedValue("query.is_in_water_or_rain", () -> RenderUtils.booleanToFloat((boolean)entity.m_20071_()));
                    if (entity instanceof LivingEntity) {
                        LivingEntity livingEntity = (LivingEntity)entity;
                        parser.setMemoizedValue("query.health", () -> ((LivingEntity)livingEntity).m_21223_());
                        parser.setMemoizedValue("query.max_health", () -> ((LivingEntity)livingEntity).m_21233_());
                        parser.setMemoizedValue("query.is_on_fire", () -> RenderUtils.booleanToFloat((boolean)livingEntity.m_6060_()));
                        parser.setMemoizedValue("query.ground_speed", () -> {
                            Vec3 velocity = livingEntity.m_20184_();
                            return Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)));
                        });
                        parser.setMemoizedValue("query.yaw_speed", () -> livingEntity.m_5675_((float)animTime - livingEntity.m_5675_((float)animTime - 0.1f)));
                    }
                }
            }
        };
    }

    public long getInstanceId(GeckoLayerState animatable) {
        return super.getInstanceId((GeoAnimatable)animatable) + (long)this.currentEntity.m_19879_();
    }

    public void setCurrentRenderingFields(GeckoLayerState state, Entity entity, HumanoidModel<?> baseModel) {
        this.currentState = state;
        this.baseModel = baseModel;
        this.currentEntity = entity;
    }

    public void preRender(PoseStack poseStack, GeckoLayerState animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.entityRenderTranslations = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
        this.applyBaseModel(this.baseModel);
        this.grabRelevantBones(this.getGeoModel().getBakedModel(this.getGeoModel().getModelResource((GeoAnimatable)this.currentState)));
        this.applyBaseTransformations(this.baseModel);
        this.scaleModelForRender(this.scaleWidth, this.scaleHeight, poseStack, animatable, model, isReRender, partialTick, packedLight, packedOverlay);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        Minecraft mc = Minecraft.m_91087_();
        MultiBufferSource.BufferSource bufferSource = mc.f_91060_.f_109464_.m_110104_();
        if (mc.f_91060_.m_109817_() && mc.m_91314_(this.currentEntity)) {
            bufferSource = mc.f_91060_.f_109464_.m_110109_();
        }
        float partialTick = mc.m_91296_();
        buffer = this.currentState.layer.renderType.createVertexConsumer((MultiBufferSource)bufferSource, this.getTextureLocation(this.currentState), false);
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 1.5f, 0.0f);
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        AnimationState animationState = new AnimationState((GeoAnimatable)this.currentState, 0.0f, 0.0f, partialTick, false);
        long instanceId = this.getInstanceId(this.currentState);
        animationState.setData(DataTickets.TICK, (Object)this.currentState.getTick(this.currentEntity));
        animationState.setData(DataTickets.ENTITY, (Object)this.currentEntity);
        this.modelProvider.addAdditionalStateData((GeoAnimatable)this.currentState, instanceId, (arg_0, arg_1) -> ((AnimationState)animationState).setData(arg_0, arg_1));
        this.modelProvider.handleAnimations((GeoAnimatable)this.currentState, instanceId, animationState);
        this.defaultRender(poseStack, this.currentState, (MultiBufferSource)bufferSource, null, buffer, 0.0f, partialTick, this.currentState.layer.renderType.getPackedLight(packedLight));
        poseStack.m_85849_();
    }

    protected void grabRelevantBones(BakedGeoModel bakedModel) {
        if (this.lastModel == bakedModel) {
            return;
        }
        this.lastModel = bakedModel;
        this.head = this.getHeadBone();
        this.body = this.getBodyBone();
        this.rightArm = this.getRightArmBone();
        this.leftArm = this.getLeftArmBone();
        this.rightLeg = this.getRightLegBone();
        this.leftLeg = this.getLeftLegBone();
    }

    protected void applyBaseModel(HumanoidModel<?> baseModel) {
        this.f_102610_ = baseModel.f_102610_;
        this.f_102817_ = baseModel.f_102817_;
        this.f_102609_ = baseModel.f_102609_;
        this.f_102816_ = baseModel.f_102816_;
        this.f_102815_ = baseModel.f_102815_;
    }

    @Nullable
    public GeoBone getHeadBone() {
        return this.modelProvider.getBone(this.headBone).orElse(null);
    }

    @Nullable
    public GeoBone getBodyBone() {
        return this.modelProvider.getBone(this.bodyBone).orElse(null);
    }

    @Nullable
    public GeoBone getRightArmBone() {
        return this.modelProvider.getBone(this.rightArmBone).orElse(null);
    }

    @Nullable
    public GeoBone getLeftArmBone() {
        return this.modelProvider.getBone(this.leftArmBone).orElse(null);
    }

    @Nullable
    public GeoBone getRightLegBone() {
        return this.modelProvider.getBone(this.rightLegBone).orElse(null);
    }

    @Nullable
    public GeoBone getLeftLegBone() {
        return this.modelProvider.getBone(this.leftLegBone).orElse(null);
    }

    protected void applyBaseTransformations(HumanoidModel<?> baseModel) {
        IPackRenderLayer.copyModelProperties(this.currentEntity, baseModel, this);
        if (this.head != null) {
            ModelPart headPart = this.f_102808_;
            RenderUtils.matchModelPartRot((ModelPart)headPart, (CoreGeoBone)this.head);
            GeckoRenderLayerModel.copyScaleAndVisibility(headPart, (CoreGeoBone)this.head);
            this.head.updatePosition(headPart.f_104200_, -headPart.f_104201_, headPart.f_104202_);
        }
        if (this.body != null) {
            ModelPart bodyPart = this.f_102810_;
            RenderUtils.matchModelPartRot((ModelPart)bodyPart, (CoreGeoBone)this.body);
            GeckoRenderLayerModel.copyScaleAndVisibility(bodyPart, (CoreGeoBone)this.body);
            this.body.updatePosition(bodyPart.f_104200_, -bodyPart.f_104201_, bodyPart.f_104202_);
        }
        if (this.rightArm != null) {
            ModelPart rightArmPart = this.f_102811_;
            RenderUtils.matchModelPartRot((ModelPart)rightArmPart, (CoreGeoBone)this.rightArm);
            GeckoRenderLayerModel.copyScaleAndVisibility(rightArmPart, (CoreGeoBone)this.rightArm);
            this.rightArm.updatePosition(rightArmPart.f_104200_ + 5.0f, 2.0f - rightArmPart.f_104201_, rightArmPart.f_104202_);
        }
        if (this.leftArm != null) {
            ModelPart leftArmPart = this.f_102812_;
            RenderUtils.matchModelPartRot((ModelPart)leftArmPart, (CoreGeoBone)this.leftArm);
            GeckoRenderLayerModel.copyScaleAndVisibility(leftArmPart, (CoreGeoBone)this.leftArm);
            this.leftArm.updatePosition(leftArmPart.f_104200_ - 5.0f, 2.0f - leftArmPart.f_104201_, leftArmPart.f_104202_);
        }
        if (this.rightLeg != null) {
            ModelPart rightLegPart = this.f_102813_;
            RenderUtils.matchModelPartRot((ModelPart)rightLegPart, (CoreGeoBone)this.rightLeg);
            GeckoRenderLayerModel.copyScaleAndVisibility(rightLegPart, (CoreGeoBone)this.rightLeg);
            this.rightLeg.updatePosition(rightLegPart.f_104200_ + 2.0f, 12.0f - rightLegPart.f_104201_, rightLegPart.f_104202_);
        }
        if (this.leftLeg != null) {
            ModelPart leftLegPart = this.f_102814_;
            RenderUtils.matchModelPartRot((ModelPart)leftLegPart, (CoreGeoBone)this.leftLeg);
            GeckoRenderLayerModel.copyScaleAndVisibility(leftLegPart, (CoreGeoBone)this.leftLeg);
            this.leftLeg.updatePosition(leftLegPart.f_104200_ - 2.0f, 12.0f - leftLegPart.f_104201_, leftLegPart.f_104202_);
        }
    }

    public static void copyScaleAndVisibility(ModelPart from, CoreGeoBone to) {
        to.setScaleX(from.f_233553_);
        to.setScaleY(from.f_233554_);
        to.setScaleZ(from.f_233555_);
        to.setHidden(!from.f_104207_);
    }

    public GeoModel<GeckoLayerState> getGeoModel() {
        return this.modelProvider;
    }

    public GeckoLayerState getAnimatable() {
        return this.currentState;
    }

    public void fireCompileRenderLayersEvent() {
    }

    public boolean firePreRenderEvent(PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource, float partialTick, int packedLight) {
        return true;
    }

    public void firePostRenderEvent(PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource, float partialTick, int packedLight) {
    }

    public void updateAnimatedTextureFrame(GeckoLayerState animatable) {
        if (this.currentEntity != null) {
            AnimatableTexture.setAndUpdate((ResourceLocation)this.getTextureLocation(animatable), (int)(this.currentEntity.m_19879_() + this.currentEntity.f_19797_));
        }
    }
}

