/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.compat.kubejs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.threetag.palladium.power.Power;
import net.threetag.palladium.power.PowerHandler;
import net.threetag.palladium.power.PowerManager;
import net.threetag.palladium.util.property.PalladiumProperties;

public class PowerHandlerJS {
    private final Player parent;

    public PowerHandlerJS(Player parent) {
        this.parent = parent;
    }

    public Collection<ResourceLocation> getPowers() {
        Optional<PowerHandler> handler = PowerManager.getPowerHandler((LivingEntity)this.parent);
        return handler.isPresent() ? handler.get().getPowerHolders().keySet() : Collections.emptyList();
    }

    public boolean setSuperpower(ResourceLocation id) {
        Power power = PowerManager.getInstance(Objects.requireNonNull(this.parent).m_9236_()).getPower(id);
        if (power != null) {
            PalladiumProperties.SUPERPOWER_IDS.set((Entity)this.parent, Collections.singletonList(id));
            return true;
        }
        return false;
    }

    public boolean addSuperpower(ResourceLocation id) {
        Power power = PowerManager.getInstance(Objects.requireNonNull(this.parent).m_9236_()).getPower(id);
        if (power != null && !PalladiumProperties.SUPERPOWER_IDS.get((Entity)this.parent).contains(id)) {
            ArrayList<ResourceLocation> powerIds = new ArrayList<ResourceLocation>((Collection)PalladiumProperties.SUPERPOWER_IDS.get((Entity)this.parent));
            powerIds.add(id);
            PalladiumProperties.SUPERPOWER_IDS.set((Entity)this.parent, powerIds);
            return true;
        }
        return false;
    }

    public boolean removeSuperpower(ResourceLocation id) {
        Power power = PowerManager.getInstance(Objects.requireNonNull(this.parent).m_9236_()).getPower(id);
        if (power != null && PalladiumProperties.SUPERPOWER_IDS.get((Entity)this.parent).contains(id)) {
            ArrayList powerIds = new ArrayList(PalladiumProperties.SUPERPOWER_IDS.get((Entity)this.parent));
            powerIds.remove(id);
            PalladiumProperties.SUPERPOWER_IDS.set((Entity)this.parent, powerIds);
            return true;
        }
        return false;
    }

    public List<ResourceLocation> getSuperpower() {
        return PalladiumProperties.SUPERPOWER_IDS.get((Entity)this.parent);
    }
}

