/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.compat.kubejs.ability;

import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import net.threetag.palladium.compat.kubejs.PalladiumKubeJSPlugin;
import net.threetag.palladium.compat.kubejs.ability.ScriptableAbility;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.util.icon.IIcon;
import net.threetag.palladium.util.icon.ItemIcon;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.PalladiumPropertyLookup;

public class AbilityBuilder
extends BuilderBase<Ability> {
    public transient IIcon icon = new ItemIcon((ItemLike)Items.f_42127_);
    public transient TickFunction firstTick = null;
    public transient TickFunction tick = null;
    public transient TickFunction lastTick = null;
    public transient List<DeserializePropertyInfo> extraProperties = new ArrayList<DeserializePropertyInfo>();
    public transient List<DeserializePropertyInfo> uniqueProperties = new ArrayList<DeserializePropertyInfo>();
    public transient String documentationDescription = null;

    public AbilityBuilder(ResourceLocation id) {
        super(id);
    }

    public RegistryInfo<Ability> getRegistryType() {
        return PalladiumKubeJSPlugin.ABILITY;
    }

    public Ability createObject() {
        return new ScriptableAbility(this);
    }

    public AbilityBuilder icon(IIcon icon) {
        this.icon = icon;
        return this;
    }

    public AbilityBuilder documentationDescription(String documentationDescription) {
        this.documentationDescription = documentationDescription;
        return this;
    }

    public AbilityBuilder addProperty(String key, String type, Object defaultValue, String configureDesc) {
        PalladiumProperty<?> property = PalladiumPropertyLookup.get(type, key);
        if (property != null) {
            this.extraProperties.add(new DeserializePropertyInfo(key, type, defaultValue, configureDesc));
        } else {
            AddonPackLog.error("Failed to register ability property \"%s\", type \"%s\" is not supported", key, type);
        }
        return this;
    }

    public AbilityBuilder addUniqueProperty(String key, String type, Object defaultValue) {
        PalladiumProperty<?> property = PalladiumPropertyLookup.get(type, key);
        if (property != null) {
            this.uniqueProperties.add(new DeserializePropertyInfo(key, type, defaultValue, null));
        } else {
            AddonPackLog.error("Failed to register ability unique property \"%s\", type \"%s\" is not supported", key, type);
        }
        return this;
    }

    public AbilityBuilder firstTick(TickFunction firstTick) {
        this.firstTick = firstTick;
        return this;
    }

    public AbilityBuilder tick(TickFunction tick) {
        this.tick = tick;
        return this;
    }

    public AbilityBuilder lastTick(TickFunction lastTick) {
        this.lastTick = lastTick;
        return this;
    }

    @FunctionalInterface
    public static interface TickFunction {
        public void tick(LivingEntity var1, AbilityInstance var2, IPowerHolder var3, boolean var4);
    }

    public static class DeserializePropertyInfo {
        public String key;
        public String type;
        public Object defaultValue;
        public String configureDesc;

        public DeserializePropertyInfo(String key, String type, Object defaultValue, String configureDesc) {
            this.key = key;
            this.type = type;
            this.defaultValue = defaultValue;
            this.configureDesc = configureDesc;
        }
    }
}

