/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.condition;

import com.google.gson.JsonObject;
import net.minecraft.world.entity.LivingEntity;
import net.threetag.palladium.condition.AbilityEnabledCondition;
import net.threetag.palladium.condition.Condition;
import net.threetag.palladium.condition.ConditionSerializer;
import net.threetag.palladium.condition.ConditionSerializers;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AbilityReference;
import net.threetag.palladium.util.context.DataContext;

public class AbilityLastTickCondition
extends Condition {
    private final AbilityReference ability;

    public AbilityLastTickCondition(AbilityReference ability) {
        this.ability = ability;
    }

    @Override
    public boolean active(DataContext context) {
        LivingEntity entity = context.getLivingEntity();
        IPowerHolder holder = context.getPowerHolder();
        if (entity == null) {
            return false;
        }
        AbilityInstance dependency = this.ability.getEntry(entity, holder);
        if (dependency == null) {
            return false;
        }
        return dependency.getPrevEnabledTicks() > dependency.getEnabledTicks();
    }

    @Override
    public ConditionSerializer getSerializer() {
        return (ConditionSerializer)ConditionSerializers.ABILITY_LAST_TICK.get();
    }

    public static class Serializer
    extends ConditionSerializer {
        public Serializer() {
            this.withProperty(AbilityEnabledCondition.Serializer.POWER, null);
            this.withProperty(AbilityEnabledCondition.Serializer.ABILITY, "ability_id");
        }

        @Override
        public Condition make(JsonObject json) {
            AbilityReference abilityReference = AbilityReference.fromString(this.getProperty(json, AbilityEnabledCondition.Serializer.ABILITY));
            if (this.getProperty(json, AbilityEnabledCondition.Serializer.POWER) != null) {
                abilityReference = new AbilityReference(this.getProperty(json, AbilityEnabledCondition.Serializer.POWER), this.getProperty(json, AbilityEnabledCondition.Serializer.ABILITY));
            }
            return new AbilityLastTickCondition(abilityReference);
        }

        @Override
        public String getDocumentationDescription() {
            return "Checks if the ability was just on its last tick.";
        }
    }
}

