/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.condition;

import com.google.gson.JsonObject;
import net.minecraft.world.entity.Entity;
import net.threetag.palladium.condition.Condition;
import net.threetag.palladium.condition.ConditionSerializer;
import net.threetag.palladium.condition.ConditionSerializers;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.context.DataContextType;
import net.threetag.palladium.util.property.IntegerProperty;
import net.threetag.palladium.util.property.PalladiumProperty;

public class BrightnessAtPositionCondition
extends Condition {
    private final int min;
    private final int max;

    public BrightnessAtPositionCondition(int minHealth, int maxHealth) {
        this.min = minHealth;
        this.max = maxHealth;
    }

    @Override
    public boolean active(DataContext context) {
        Entity entity = context.get(DataContextType.ENTITY);
        if (entity == null) {
            return false;
        }
        int brightness = entity.m_9236_().m_46803_(entity.m_20183_());
        return brightness >= this.min && brightness <= this.max;
    }

    @Override
    public ConditionSerializer getSerializer() {
        return (ConditionSerializer)ConditionSerializers.BRIGHTNESS_AT_POSITION.get();
    }

    public static class Serializer
    extends ConditionSerializer {
        public static final PalladiumProperty<Integer> MIN = new IntegerProperty("min_brightness").configurable("Minimum required brightness at entity's position");
        public static final PalladiumProperty<Integer> MAX = new IntegerProperty("max_brightness").configurable("Maximum required brightness at entity's position");

        public Serializer() {
            this.withProperty(MIN, 0);
            this.withProperty(MAX, 16);
        }

        @Override
        public Condition make(JsonObject json) {
            return new BrightnessAtPositionCondition(this.getProperty(json, MIN), this.getProperty(json, MAX));
        }

        @Override
        public String getDocumentationDescription() {
            return "Checks if the entity's brightness at it's position is within the given range.";
        }
    }
}

