/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.condition;

import com.google.gson.JsonObject;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import net.threetag.palladium.condition.Condition;
import net.threetag.palladium.condition.ConditionEnvironment;
import net.threetag.palladium.condition.ConditionSerializer;
import net.threetag.palladium.condition.ConditionSerializers;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.context.DataContextType;
import net.threetag.palladium.util.property.BooleanProperty;
import net.threetag.palladium.util.property.IntegerProperty;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.StringProperty;

public class CommandResultCondition
extends Condition
implements CommandSource {
    private final String command;
    private final String comparison;
    private final int compare_to;
    private final boolean log;

    public CommandResultCondition(String command, String comparison, int compare_to, boolean log) {
        this.command = command;
        this.comparison = comparison;
        this.compare_to = compare_to;
        this.log = log;
    }

    @Override
    public boolean active(DataContext context) {
        Entity entity = context.get(DataContextType.ENTITY);
        if (entity == null) {
            return false;
        }
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            CommandSourceStack stack = new CommandSourceStack((CommandSource)this, entity.m_20182_(), entity.m_20155_(), serverLevel, 2, entity.m_7755_().getString(), entity.m_5446_(), entity.m_9236_().m_7654_(), entity).m_81324_();
            if (!this.log) {
                stack = stack.m_81324_();
            }
            int result = serverLevel.m_7654_().m_129892_().m_230957_(stack, this.command);
            return switch (this.comparison) {
                case ">=" -> {
                    if (result >= this.compare_to) {
                        yield true;
                    }
                    yield false;
                }
                case "<=" -> {
                    if (result <= this.compare_to) {
                        yield true;
                    }
                    yield false;
                }
                case ">" -> {
                    if (result > this.compare_to) {
                        yield true;
                    }
                    yield false;
                }
                case "<" -> {
                    if (result < this.compare_to) {
                        yield true;
                    }
                    yield false;
                }
                case "!=" -> {
                    if (result != this.compare_to) {
                        yield true;
                    }
                    yield false;
                }
                case "==" -> {
                    if (result == this.compare_to) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }
        return false;
    }

    @Override
    public ConditionEnvironment getEnvironment() {
        return ConditionEnvironment.DATA;
    }

    @Override
    public ConditionSerializer getSerializer() {
        return (ConditionSerializer)ConditionSerializers.COMMAND_RESULT.get();
    }

    public void m_213846_(Component component) {
        if (this.log) {
            AddonPackLog.info("Command Result Condition Log: " + component.getString(), new Object[0]);
        }
    }

    public boolean m_6999_() {
        return this.log;
    }

    public boolean m_7028_() {
        return this.log;
    }

    public boolean m_6102_() {
        return this.log;
    }

    public static class Serializer
    extends ConditionSerializer {
        public static final PalladiumProperty<String> COMMAND = new StringProperty("command").configurable("The command output to compare the 'compare_to' int with");
        public static final PalladiumProperty<String> COMPARISON = new StringProperty("comparison").configurable("The comparison used between the 'command' and 'compare_to' fields, accepts >=, <=, >, <, !=, or == (note that the first number is from 'command' and the second from 'compare_to')");
        public static final PalladiumProperty<Integer> COMPARE_TO = new IntegerProperty("compare_to").configurable("The number being compared to the output of 'command'");
        public static final PalladiumProperty<Boolean> LOG = new BooleanProperty("log").configurable("If the command's output is sent to the entity or not (unless debugging, you probably want this false/unset)");

        public Serializer() {
            this.withProperty(COMMAND, "execute if entity @s");
            this.withProperty(COMPARISON, "==");
            this.withProperty(COMPARE_TO, 1);
            this.withProperty(LOG, false);
        }

        @Override
        public Condition make(JsonObject json) {
            return new CommandResultCondition(this.getProperty(json, COMMAND), this.getProperty(json, COMPARISON), this.getProperty(json, COMPARE_TO), this.getProperty(json, LOG));
        }

        @Override
        public String getDocumentationDescription() {
            return "Executes a command and compares the output to a number.";
        }
    }
}

