/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.condition;

import com.google.gson.JsonObject;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.threetag.palladium.condition.Condition;
import net.threetag.palladium.condition.ConditionSerializer;
import net.threetag.palladium.condition.ConditionSerializers;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.context.DataContextType;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.ResourceLocationProperty;

public class DimensionCondition
extends Condition {
    private final ResourceKey<Level> dimension;

    public DimensionCondition(ResourceKey<Level> dimension) {
        this.dimension = dimension;
    }

    @Override
    public boolean active(DataContext context) {
        Level level = context.get(DataContextType.LEVEL);
        return level != null && level.m_46472_().equals(this.dimension);
    }

    @Override
    public ConditionSerializer getSerializer() {
        return (ConditionSerializer)ConditionSerializers.DIMENSION.get();
    }

    public static class Serializer
    extends ConditionSerializer {
        public static final PalladiumProperty<ResourceLocation> DIMENSION = new ResourceLocationProperty("dimension").configurable("ID of the dimension the player must be in. Example values: minecraft:overworld, minecraft:the_nether, minecraft:the_end");

        public Serializer() {
            this.withProperty(DIMENSION, new ResourceLocation("minecraft:overworld"));
        }

        @Override
        public Condition make(JsonObject json) {
            return new DimensionCondition((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)this.getProperty(json, DIMENSION)));
        }

        @Override
        public String getDocumentationDescription() {
            return "Checks if the player is in a specific dimension.";
        }
    }
}

