/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.condition;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.threetag.palladium.condition.Condition;
import net.threetag.palladium.condition.ConditionSerializer;
import net.threetag.palladium.condition.ConditionSerializers;
import net.threetag.palladium.item.Openable;
import net.threetag.palladium.util.PlayerSlot;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.PlayerSlotProperty;

public class ItemInSlotOpenCondition
extends Condition {
    private final PlayerSlot slot;

    public ItemInSlotOpenCondition(PlayerSlot slot) {
        this.slot = slot;
    }

    @Override
    public boolean active(DataContext context) {
        LivingEntity entity = context.getLivingEntity();
        if (entity == null) {
            return false;
        }
        List<ItemStack> stacks = this.slot.getItems(entity);
        for (ItemStack stack : stacks) {
            Openable openable;
            Item item;
            if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof Openable) || !(openable = (Openable)item).isOpen(stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ConditionSerializer getSerializer() {
        return (ConditionSerializer)ConditionSerializers.ITEM_IN_SLOT_OPEN.get();
    }

    public static class Serializer
    extends ConditionSerializer {
        public static final PalladiumProperty<PlayerSlot> SLOT = new PlayerSlotProperty("slot").configurable("Slot that must contain an opened item");

        public Serializer() {
            this.withProperty(SLOT, PlayerSlot.get(EquipmentSlot.CHEST.m_20751_()));
        }

        @Override
        public Condition make(JsonObject json) {
            return new ItemInSlotOpenCondition(this.getProperty(json, SLOT));
        }

        @Override
        public String getDocumentationDescription() {
            return "Checks if the item in the given slot is opened. Needs to be using the openable-system for items.";
        }
    }
}

