/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.entity;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.threetag.palladium.util.SizeUtil;
import net.threetag.palladiumcore.network.ExtendedEntitySpawnData;
import net.threetag.palladiumcore.network.NetworkManager;
import org.jetbrains.annotations.Nullable;

public class CustomProjectile
extends ThrowableProjectile
implements ExtendedEntitySpawnData {
    public static final Map<String, Function<CompoundTag, Appearance>> APPEARANCE_REGISTRY = new HashMap<String, Function<CompoundTag, Appearance>>();
    public static Consumer<CustomProjectile> KUBEJS_EVENT_HANDLER = null;
    public ResourceLocation damageType;
    public float damage = 3.0f;
    public float gravity = 0.03f;
    public boolean dieOnBlockHit = true;
    public boolean dieOnEntityHit = true;
    public boolean preventShooterInteraction = false;
    public int lifetime = -1;
    public int setEntityOnFireSeconds = 0;
    public float explosionRadius = 0.0f;
    public boolean explosionCausesFire = false;
    public Explosion.BlockInteraction explosionBlockInteraction = Explosion.BlockInteraction.KEEP;
    public float knockbackStrength = 0.0f;
    public String commandOnEntityHit = null;
    public String commandOnBlockHit = null;
    public EntityDimensions dimensions = new EntityDimensions(0.1f, 0.1f, false);
    public List<Appearance> appearances = new ArrayList<Appearance>();

    public CustomProjectile(EntityType<? extends ThrowableProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkManager.createAddEntityPacket((Entity)this);
    }

    public boolean m_6783_(double distance) {
        return true;
    }

    public EntityDimensions m_6972_(Pose pose) {
        return this.dimensions.m_20390_(SizeUtil.getInstance().getWidthScale((Entity)this), SizeUtil.getInstance().getHeightScale((Entity)this));
    }

    protected void m_8097_() {
    }

    protected float m_7139_() {
        return this.gravity;
    }

    public boolean m_150171_(Entity entity) {
        return super.m_150171_(entity);
    }

    protected void m_5790_(EntityHitResult result) {
        Entity entity;
        if (!(this.m_9236_().f_46443_ || (entity = result.m_82443_()) == this.m_19749_() && this.preventShooterInteraction)) {
            if (this.commandOnEntityHit != null && !this.commandOnEntityHit.isBlank()) {
                this.m_9236_().m_7654_().m_129892_().m_230957_(this.m_20203_().m_81358_(2).m_81324_(), this.commandOnEntityHit);
            }
            if (this.damage > 0.0f) {
                DamageSource damageType = entity.m_9236_().m_269111_().m_269390_(this.m_19749_(), (Entity)this);
                if (this.damageType != null) {
                    damageType = this.m_269291_().m_268998_(ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)this.damageType), this.m_19749_(), (Entity)this);
                }
                entity.m_6469_(damageType, this.damage);
            }
            if (this.setEntityOnFireSeconds > 0) {
                entity.m_20254_(this.setEntityOnFireSeconds);
            }
            if (this.explosionRadius > 0.0f) {
                this.explode((Entity)this, this.m_9236_().m_269111_().m_269390_((Entity)this, this.m_19749_()), this.m_20185_(), this.m_20188_(), this.m_20189_(), this.explosionRadius, this.explosionCausesFire, this.explosionBlockInteraction);
            }
            if (this.knockbackStrength > 0.0f && entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.m_147240_((double)this.knockbackStrength, -this.m_20184_().f_82479_, -this.m_20184_().f_82481_);
            }
            if (this.dieOnEntityHit) {
                this.m_9236_().m_7605_((Entity)this, (byte)3);
                this.m_146870_();
            }
        }
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        if (!this.m_9236_().f_46443_) {
            if (this.commandOnBlockHit != null && !this.commandOnBlockHit.isBlank()) {
                this.m_9236_().m_7654_().m_129892_().m_230957_(this.m_20203_().m_81358_(2).m_81324_(), this.commandOnBlockHit);
            }
            if (this.explosionRadius > 0.0f) {
                this.explode((Entity)this, this.m_9236_().m_269111_().m_269390_((Entity)this, this.m_19749_()), this.m_20185_(), this.m_20188_(), this.m_20189_(), this.explosionRadius, this.explosionCausesFire, this.explosionBlockInteraction);
            }
            if (this.dieOnBlockHit) {
                this.m_9236_().m_7605_((Entity)this, (byte)3);
                this.m_146870_();
            }
        }
    }

    public Explosion explode(Entity source, @Nullable DamageSource damageSource, double x, double y, double z, float radius, boolean fire, Explosion.BlockInteraction blockInteraction) {
        Explosion explosion = new Explosion(source.m_9236_(), source, damageSource, null, x, y, z, radius, fire, blockInteraction);
        explosion.m_46061_();
        explosion.m_46075_(true);
        if (!explosion.m_254884_()) {
            explosion.m_46080_();
        }
        for (Player player : source.m_9236_().m_6907_()) {
            if (!(player.m_20275_(x, y, z) < 4096.0) || !(player instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundExplodePacket(x, y, z, radius, explosion.m_46081_(), (Vec3)explosion.m_46078_().get(serverPlayer)));
        }
        return explosion;
    }

    public void m_7822_(byte state) {
        if (state == 3) {
            for (Appearance appearance : this.appearances) {
                appearance.spawnParticlesOnHit(this);
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        for (Appearance appearance : this.appearances) {
            appearance.onTick(this);
        }
        if (KUBEJS_EVENT_HANDLER != null) {
            KUBEJS_EVENT_HANDLER.accept(this);
        }
        if (this.lifetime > 0 && this.f_19797_ >= this.lifetime && !this.m_9236_().f_46443_) {
            this.m_146870_();
        }
    }

    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.damageType != null) {
            compound.m_128359_("DamageType", this.damageType.toString());
        }
        compound.m_128350_("Damage", this.damage);
        compound.m_128350_("Gravity", this.gravity);
        compound.m_128379_("DieOnEntityHit", this.dieOnEntityHit);
        compound.m_128379_("DieOnBlockHit", this.dieOnBlockHit);
        compound.m_128379_("PreventShooterInteraction", this.preventShooterInteraction);
        compound.m_128350_("Size", this.dimensions.f_20377_);
        compound.m_128350_("Lifetime", (float)this.lifetime);
        compound.m_128350_("SetEntityOnFireSeconds", (float)this.setEntityOnFireSeconds);
        compound.m_128350_("ExplosionRadius", this.explosionRadius);
        compound.m_128379_("ExplosionCausesFire", this.explosionCausesFire);
        compound.m_128359_("ExplosionBlockInteraction", this.explosionBlockInteraction.toString().toLowerCase(Locale.ROOT));
        compound.m_128350_("KnockbackStrength", this.knockbackStrength);
        if (this.commandOnEntityHit != null) {
            compound.m_128359_("CommandOnEntityHit", this.commandOnEntityHit);
        }
        if (this.commandOnBlockHit != null) {
            compound.m_128359_("CommandOnBlockHit", this.commandOnBlockHit);
        }
        ListTag appearanceList = new ListTag();
        for (Appearance appearance : this.appearances) {
            CompoundTag aTag = new CompoundTag();
            aTag.m_128359_("Type", appearance.getId());
            appearance.toNBT(aTag);
            appearanceList.add((Object)aTag);
        }
        compound.m_128365_("Appearances", (Tag)appearanceList);
    }

    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("DamageType", 8)) {
            this.damageType = new ResourceLocation(compound.m_128461_("DamageType"));
        }
        if (compound.m_128425_("Damage", 99)) {
            this.damage = compound.m_128457_("Damage");
        }
        if (compound.m_128425_("Gravity", 99)) {
            this.gravity = compound.m_128457_("Gravity");
        }
        if (compound.m_128425_("Lifetime", 99)) {
            this.lifetime = compound.m_128451_("Lifetime");
        }
        if (compound.m_128425_("SetEntityOnFireSeconds", 99)) {
            this.setEntityOnFireSeconds = compound.m_128451_("SetEntityOnFireSeconds");
        }
        if (compound.m_128441_("DieOnEntityHit")) {
            this.dieOnEntityHit = compound.m_128471_("DieOnEntityHit");
        }
        if (compound.m_128441_("DieOnBlockHit")) {
            this.dieOnBlockHit = compound.m_128471_("DieOnBlockHit");
        }
        if (compound.m_128441_("PreventShooterInteraction")) {
            this.preventShooterInteraction = compound.m_128471_("PreventShooterInteraction");
        }
        if (compound.m_128425_("Size", 99)) {
            this.dimensions = new EntityDimensions(compound.m_128457_("Size"), compound.m_128457_("Size"), false);
        }
        if (compound.m_128425_("ExplosionRadius", 99)) {
            this.explosionRadius = compound.m_128457_("ExplosionRadius");
        }
        if (compound.m_128441_("ExplosionCausesFire")) {
            this.explosionCausesFire = compound.m_128471_("ExplosionCausesFire");
        }
        if (compound.m_128441_("ExplosionBlockInteraction")) {
            String type = compound.m_128461_("ExplosionBlockInteraction");
            Explosion.BlockInteraction blockInteraction = type.equalsIgnoreCase("break") ? Explosion.BlockInteraction.DESTROY : (this.explosionBlockInteraction = type.equalsIgnoreCase("destroy") ? Explosion.BlockInteraction.DESTROY_WITH_DECAY : Explosion.BlockInteraction.KEEP);
        }
        if (compound.m_128425_("KnockbackStrength", 99)) {
            this.knockbackStrength = compound.m_128457_("KnockbackStrength");
        }
        if (compound.m_128441_("CommandOnEntityHit")) {
            this.commandOnEntityHit = compound.m_128461_("CommandOnEntityHit");
        }
        if (compound.m_128441_("CommandOnBlockHit")) {
            this.commandOnBlockHit = compound.m_128461_("CommandOnBlockHit");
        }
        if (compound.m_128441_("Appearances")) {
            this.appearances = new ArrayList<Appearance>();
            ListTag listTag = compound.m_128437_("Appearances", 10);
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag aTag = listTag.m_128728_(i);
                Function<CompoundTag, Appearance> type = APPEARANCE_REGISTRY.get(aTag.m_128461_("Type"));
                if (type == null) continue;
                this.appearances.add(type.apply(aTag));
            }
        }
        this.m_6210_();
    }

    public void saveAdditionalSpawnData(FriendlyByteBuf buf) {
        CompoundTag tag = new CompoundTag();
        this.m_7380_(tag);
        buf.m_130079_(tag);
        buf.writeFloat(this.m_146909_());
        buf.writeFloat(this.m_146908_());
    }

    public void loadAdditionalSpawnData(FriendlyByteBuf buf) {
        this.m_7378_(Objects.requireNonNull(buf.m_130260_()));
        this.m_146926_(buf.readFloat());
        this.m_146922_(buf.readFloat());
    }

    static {
        APPEARANCE_REGISTRY.put("item", ItemAppearance::new);
        APPEARANCE_REGISTRY.put("particles", ParticleAppearance::new);
        APPEARANCE_REGISTRY.put("laser", LaserAppearance::new);
        APPEARANCE_REGISTRY.put("renderLayer", RenderLayerAppearance::new);
        APPEARANCE_REGISTRY.put("trail", TrailAppearance::new);
    }

    public static abstract class Appearance {
        public Appearance(CompoundTag tag) {
        }

        public abstract String getId();

        public void onTick(CustomProjectile projectile) {
        }

        public void spawnParticlesOnHit(CustomProjectile projectile) {
        }

        public abstract void toNBT(CompoundTag var1);
    }

    public static class TrailAppearance
    extends Appearance {
        public final List<ResourceLocation> trails = new ArrayList<ResourceLocation>();

        public TrailAppearance(CompoundTag tag) {
            super(tag);
            Tag trailTag = tag.m_128423_("Trail");
            if (trailTag instanceof StringTag) {
                StringTag stringTag = (StringTag)trailTag;
                this.trails.add(new ResourceLocation(stringTag.m_7916_()));
            } else if (trailTag instanceof ListTag) {
                ListTag list = (ListTag)trailTag;
                for (Tag t : list) {
                    if (!(t instanceof StringTag)) continue;
                    StringTag stringTag = (StringTag)t;
                    this.trails.add(new ResourceLocation(stringTag.m_7916_()));
                }
            }
        }

        @Override
        public String getId() {
            return "trail";
        }

        @Override
        public void toNBT(CompoundTag nbt) {
            if (this.trails.size() == 1) {
                nbt.m_128359_("Trail", this.trails.get(0).toString());
            } else {
                ListTag listTag = new ListTag();
                for (ResourceLocation layer : this.trails) {
                    listTag.add((Object)StringTag.m_129297_((String)layer.toString()));
                }
                nbt.m_128365_("Trail", (Tag)listTag);
            }
        }
    }

    public static class RenderLayerAppearance
    extends Appearance {
        public final List<ResourceLocation> renderLayers = new ArrayList<ResourceLocation>();

        public RenderLayerAppearance(CompoundTag tag) {
            super(tag);
            Tag layerTag = tag.m_128423_("RenderLayer");
            if (layerTag instanceof StringTag) {
                StringTag stringTag = (StringTag)layerTag;
                this.renderLayers.add(new ResourceLocation(stringTag.m_7916_()));
            } else if (layerTag instanceof ListTag) {
                ListTag list = (ListTag)layerTag;
                for (Tag t : list) {
                    if (!(t instanceof StringTag)) continue;
                    StringTag stringTag = (StringTag)t;
                    this.renderLayers.add(new ResourceLocation(stringTag.m_7916_()));
                }
            }
        }

        @Override
        public String getId() {
            return "renderLayer";
        }

        @Override
        public void toNBT(CompoundTag nbt) {
            if (this.renderLayers.size() == 1) {
                nbt.m_128359_("RenderLayer", this.renderLayers.get(0).toString());
            } else {
                ListTag listTag = new ListTag();
                for (ResourceLocation layer : this.renderLayers) {
                    listTag.add((Object)StringTag.m_129297_((String)layer.toString()));
                }
                nbt.m_128365_("RenderLayer", (Tag)listTag);
            }
        }
    }

    public static class LaserAppearance
    extends Appearance {
        public final float thickness;
        public final Color color;

        public LaserAppearance(CompoundTag tag) {
            super(tag);
            this.thickness = tag.m_128441_("Thickness") ? tag.m_128457_("Thickness") : 0.05f;
            Tag colorTag = tag.m_128423_("Color");
            if (colorTag instanceof StringTag) {
                StringTag stringTag = (StringTag)colorTag;
                this.color = Color.decode(stringTag.m_7916_());
            } else if (colorTag instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)colorTag;
                this.color = new Color(compoundTag.m_128451_("Red"), compoundTag.m_128451_("Green"), compoundTag.m_128451_("Blue"));
            } else {
                this.color = Color.RED;
            }
        }

        @Override
        public String getId() {
            return "laser";
        }

        @Override
        public void toNBT(CompoundTag nbt) {
            nbt.m_128350_("Thickness", this.thickness);
            CompoundTag colorTag = new CompoundTag();
            colorTag.m_128405_("Red", this.color.getRed());
            colorTag.m_128405_("Green", this.color.getGreen());
            colorTag.m_128405_("Blue", this.color.getBlue());
            nbt.m_128365_("Color", (Tag)colorTag);
        }
    }

    public static class ItemAppearance
    extends Appearance {
        public final ItemStack item;

        public ItemAppearance(CompoundTag tag) {
            super(tag);
            Tag itemTag = tag.m_128423_("Item");
            if (itemTag instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)itemTag;
                this.item = ItemStack.m_41712_((CompoundTag)compoundTag);
            } else if (itemTag instanceof StringTag) {
                StringTag stringTag = (StringTag)itemTag;
                this.item = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(stringTag.m_7916_())));
            } else {
                this.item = ItemStack.f_41583_;
            }
        }

        @Override
        public String getId() {
            return "item";
        }

        @Override
        public void toNBT(CompoundTag nbt) {
            nbt.m_128365_("Item", (Tag)this.item.m_41739_(new CompoundTag()));
        }

        @Override
        public void spawnParticlesOnHit(CustomProjectile projectile) {
            ItemParticleOption data = new ItemParticleOption(ParticleTypes.f_123752_, this.item);
            for (int i = 0; i < 8; ++i) {
                projectile.m_9236_().m_7106_((ParticleOptions)data, projectile.m_20185_(), projectile.m_20186_(), projectile.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
    }

    public static class ParticleAppearance
    extends Appearance {
        public final ParticleType type;
        public final int amount;
        public final float spread;
        public final String options;

        public ParticleAppearance(CompoundTag tag) {
            super(tag);
            this.type = tag.m_128441_("ParticleType") ? (ParticleType)BuiltInRegistries.f_257034_.m_7745_(new ResourceLocation(tag.m_128461_("ParticleType"))) : ParticleTypes.f_123744_;
            this.amount = tag.m_128441_("Amount") ? tag.m_128451_("Amount") : 1;
            this.spread = tag.m_128441_("Spread") ? tag.m_128457_("Spread") : 1.0f;
            this.options = tag.m_128441_("Options") ? tag.m_128461_("Options") : "";
        }

        @Override
        public String getId() {
            return "particles";
        }

        @Override
        public void toNBT(CompoundTag nbt) {
            if (this.type != null) {
                nbt.m_128359_("ParticleType", BuiltInRegistries.f_257034_.m_7981_((Object)this.type).toString());
            }
            nbt.m_128405_("Amount", this.amount);
            nbt.m_128350_("Spread", this.spread);
            nbt.m_128359_("Options", this.options);
        }

        @Override
        public void onTick(CustomProjectile projectile) {
            if (this.type == null) {
                return;
            }
            Random random = new Random();
            for (int i = 0; i < this.amount; ++i) {
                float sX = (random.nextFloat() - 0.5f) * this.spread * SizeUtil.getInstance().getWidthScale((Entity)projectile);
                float sY = (random.nextFloat() - 0.5f) * this.spread * SizeUtil.getInstance().getHeightScale((Entity)projectile);
                float sZ = (random.nextFloat() - 0.5f) * this.spread * SizeUtil.getInstance().getWidthScale((Entity)projectile);
                try {
                    projectile.m_9236_().m_7106_(this.type.m_123743_().m_5739_(this.type, new StringReader(this.options)), projectile.m_20185_(), projectile.m_20186_(), projectile.m_20189_(), (double)sX, (double)sY, (double)sZ);
                    continue;
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void spawnParticlesOnHit(CustomProjectile projectile) {
            if (this.type == null) {
                return;
            }
            for (int i = 0; i < this.amount; ++i) {
                Random random = new Random();
                float sX = (random.nextFloat() - 0.5f) * this.spread * 2.0f;
                float sY = (random.nextFloat() - 0.5f) * this.spread * 2.0f;
                float sZ = (random.nextFloat() - 0.5f) * this.spread * 2.0f;
                try {
                    projectile.m_9236_().m_7106_(this.type.m_123743_().m_5739_(this.type, new StringReader(this.options)), projectile.m_20185_(), projectile.m_20186_(), projectile.m_20189_(), (double)sX, (double)sY, (double)sZ);
                    continue;
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    // empty catch block
                }
            }
        }
    }
}

