/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.entity;

import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.threetag.palladium.entity.PalladiumEntityTypes;
import net.threetag.palladium.entity.effect.EntityEffect;
import net.threetag.palladium.util.property.EntityPropertyHandler;
import net.threetag.palladiumcore.network.ExtendedEntitySpawnData;
import net.threetag.palladiumcore.network.NetworkManager;

public class EffectEntity
extends Entity
implements ExtendedEntitySpawnData {
    public int anchorId;
    public Entity anchor;
    public EntityEffect entityEffect;

    public EffectEntity(EntityType<?> entityType, Level world) {
        super(entityType, world);
        this.f_19811_ = true;
    }

    public EffectEntity(Level worldIn, Entity anchor, EntityEffect entityEffect) {
        this((EntityType)PalladiumEntityTypes.EFFECT.get(), worldIn);
        this.anchorId = anchor.m_19879_();
        this.entityEffect = entityEffect;
        this.m_7678_(anchor.m_20185_(), anchor.m_20186_(), anchor.m_20189_(), anchor.m_146908_(), anchor.m_146909_());
    }

    public Entity getAnchorEntity() {
        if (this.anchor == null) {
            this.anchor = this.m_9236_().m_6815_(this.anchorId);
        }
        return this.anchor;
    }

    public void m_8119_() {
        Entity anchor = this.getAnchorEntity();
        if (anchor != null && this.entityEffect != null) {
            if (!anchor.m_6084_() || EntityEffect.IS_DONE_PLAYING.get(this).booleanValue()) {
                this.m_146870_();
            } else {
                this.entityEffect.tick(this, anchor);
                this.m_7678_(anchor.m_20185_(), anchor.m_20186_(), anchor.m_20189_(), anchor.m_146908_(), anchor.m_146909_());
            }
        } else {
            this.m_146870_();
        }
    }

    public void saveAdditionalSpawnData(FriendlyByteBuf buf) {
        buf.m_130085_(Objects.requireNonNull(EntityEffect.REGISTRY.getKey((Object)this.entityEffect)));
        buf.writeInt(this.anchorId);
        EntityPropertyHandler.getHandler(this).ifPresent(handler -> handler.toBuffer(buf));
    }

    public void loadAdditionalSpawnData(FriendlyByteBuf buf) {
        this.entityEffect = (EntityEffect)EntityEffect.REGISTRY.get(buf.m_130281_());
        this.anchorId = buf.readInt();
        EntityPropertyHandler.getHandler(this).ifPresent(handler -> handler.fromBuffer(buf));
    }

    protected void m_8097_() {
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_20147_() {
        return true;
    }

    public boolean m_6000_(double x, double y, double z) {
        return true;
    }

    protected void m_7378_(CompoundTag compound) {
        this.entityEffect = (EntityEffect)EntityEffect.REGISTRY.get(new ResourceLocation(compound.m_128461_("EntityEffect")));
        this.anchorId = compound.m_128451_("AnchorId");
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128359_("EntityEffect", Objects.requireNonNull(EntityEffect.REGISTRY.getKey((Object)this.entityEffect)).toString());
        compound.m_128405_("AnchorId", this.anchorId);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkManager.createAddEntityPacket((Entity)this);
    }
}

