/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Rotations;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.threetag.palladium.entity.PalladiumEntityTypes;
import net.threetag.palladium.item.PalladiumItems;
import net.threetag.palladiumcore.network.ExtendedEntitySpawnData;
import net.threetag.palladiumcore.network.NetworkManager;
import org.jetbrains.annotations.NotNull;

public class SuitStand
extends ArmorStand
implements ExtendedEntitySpawnData {
    private static final Rotations DEFAULT_LEFT_ARM_POSE = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations DEFAULT_RIGHT_ARM_POSE = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations DEFAULT_LEFT_LEG_POSE = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations DEFAULT_RIGHT_LEG_POSE = new Rotations(0.0f, 0.0f, 0.0f);
    private static final EntityDataAccessor<Byte> DYE_COLOR = SynchedEntityData.m_135353_(SuitStand.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);

    public SuitStand(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.m_31623_(DEFAULT_LEFT_ARM_POSE);
        this.m_31628_(DEFAULT_RIGHT_ARM_POSE);
        this.m_31639_(DEFAULT_LEFT_LEG_POSE);
        this.m_31651_(DEFAULT_RIGHT_LEG_POSE);
    }

    public SuitStand(Level level, double posX, double posY, double posZ) {
        this((EntityType)PalladiumEntityTypes.SUIT_STAND.get(), level);
        this.m_6034_(posX, posY, posZ);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DYE_COLOR, (Object)0);
        this.f_19804_.m_135381_(f_31524_, (Object)this.setBit((Byte)this.f_19804_.m_135370_(f_31524_), 4, true));
    }

    private byte setBit(byte oldBit, int offset, boolean value) {
        oldBit = value ? (byte)(oldBit | offset) : (byte)(oldBit & ~offset);
        return oldBit;
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setDyeColor(DyeColor.m_41053_((int)nbt.m_128445_("Color")));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128344_("Color", (byte)this.getDyeColor().m_41060_());
    }

    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        if (!player.m_6047_()) {
            ItemStack stack = player.m_21120_(hand);
            Item item = stack.m_41720_();
            if (item instanceof DyeItem) {
                DyeItem dyeItem = (DyeItem)item;
                this.setDyeColor(dyeItem.m_41089_());
                stack.m_41774_(1);
                return InteractionResult.SUCCESS;
            }
        } else {
            InteractionResult result = InteractionResult.FAIL;
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack standItem = this.m_6844_(slot);
                if (player.m_7500_()) {
                    player.m_8061_(slot, standItem.m_41777_());
                    if (standItem.m_41619_()) continue;
                    result = InteractionResult.SUCCESS;
                    continue;
                }
                ItemStack playerItem = player.m_6844_(slot);
                player.m_8061_(slot, standItem);
                this.m_8061_(slot, playerItem);
                if (standItem.m_41619_() && playerItem.m_41619_()) continue;
                result = InteractionResult.SUCCESS;
            }
            return result;
        }
        return super.m_7111_(player, vec, hand);
    }

    public void readSuitStandPose(CompoundTag compound) {
        ListTag listTag = compound.m_128437_("Head", 5);
        this.m_31597_(listTag.isEmpty() ? ArmorStand.f_31529_ : new Rotations(listTag));
        ListTag listTag2 = compound.m_128437_("Body", 5);
        this.m_31616_(listTag2.isEmpty() ? ArmorStand.f_31530_ : new Rotations(listTag2));
        ListTag listTag3 = compound.m_128437_("LeftArm", 5);
        this.m_31623_(listTag3.isEmpty() ? DEFAULT_LEFT_ARM_POSE : new Rotations(listTag3));
        ListTag listTag4 = compound.m_128437_("RightArm", 5);
        this.m_31628_(listTag4.isEmpty() ? DEFAULT_RIGHT_ARM_POSE : new Rotations(listTag4));
        ListTag listTag5 = compound.m_128437_("LeftLeg", 5);
        this.m_31639_(listTag5.isEmpty() ? DEFAULT_LEFT_LEG_POSE : new Rotations(listTag5));
        ListTag listTag6 = compound.m_128437_("RightLeg", 5);
        this.m_31651_(listTag6.isEmpty() ? DEFAULT_RIGHT_LEG_POSE : new Rotations(listTag6));
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)PalladiumItems.SUIT_STAND.get());
    }

    public void suitStandBrokenByPlayer(DamageSource damageSource) {
        Block.m_49840_((Level)this.m_9236_(), (BlockPos)this.m_20183_(), (ItemStack)new ItemStack((ItemLike)PalladiumItems.SUIT_STAND.get()));
        this.m_31653_(damageSource);
    }

    public void suitStandShowBreakingParticles() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50333_.m_49966_()), this.m_20185_(), this.m_20227_(0.6666666666666666), this.m_20189_(), 10, (double)(this.m_20205_() / 4.0f), (double)(this.m_20206_() / 4.0f), (double)(this.m_20205_() / 4.0f), 0.05);
        }
    }

    public DyeColor getDyeColor() {
        return DyeColor.m_41053_((int)((Byte)this.f_19804_.m_135370_(DYE_COLOR) & 0xF));
    }

    public void setDyeColor(DyeColor color) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DYE_COLOR);
        this.f_19804_.m_135381_(DYE_COLOR, (Object)((byte)(b0 & 0xF0 | color.m_41060_() & 0xF)));
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkManager.createAddEntityPacket((Entity)this);
    }

    public void saveAdditionalSpawnData(FriendlyByteBuf buf) {
        CompoundTag nbt = new CompoundTag();
        this.m_7380_(nbt);
        buf.m_130079_(nbt);
    }

    public void loadAdditionalSpawnData(FriendlyByteBuf buf) {
        this.m_7378_(buf.m_130260_());
    }
}

