/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.entity.effect;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.palladium.client.energybeam.EnergyBeamConfiguration;
import net.threetag.palladium.client.energybeam.EnergyBeamManager;
import net.threetag.palladium.entity.EffectEntity;
import net.threetag.palladium.entity.effect.EntityEffect;
import net.threetag.palladium.entity.effect.EntityEffects;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AbilityReference;
import net.threetag.palladium.power.ability.AnimationTimer;
import net.threetag.palladium.power.ability.EnergyBeamAbility;
import net.threetag.palladium.util.property.AbilityReferenceProperty;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.PropertyManager;

public class EnergyBeamEffect
extends EntityEffect {
    public static final PalladiumProperty<AbilityReference> ABILITY = new AbilityReferenceProperty("ability");

    @Override
    public void registerProperties(PropertyManager manager) {
        super.registerProperties(manager);
        manager.register(ABILITY, null);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(EffectEntity entity, Entity anchor, PoseStack poseStack, MultiBufferSource bufferSource, int packedLightIn, boolean isFirstPerson, float partialTicks) {
        if (anchor instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)anchor;
            AbilityInstance instance = this.get(entity, ABILITY).getEntry((LivingEntity)player);
            if (instance != null) {
                EnergyBeamAbility.updateTargetPos((LivingEntity)player, instance, partialTicks);
                EnergyBeamConfiguration beam = EnergyBeamManager.INSTANCE.get(instance.getProperty(EnergyBeamAbility.BEAM));
                if (beam != null) {
                    Vec3 entityPos = entity.m_20318_(partialTicks);
                    Vec3 target = instance.getProperty(EnergyBeamAbility.TARGET);
                    beam.render(player, entityPos, target, this.getLengthMultiplier(instance, partialTicks), poseStack, bufferSource, packedLightIn, isFirstPerson, partialTicks);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getLengthMultiplier(AbilityInstance instance, float partialTick) {
        Ability ability = instance.getConfiguration().getAbility();
        if (ability instanceof AnimationTimer) {
            AnimationTimer animationTimer = (AnimationTimer)((Object)ability);
            return animationTimer.getAnimationTimer(instance, partialTick, instance.getProperty(EnergyBeamAbility.SPEED).floatValue() <= 0.0f);
        }
        return 1.0f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void tick(EffectEntity entity, Entity anchor) {
        if (anchor instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)anchor;
            AbilityInstance instance = this.get(entity, ABILITY).getEntry((LivingEntity)player);
            if (instance != null) {
                boolean isDonePlaying;
                EnergyBeamConfiguration beam = EnergyBeamManager.INSTANCE.get(instance.getProperty(EnergyBeamAbility.BEAM));
                if (beam == null) {
                    this.stopPlaying(entity);
                    return;
                }
                boolean bl = instance.getProperty(EnergyBeamAbility.SPEED).floatValue() <= 0.0f ? !instance.isEnabled() : (isDonePlaying = this.getLengthMultiplier(instance, 0.0f) <= 0.0f && !instance.isEnabled());
                if (isDonePlaying != (Boolean)this.get(entity, IS_DONE_PLAYING)) {
                    this.stopPlaying(entity);
                }
            } else {
                this.stopPlaying(entity);
            }
        } else {
            this.stopPlaying(entity);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void start(Player player, AbilityReference abilityReference) {
        EffectEntity effectEntity = new EffectEntity(player.m_9236_(), (Entity)player, (EntityEffect)EntityEffects.ENERGY_BEAM.get());
        ABILITY.set(effectEntity, abilityReference);
        Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_104627_(0, (Entity)effectEntity);
    }
}

