/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.item;

import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.addonpack.parser.ItemParser;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.item.AddonAttributeContainer;
import net.threetag.palladium.item.AddonProjectileItem;
import net.threetag.palladium.item.IAddonItem;
import net.threetag.palladium.util.PlayerSlot;
import net.threetag.palladium.util.json.GsonUtil;
import org.jetbrains.annotations.Nullable;

public class AddonBowItem
extends BowItem
implements IAddonItem {
    private List<Component> tooltipLines;
    private IAddonItem.RenderLayerContainer renderLayerContainer = null;
    private final AddonAttributeContainer attributeContainer = new AddonAttributeContainer();
    private boolean shouldRenderModel = true;
    private final float velocity;
    private final float inaccuracy;
    private final int useDuration;
    private final Predicate<ItemStack> projectiles;
    @Nullable
    private final Predicate<ItemStack> heldProjectiles;

    public AddonBowItem(float velocity, float inaccuracy, int useDuration, Predicate<ItemStack> projectiles, @Nullable Predicate<ItemStack> heldProjectiles, Item.Properties properties) {
        super(properties);
        this.velocity = velocity;
        this.inaccuracy = inaccuracy;
        this.useDuration = useDuration;
        this.projectiles = projectiles;
        this.heldProjectiles = heldProjectiles;
    }

    public int m_8105_(ItemStack stack) {
        return this.useDuration;
    }

    public Predicate<ItemStack> m_6437_() {
        return this.projectiles;
    }

    public Predicate<ItemStack> m_6442_() {
        return this.heldProjectiles == null ? this.m_6437_() : this.heldProjectiles;
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            boolean bl = player.m_150110_().f_35937_ || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)stack) > 0;
            ItemStack itemStack = player.m_6298_(stack);
            if (!itemStack.m_41619_() || bl) {
                int i;
                float f;
                if (itemStack.m_41619_()) {
                    itemStack = new ItemStack((ItemLike)Items.f_42412_);
                }
                if (!((double)(f = AddonBowItem.m_40661_((int)(i = this.m_8105_(stack) - timeCharged))) < 0.1)) {
                    boolean bl2;
                    boolean bl3 = bl2 = bl && itemStack.m_150930_(Items.f_42412_);
                    if (!level.f_46443_) {
                        Item item = itemStack.m_41720_();
                        if (item instanceof AddonProjectileItem) {
                            AddonProjectileItem projectileItem = (AddonProjectileItem)item;
                            Projectile entity = projectileItem.createProjectile(level, itemStack, livingEntity);
                            if (entity != null) {
                                entity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, f * this.velocity, this.inaccuracy);
                                if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)stack) > 0) {
                                    entity.m_20254_(100);
                                }
                                level.m_7967_((Entity)entity);
                            }
                        } else {
                            int k;
                            int j;
                            ArrowItem arrowItem = (ArrowItem)(itemStack.m_41720_() instanceof ArrowItem ? itemStack.m_41720_() : Items.f_42412_);
                            AbstractArrow abstractArrow = arrowItem.m_6394_(level, itemStack, (LivingEntity)player);
                            abstractArrow.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, f * this.velocity, this.inaccuracy);
                            if (f == 1.0f) {
                                abstractArrow.m_36762_(true);
                            }
                            if ((j = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack)) > 0) {
                                abstractArrow.m_36781_(abstractArrow.m_36789_() + (double)j * 0.5 + 0.5);
                            }
                            if ((k = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)stack)) > 0) {
                                abstractArrow.m_36735_(k);
                            }
                            if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)stack) > 0) {
                                abstractArrow.m_20254_(100);
                            }
                            stack.m_41622_(1, (LivingEntity)player, player2 -> player2.m_21190_(player.m_7655_()));
                            if (bl2 || player.m_150110_().f_35937_ && (itemStack.m_150930_(Items.f_42737_) || itemStack.m_150930_(Items.f_42738_))) {
                                abstractArrow.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                            }
                            level.m_7967_((Entity)abstractArrow);
                        }
                    }
                    level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (level.m_213780_().m_188501_() * 0.4f + 1.2f) + f * 0.5f);
                    if (!bl2 && !player.m_150110_().f_35937_) {
                        itemStack.m_41774_(1);
                        if (itemStack.m_41619_()) {
                            player.m_150109_().m_36057_(itemStack);
                        }
                    }
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                }
            }
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
        if (this.tooltipLines != null) {
            tooltipComponents.addAll(this.tooltipLines);
        }
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        return this.attributeContainer.get(PlayerSlot.get(slot), (Multimap<Attribute, AttributeModifier>)super.m_7167_(slot));
    }

    @Override
    public AddonAttributeContainer getAttributeContainer() {
        return this.attributeContainer;
    }

    @Override
    public void setTooltip(List<Component> lines) {
        this.tooltipLines = lines;
    }

    @Override
    public void setRenderLayerContainer(IAddonItem.RenderLayerContainer container) {
        this.renderLayerContainer = container;
    }

    @Override
    public IAddonItem.RenderLayerContainer getRenderLayerContainer() {
        return this.renderLayerContainer;
    }

    @Override
    public void setShouldRenderModel(boolean shouldRender) {
        this.shouldRenderModel = shouldRender;
    }

    @Override
    public boolean shouldRenderModel() {
        return this.shouldRenderModel;
    }

    public static class Parser
    implements ItemParser.ItemTypeSerializer {
        @Override
        public IAddonItem parse(JsonObject json, Item.Properties properties) {
            float velocity = GsonHelper.m_13820_((JsonObject)json, (String)"velocity", (float)3.0f);
            float inaccuracy = GsonHelper.m_13820_((JsonObject)json, (String)"inaccuracy", (float)1.0f);
            int useDuration = GsonHelper.m_13824_((JsonObject)json, (String)"use_duration", (int)72000);
            TagKey projectiles = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)GsonUtil.getAsResourceLocation(json, "projectiles", new ResourceLocation("minecraft:arrows")));
            TagKey heldProjectiles = json.has("held_projectiles") ? TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)GsonUtil.getAsResourceLocation(json, "held_projectiles")) : null;
            return new AddonBowItem(velocity, inaccuracy, useDuration, stack -> stack.m_204117_(projectiles), heldProjectiles == null ? null : stack -> stack.m_204117_(heldProjectiles), properties);
        }

        @Override
        public void generateDocumentation(JsonDocumentationBuilder builder) {
            builder.setTitle("Bow");
            builder.addProperty("velocity", Float.class).description("Velocity multiplier for the shot projectile").fallback(Float.valueOf(3.0f)).exampleJson((JsonElement)new JsonPrimitive((Number)Float.valueOf(3.0f)));
            builder.addProperty("inaccuracy", Float.class).description("Inaccuracy for the shot projectile").fallback(Float.valueOf(1.0f)).exampleJson((JsonElement)new JsonPrimitive((Number)Float.valueOf(1.0f)));
            builder.addProperty("use_duration", Integer.class).description("Amount of ticks the bow can be used for").fallback(72000).exampleJson((JsonElement)new JsonPrimitive((Number)72000));
            builder.addProperty("projectiles", ResourceLocation.class).description("Item tag which contains all items that can be shot. By default all Minecraft arrows").fallback(new ResourceLocation("arrows")).exampleJson((JsonElement)new JsonPrimitive("minecraft:arrows"));
            builder.addProperty("held_projectiles", ResourceLocation.class).description("Item tag which contains all items that can be shot by being in the off hand. Can be left out to fallback to the 'projectiles' option").fallback(null).exampleJson((JsonElement)new JsonPrimitive("minecraft:arrows"));
        }

        @Override
        public ResourceLocation getId() {
            return Palladium.id("bow");
        }
    }
}

