/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.item;

import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.addonpack.parser.ItemParser;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.item.AddonAttributeContainer;
import net.threetag.palladium.item.IAddonItem;
import net.threetag.palladium.util.PlayerSlot;
import net.threetag.palladium.util.json.GsonUtil;
import org.jetbrains.annotations.Nullable;

public class AddonCrossbowItem
extends CrossbowItem
implements IAddonItem {
    private List<Component> tooltipLines;
    private IAddonItem.RenderLayerContainer renderLayerContainer = null;
    private final AddonAttributeContainer attributeContainer = new AddonAttributeContainer();
    private boolean shouldRenderModel = true;
    private final float velocityMultiplier;
    private final float inaccuracy;
    private final int useDuration;
    private final Predicate<ItemStack> projectiles;
    @Nullable
    private final Predicate<ItemStack> heldProjectiles;

    public AddonCrossbowItem(float velocityMultiplier, float inaccuracy, int useDuration, Predicate<ItemStack> projectiles, @Nullable Predicate<ItemStack> heldProjectiles, Item.Properties properties) {
        super(properties);
        this.velocityMultiplier = velocityMultiplier;
        this.inaccuracy = inaccuracy;
        this.useDuration = useDuration;
        this.projectiles = projectiles;
        this.heldProjectiles = heldProjectiles;
    }

    public int m_8105_(ItemStack stack) {
        return this.useDuration;
    }

    public Predicate<ItemStack> m_6437_() {
        return this.projectiles;
    }

    public Predicate<ItemStack> m_6442_() {
        return this.heldProjectiles == null ? this.m_6437_() : this.heldProjectiles;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemStack = player.m_21120_(usedHand);
        if (AddonCrossbowItem.m_40932_((ItemStack)itemStack)) {
            AddonCrossbowItem.m_40887_((Level)level, (LivingEntity)player, (InteractionHand)usedHand, (ItemStack)itemStack, (float)(AddonCrossbowItem.m_40945_((ItemStack)itemStack) * this.velocityMultiplier), (float)this.inaccuracy);
            AddonCrossbowItem.m_40884_((ItemStack)itemStack, (boolean)false);
            return InteractionResultHolder.m_19096_((Object)itemStack);
        }
        if (!player.m_6298_(itemStack).m_41619_()) {
            if (!AddonCrossbowItem.m_40932_((ItemStack)itemStack)) {
                this.f_40847_ = false;
                this.f_40848_ = false;
                player.m_6672_(usedHand);
            }
            return InteractionResultHolder.m_19096_((Object)itemStack);
        }
        return InteractionResultHolder.m_19100_((Object)itemStack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
        if (this.tooltipLines != null) {
            tooltipComponents.addAll(this.tooltipLines);
        }
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        return this.attributeContainer.get(PlayerSlot.get(slot), (Multimap<Attribute, AttributeModifier>)super.m_7167_(slot));
    }

    @Override
    public AddonAttributeContainer getAttributeContainer() {
        return this.attributeContainer;
    }

    @Override
    public void setTooltip(List<Component> lines) {
        this.tooltipLines = lines;
    }

    @Override
    public void setRenderLayerContainer(IAddonItem.RenderLayerContainer container) {
        this.renderLayerContainer = container;
    }

    @Override
    public IAddonItem.RenderLayerContainer getRenderLayerContainer() {
        return this.renderLayerContainer;
    }

    @Override
    public void setShouldRenderModel(boolean shouldRender) {
        this.shouldRenderModel = shouldRender;
    }

    @Override
    public boolean shouldRenderModel() {
        return this.shouldRenderModel;
    }

    public static class Parser
    implements ItemParser.ItemTypeSerializer {
        @Override
        public IAddonItem parse(JsonObject json, Item.Properties properties) {
            float velocityMultiplier = GsonHelper.m_13820_((JsonObject)json, (String)"velocity_multiplier", (float)1.0f);
            float inaccuracy = GsonHelper.m_13820_((JsonObject)json, (String)"inaccuracy", (float)1.0f);
            int useDuration = GsonHelper.m_13824_((JsonObject)json, (String)"use_duration", (int)72000);
            TagKey projectiles = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)GsonUtil.getAsResourceLocation(json, "projectiles", new ResourceLocation("minecraft:arrows")));
            TagKey heldProjectiles = json.has("held_projectiles") ? TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)GsonUtil.getAsResourceLocation(json, "held_projectiles")) : null;
            return new AddonCrossbowItem(velocityMultiplier, inaccuracy, useDuration, stack -> stack.m_204117_(projectiles), heldProjectiles == null ? null : stack -> stack.m_204117_(heldProjectiles), properties);
        }

        @Override
        public void generateDocumentation(JsonDocumentationBuilder builder) {
            builder.setTitle("Crossbow");
            builder.addProperty("velocity_multiplier", Float.class).description("Velocity multiplier for the shot projectile, works differently to the bow one.").fallback(Float.valueOf(1.0f)).exampleJson((JsonElement)new JsonPrimitive((Number)Float.valueOf(1.0f)));
            builder.addProperty("inaccuracy", Float.class).description("Inaccuracy for the shot projectile").fallback(Float.valueOf(1.0f)).exampleJson((JsonElement)new JsonPrimitive((Number)Float.valueOf(1.0f)));
            builder.addProperty("use_duration", Integer.class).description("Amount of ticks the bow can be used for").fallback(72000).exampleJson((JsonElement)new JsonPrimitive((Number)72000));
            builder.addProperty("projectiles", ResourceLocation.class).description("Item tag which contains all items that can be shot. By default all Minecraft arrows").fallback(new ResourceLocation("arrows")).exampleJson((JsonElement)new JsonPrimitive("minecraft:arrows"));
            builder.addProperty("held_projectiles", ResourceLocation.class).description("Item tag which contains all items that can be shot by being in the off hand. Can be left out to fallback to the 'projectiles' option").fallback(null).exampleJson((JsonElement)new JsonPrimitive("minecraft:arrows"));
        }

        @Override
        public ResourceLocation getId() {
            return Palladium.id("crossbow");
        }
    }
}

