/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.item;

import com.google.common.collect.Multimap;
import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.threetag.palladium.addonpack.parser.ItemParser;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.item.AddonAttributeContainer;
import net.threetag.palladium.item.IAddonItem;
import net.threetag.palladium.util.PlayerSlot;
import org.jetbrains.annotations.Nullable;

public class AddonItem
extends Item
implements IAddonItem {
    private List<Component> tooltipLines;
    private IAddonItem.RenderLayerContainer renderLayerContainer = null;
    private final AddonAttributeContainer attributeContainer = new AddonAttributeContainer();
    private boolean shouldRenderModel = true;

    public AddonItem(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
        if (this.tooltipLines != null) {
            tooltipComponents.addAll(this.tooltipLines);
        }
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        return this.attributeContainer.get(PlayerSlot.get(slot), (Multimap<Attribute, AttributeModifier>)super.m_7167_(slot));
    }

    @Override
    public AddonAttributeContainer getAttributeContainer() {
        return this.attributeContainer;
    }

    @Override
    public void setTooltip(List<Component> lines) {
        this.tooltipLines = lines;
    }

    @Override
    public void setRenderLayerContainer(IAddonItem.RenderLayerContainer container) {
        this.renderLayerContainer = container;
    }

    @Override
    public IAddonItem.RenderLayerContainer getRenderLayerContainer() {
        return this.renderLayerContainer;
    }

    @Override
    public void setShouldRenderModel(boolean shouldRender) {
        this.shouldRenderModel = shouldRender;
    }

    @Override
    public boolean shouldRenderModel() {
        return this.shouldRenderModel;
    }

    public static class Parser
    implements ItemParser.ItemTypeSerializer {
        @Override
        public IAddonItem parse(JsonObject json, Item.Properties properties) {
            return new AddonItem(properties);
        }

        @Override
        public void generateDocumentation(JsonDocumentationBuilder builder) {
            builder.setTitle("Default Item");
            builder.setDescription("Default Item Type, you don't need to specify that you want this one, leaving 'type' out of the json will make it fall back to this one.");
        }

        @Override
        public ResourceLocation getId() {
            return ItemParser.FALLBACK_SERIALIZER;
        }
    }
}

