/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.item;

import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.threetag.palladium.addonpack.parser.ItemParser;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.energy.EnergyHelper;
import net.threetag.palladium.energy.IEnergyStorage;
import net.threetag.palladium.item.AddonAttributeContainer;
import net.threetag.palladium.item.EnergyItem;
import net.threetag.palladium.item.IAddonItem;
import net.threetag.palladium.util.PlayerSlot;
import net.threetag.palladium.util.Utils;
import org.jetbrains.annotations.Nullable;

public class FluxCapacitorItem
extends EnergyItem
implements IAddonItem {
    private static final int BAR_COLOR = Mth.m_14159_((float)0.9f, (float)0.1f, (float)0.0f);
    private List<Component> tooltipLines;
    private IAddonItem.RenderLayerContainer renderLayerContainer = null;
    private final AddonAttributeContainer attributeContainer = new AddonAttributeContainer();
    private boolean shouldRenderModel = true;

    public FluxCapacitorItem(Item.Properties properties, int capacity, int maxInput, int maxOutput) {
        super(properties, capacity, maxInput, maxOutput);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        int stored = EnergyHelper.getEnergyStoredInItem(stack);
        tooltipComponents.add((Component)Component.m_237110_((String)"item.palladium.flux_capacitor.desc", (Object[])new Object[]{Component.m_237113_((String)Utils.getFormattedNumber(stored)).m_130940_(ChatFormatting.GOLD), Component.m_237113_((String)Utils.getFormattedNumber(this.getEnergyCapacity(stack))).m_130940_(ChatFormatting.GOLD)}).m_130940_(ChatFormatting.GRAY));
        if (this.tooltipLines != null) {
            tooltipComponents.addAll(this.tooltipLines);
        }
    }

    public boolean m_142522_(ItemStack stack) {
        Optional<IEnergyStorage> storage = EnergyHelper.getFromItemStack(stack);
        return storage.map(energyStorage -> energyStorage.getEnergyAmount() < energyStorage.getEnergyCapacity()).orElse(false);
    }

    public int m_142158_(ItemStack stack) {
        Optional<IEnergyStorage> storage = EnergyHelper.getFromItemStack(stack);
        return storage.map(energyStorage -> Math.round(13.0f * (float)energyStorage.getEnergyAmount() / (float)energyStorage.getEnergyCapacity())).orElse(0);
    }

    public int m_142159_(ItemStack stack) {
        return BAR_COLOR;
    }

    @Override
    public void setTooltip(List<Component> lines) {
        this.tooltipLines = lines;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        return this.attributeContainer.get(PlayerSlot.get(slot), (Multimap<Attribute, AttributeModifier>)super.m_7167_(slot));
    }

    @Override
    public AddonAttributeContainer getAttributeContainer() {
        return this.attributeContainer;
    }

    @Override
    public void setRenderLayerContainer(IAddonItem.RenderLayerContainer container) {
        this.renderLayerContainer = container;
    }

    @Override
    public IAddonItem.RenderLayerContainer getRenderLayerContainer() {
        return this.renderLayerContainer;
    }

    @Override
    public void setShouldRenderModel(boolean shouldRender) {
        this.shouldRenderModel = shouldRender;
    }

    @Override
    public boolean shouldRenderModel() {
        return this.shouldRenderModel;
    }

    public ItemStack getEmptyInstance() {
        ItemStack filled = this.m_7968_();
        filled.m_41784_().m_128405_("energy", 0);
        return filled;
    }

    public ItemStack getFullyChargedInstance() {
        ItemStack filled = this.m_7968_();
        filled.m_41784_().m_128405_("energy", this.getEnergyCapacity(filled));
        return filled;
    }

    public static class Parser
    implements ItemParser.ItemTypeSerializer {
        @Override
        public IAddonItem parse(JsonObject json, Item.Properties properties) {
            int capacity = GsonHelper.m_13927_((JsonObject)json, (String)"capacity");
            int maxInput = GsonHelper.m_13927_((JsonObject)json, (String)"max_input");
            int maxOutput = GsonHelper.m_13927_((JsonObject)json, (String)"max_output");
            if (capacity <= 0) {
                throw new JsonParseException("Energy capacity must be greater than 0");
            }
            if (maxInput < 0) {
                throw new JsonParseException("Energy max input can not be negative");
            }
            if (maxOutput < 0) {
                throw new JsonParseException("Energy max output can not be negative");
            }
            return new FluxCapacitorItem(properties, capacity, maxInput, maxOutput);
        }

        @Override
        public void generateDocumentation(JsonDocumentationBuilder builder) {
            builder.setTitle("Flux Capacitor (Energy Containing Item)");
            builder.addProperty("capacity", Integer.class).description("Max amount of energy the item can hold").required().exampleJson((JsonElement)new JsonPrimitive((Number)500000));
            builder.addProperty("max_input", Integer.class).description("Maximum amount of energy the item can be inserted with during one insertion. Using 0 makes the item not accept any energy").required().exampleJson((JsonElement)new JsonPrimitive((Number)1000));
            builder.addProperty("max_output", Integer.class).description("Maximum amount of energy the item can extract with during one withdrawal. Using 0 makes the item not extract any energy").required().exampleJson((JsonElement)new JsonPrimitive((Number)1000));
        }

        @Override
        public ResourceLocation getId() {
            return new ResourceLocation("palladium", "flux_capacitor");
        }
    }
}

