/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.item;

import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface Openable {
    public static final String OPEN_TAG = "Palladium:Opened";
    public static final String OPENING_TAG = "Palladium:Opening";

    default public boolean canBeOpened(LivingEntity entity, ItemStack stack) {
        return true;
    }

    default public int getOpeningTime(ItemStack stack) {
        return 0;
    }

    default public void setOpen(LivingEntity entity, ItemStack stack, boolean open) {
        if (!(entity.m_9236_().f_46443_ || this.isOpen(stack) == open || open && !this.canBeOpened(entity, stack))) {
            CompoundTag nbt = stack.m_41784_();
            nbt.m_128379_(OPEN_TAG, open);
            this.onOpeningStateChange(entity, stack, open);
            if (this.getOpeningTime(stack) <= 0) {
                if (open) {
                    this.onFullyOpened(entity, stack);
                } else {
                    this.onFullyClosed(entity, stack);
                }
            }
        }
    }

    default public boolean isOpen(ItemStack stack) {
        return stack.m_41782_() && Objects.requireNonNull(stack.m_41783_()).m_128471_(OPEN_TAG);
    }

    default public int getOpeningProgress(ItemStack stack) {
        return stack.m_41782_() ? Objects.requireNonNull(stack.m_41783_()).m_128451_(OPENING_TAG) : 0;
    }

    default public void onOpeningStateChange(LivingEntity entity, ItemStack stack, boolean open) {
    }

    default public void onFullyOpened(LivingEntity entity, ItemStack stack) {
    }

    default public void onFullyClosed(LivingEntity entity, ItemStack stack) {
    }

    public static void onTick(LivingEntity entity, ItemStack stack) {
        Item item;
        if (!entity.m_9236_().f_46443_ && (item = stack.m_41720_()) instanceof Openable) {
            Openable openable = (Openable)item;
            CompoundTag nbt = stack.m_41784_();
            int max = openable.getOpeningTime(stack);
            if (max > 0) {
                int timer = nbt.m_128451_(OPENING_TAG);
                boolean isOpen = openable.isOpen(stack);
                if (isOpen && !openable.canBeOpened(entity, stack)) {
                    isOpen = false;
                    nbt.m_128379_(OPEN_TAG, isOpen);
                    openable.onOpeningStateChange(entity, stack, isOpen);
                }
                if (isOpen && timer < max) {
                    nbt.m_128405_(OPENING_TAG, ++timer);
                    if (timer == max) {
                        openable.onFullyOpened(entity, stack);
                    }
                } else if (!isOpen && timer > 0) {
                    nbt.m_128405_(OPENING_TAG, --timer);
                    if (timer == 0) {
                        openable.onFullyClosed(entity, stack);
                    }
                }
            }
        }
    }
}

