/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.mixin;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.threetag.palladium.entity.SuitStand;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ArmorStand.class})
public class ArmorStandMixin {
    @Inject(method={"readPose"}, at={@At(value="HEAD")}, cancellable=true)
    private void readPose(CompoundTag nbt, CallbackInfo ci) {
        ArmorStand armorStand = (ArmorStand)this;
        if (armorStand instanceof SuitStand) {
            SuitStand suitStand = (SuitStand)armorStand;
            suitStand.readSuitStandPose(nbt);
            ci.cancel();
        }
    }

    @Inject(method={"brokenByPlayer"}, at={@At(value="HEAD")}, cancellable=true)
    private void brokenByPlayer(DamageSource damageSource, CallbackInfo ci) {
        ArmorStand armorStand = (ArmorStand)this;
        if (armorStand instanceof SuitStand) {
            SuitStand suitStand = (SuitStand)armorStand;
            suitStand.suitStandBrokenByPlayer(damageSource);
            ci.cancel();
        }
    }

    @Inject(method={"showBreakingParticles"}, at={@At(value="HEAD")}, cancellable=true)
    private void showBreakingParticles(CallbackInfo ci) {
        ArmorStand armorStand = (ArmorStand)this;
        if (armorStand instanceof SuitStand) {
            SuitStand suitStand = (SuitStand)armorStand;
            suitStand.suitStandShowBreakingParticles();
            ci.cancel();
        }
    }
}

