/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.mixin;

import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.level.Level;
import net.threetag.palladium.client.renderer.renderlayer.RenderLayerStates;
import net.threetag.palladium.entity.PalladiumAttributes;
import net.threetag.palladium.entity.PalladiumEntityExtension;
import net.threetag.palladium.entity.PalladiumLivingEntityExtension;
import net.threetag.palladium.power.PowerHandler;
import net.threetag.palladium.power.ability.Abilities;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
implements PalladiumLivingEntityExtension {
    @Unique
    private PowerHandler palladium$powerHandler;
    @Unique
    private RenderLayerStates palladium$renderLayerStates;

    @Shadow
    public abstract AttributeMap m_21204_();

    @Shadow
    public abstract void m_269405_(double var1, double var3);

    @Shadow
    public abstract void m_21153_(float var1);

    @Shadow
    public abstract boolean m_21219_();

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void init(EntityType entityType, Level level, CallbackInfo ci) {
        this.palladium$powerHandler = new PowerHandler((LivingEntity)this);
        this.palladium$renderLayerStates = new RenderLayerStates();
    }

    @Inject(method={"getJumpPower"}, at={@At(value="RETURN")}, cancellable=true)
    protected void getJumpPower(CallbackInfoReturnable<Float> cir) {
        if (this.m_21204_().m_22171_((Attribute)PalladiumAttributes.JUMP_POWER.get())) {
            AttributeInstance instance = this.m_21204_().m_22146_((Attribute)PalladiumAttributes.JUMP_POWER.get());
            cir.setReturnValue((Object)Float.valueOf((float)Objects.requireNonNull(instance).m_22135_() * ((Float)cir.getReturnValue()).floatValue()));
        }
    }

    @Inject(method={"checkTotemDeathProtection"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkTotemDeathProtection(DamageSource damageSource, CallbackInfoReturnable<Boolean> cir) {
        if (!damageSource.m_269533_(DamageTypeTags.f_268738_) && AbilityUtil.isTypeEnabled((LivingEntity)this, (Ability)Abilities.IMMORTALITY.get())) {
            this.m_21153_(1.0f);
            this.m_21219_();
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void tick(CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        if (entity.m_9236_().f_46443_ && entity instanceof PalladiumEntityExtension) {
            PalladiumEntityExtension ext = (PalladiumEntityExtension)entity;
            this.palladium$renderLayerStates.tick(entity);
            ext.palladium$getTrailHandler().tick();
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="RETURN")})
    public void readAdditionalSaveData(CompoundTag compound, CallbackInfo ci) {
        CompoundTag palladiumTag;
        CompoundTag compoundTag = palladiumTag = compound.m_128441_("Palladium") ? compound.m_128469_("Palladium") : new CompoundTag();
        if (palladiumTag.m_128425_("Powers", 10)) {
            this.palladium$powerHandler.fromNBT(palladiumTag.m_128469_("Powers"));
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="RETURN")})
    public void addAdditionalSaveData(CompoundTag compound, CallbackInfo ci) {
        CompoundTag palladiumTag = compound.m_128441_("Palladium") ? compound.m_128469_("Palladium") : new CompoundTag();
        palladiumTag.m_128365_("Powers", (Tag)this.palladium$powerHandler.toNBT());
        compound.m_128365_("Palladium", (Tag)palladiumTag);
    }

    @Override
    public PowerHandler palladium$getPowerHandler() {
        return this.palladium$powerHandler;
    }

    @Override
    public RenderLayerStates palladium$getRenderLayerStates() {
        return this.palladium$renderLayerStates;
    }
}

